/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.wsbnd.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.StringType;
import com.ibm.ws.javaee.ddmodel.wsbnd.HttpPublishing;
import com.ibm.ws.javaee.ddmodel.wsbnd.ServiceRef;
import com.ibm.ws.javaee.ddmodel.wsbnd.WebserviceDescription;
import com.ibm.ws.javaee.ddmodel.wsbnd.WebserviceEndpoint;
import com.ibm.ws.javaee.ddmodel.wsbnd.WebservicesBnd;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.HttpPublishingType;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.ServiceRefType;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.WebserviceDescriptionType;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.WebserviceEndpointPropertiesType;
import com.ibm.ws.javaee.ddmodel.wsbnd.impl.WebserviceEndpointType;
import com.ibm.ws.javaee.ddmodel.wsbnd.internal.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebservicesBndType
extends DDParser.ElementContentParsable
implements WebservicesBnd,
DDParser.RootParsable {
    private final String path;
    private StringType version;
    private DDParser.ComponentIDMap idMap;
    private final Map<String, WebserviceDescriptionType> webserviceDescriptionTypeMap = new HashMap<String, WebserviceDescriptionType>();
    private WebserviceEndpointPropertiesType webserviceEndpointProperties;
    private final Map<String, WebserviceEndpointType> webserviceEndpointTypeMap = new HashMap<String, WebserviceEndpointType>();
    private HttpPublishingType httpPublishingType;
    private Map<String, ServiceRefType> serviceRefTypeMap = new HashMap<String, ServiceRefType>();
    private final Map<String, ServiceRefType> ejbServiceRefTypeMap = new HashMap<String, ServiceRefType>();
    static final long serialVersionUID = -7103105004261817689L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebservicesBndType(String path) {
        this.path = path;
    }

    public String getDeploymentDescriptorPath() {
        return this.path;
    }

    public Object getComponentForId(String id) {
        return this.idMap.getComponentForId(id);
    }

    public String getIdForComponent(Object ddComponent) {
        return this.idMap.getIdForComponent(ddComponent);
    }

    @Override
    public List<WebserviceDescription> getWebserviceDescriptions() {
        ArrayList<WebserviceDescriptionType> webserviceDescriptionList = null;
        if (null != this.webserviceDescriptionTypeMap) {
            webserviceDescriptionList = new ArrayList<WebserviceDescriptionType>(this.webserviceDescriptionTypeMap.values());
        }
        return webserviceDescriptionList;
    }

    @Override
    public WebserviceDescription getWebserviceDescription(String WebserviceDescriptionName) {
        return WebserviceDescriptionName != null ? (WebserviceDescription)this.webserviceDescriptionTypeMap.get(WebserviceDescriptionName.trim()) : null;
    }

    @Override
    public Map<String, String> getWebserviceEndpointProperties() {
        return null != this.webserviceEndpointProperties ? this.webserviceEndpointProperties.getAttributes() : null;
    }

    @Override
    public List<WebserviceEndpoint> getWebserviceEndpoints() {
        ArrayList<WebserviceEndpointType> webserviceEndpointList = null;
        if (null != this.webserviceEndpointTypeMap) {
            webserviceEndpointList = new ArrayList<WebserviceEndpointType>(this.webserviceEndpointTypeMap.values());
        }
        return webserviceEndpointList;
    }

    @Override
    public WebserviceEndpoint getWebserviceEndpoint(String portComponentName) {
        return portComponentName != null ? (WebserviceEndpoint)this.webserviceEndpointTypeMap.get(portComponentName.trim()) : null;
    }

    @Override
    public HttpPublishing getHttpPublishing() {
        return this.httpPublishingType;
    }

    @Override
    public List<ServiceRef> getServiceRefs() {
        ArrayList<ServiceRefType> serviceRefList = null;
        if (null != this.serviceRefTypeMap) {
            serviceRefList = new ArrayList<ServiceRefType>(this.serviceRefTypeMap.values());
        }
        if (null != this.ejbServiceRefTypeMap) {
            Collection<ServiceRefType> ejbServiceRefs = this.ejbServiceRefTypeMap.values();
            if (null != serviceRefList) {
                serviceRefList.addAll(ejbServiceRefs);
            } else {
                serviceRefList = new ArrayList<ServiceRefType>(ejbServiceRefs);
            }
        }
        return serviceRefList == null ? Collections.emptyList() : serviceRefList;
    }

    @Override
    public ServiceRef getServiceRef(String serviceRefName, String componentName) {
        if (StringUtils.isEmpty(serviceRefName)) {
            return null;
        }
        ServiceRef serviceRef = null;
        if (!StringUtils.isEmpty(componentName)) {
            String serviceRefKey = StringUtils.getEJBServiceRefKey(serviceRefName, componentName);
            serviceRef = this.ejbServiceRefTypeMap.get(serviceRefKey);
        }
        if (null == serviceRef) {
            serviceRef = this.serviceRefTypeMap.get(serviceRefName.trim());
        }
        return serviceRef;
    }

    public boolean isIdAllowed() {
        return true;
    }

    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        if (nsURI == null && "version".equals(localName)) {
            this.version = parser.parseStringAttributeValue(index);
            return true;
        }
        return false;
    }

    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if ("webservice-description".equals(localName)) {
            WebserviceDescriptionType webserviceDescriptionType = new WebserviceDescriptionType();
            parser.parse((DDParser.ParsableElement)webserviceDescriptionType);
            String webserviceDescriptionName = webserviceDescriptionType.getWebserviceDescriptionName();
            if (StringUtils.isEmpty(webserviceDescriptionName)) {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("webservice-description-name"));
            }
            this.addWebserviceType(webserviceDescriptionType);
            return true;
        }
        if ("webservice-endpoint".equals(localName)) {
            WebserviceEndpointType webserviceEndpointType = new WebserviceEndpointType();
            parser.parse((DDParser.ParsableElement)webserviceEndpointType);
            String portComponentName = webserviceEndpointType.getPortComponentName();
            if (StringUtils.isEmpty(portComponentName)) {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("port-component-name"));
            }
            this.addServiceEndpointType(webserviceEndpointType);
            return true;
        }
        if ("http-publishing".equals(localName)) {
            this.httpPublishingType = new HttpPublishingType();
            parser.parse((DDParser.ParsableElement)this.httpPublishingType);
            return true;
        }
        if ("service-ref".equals(localName)) {
            ServiceRefType serviceRefType = new ServiceRefType();
            parser.parse((DDParser.ParsableElement)serviceRefType);
            String serviceRefName = serviceRefType.getName();
            if (StringUtils.isEmpty(serviceRefName)) {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("name"));
            }
            this.addServiceRefType(serviceRefType);
            return true;
        }
        if ("webservice-endpoint-properties".equals(localName)) {
            this.webserviceEndpointProperties = new WebserviceEndpointPropertiesType();
            parser.parse((DDParser.ParsableElement)this.webserviceEndpointProperties);
            return true;
        }
        return false;
    }

    private void addWebserviceType(WebserviceDescriptionType webserviceType) {
        String serviceName = webserviceType.getWebserviceDescriptionName();
        if (!StringUtils.isEmpty(serviceName)) {
            this.webserviceDescriptionTypeMap.put(serviceName.trim(), webserviceType);
        }
    }

    private void addServiceEndpointType(WebserviceEndpointType serviceEnpointType) {
        String portComponentName = serviceEnpointType.getPortComponentName();
        if (!StringUtils.isEmpty(portComponentName)) {
            this.webserviceEndpointTypeMap.put(portComponentName.trim(), serviceEnpointType);
        }
    }

    private void addServiceRefType(ServiceRefType serviceRefType) {
        String serviceRefName = serviceRefType.getName();
        if (StringUtils.isEmpty(serviceRefName)) {
            return;
        }
        String componentName = serviceRefType.getComponentName();
        if (StringUtils.isEmpty(componentName)) {
            this.serviceRefTypeMap.put(serviceRefName.trim(), serviceRefType);
        } else {
            String serviceRefKey = StringUtils.getEJBServiceRefKey(serviceRefName, componentName);
            this.ejbServiceRefTypeMap.put(serviceRefKey, serviceRefType);
        }
    }

    protected String toTracingSafeString() {
        return "webservices-bnd";
    }

    public void describe(StringBuilder sb) {
        DDParser.Diagnostics diag = new DDParser.Diagnostics(this.idMap, sb);
        diag.describe(this.toTracingSafeString(), (DDParser.ParsableElement)this);
    }

    public void describe(DDParser.Diagnostics diag) {
        String prefix;
        diag.describeIfSet("version", (DDParser.ParsableElement)this.version);
        diag.describe("webservice-endpoint-properties", (DDParser.ParsableElement)this.webserviceEndpointProperties);
        diag.append("[webservice-description<");
        if (null != this.webserviceDescriptionTypeMap) {
            prefix = "";
            for (WebserviceDescriptionType webserviceType : this.webserviceDescriptionTypeMap.values()) {
                diag.append(prefix);
                webserviceType.describe(diag);
                prefix = ",";
            }
        }
        diag.append(">]");
        diag.append("[webservice-endpoint<");
        if (null != this.webserviceEndpointTypeMap) {
            prefix = "";
            for (WebserviceEndpointType serviceEndpointType : this.webserviceEndpointTypeMap.values()) {
                diag.append(prefix);
                serviceEndpointType.describe(diag);
                prefix = ",";
            }
        }
        diag.append(">]");
        diag.append("[http-publishing<");
        if (null != this.httpPublishingType) {
            this.httpPublishingType.describe(diag);
        }
        diag.append(">]");
        diag.append("[service-ref<");
        if (null != this.serviceRefTypeMap) {
            prefix = "";
            for (ServiceRefType serviceRefType : this.serviceRefTypeMap.values()) {
                diag.append(prefix);
                serviceRefType.describe(diag);
                prefix = ",";
            }
        }
        diag.append(">]");
    }

    public void finish(DDParser parser) throws DDParser.ParseException {
        this.idMap = parser.idMap;
        super.finish(parser);
    }

    public static WebservicesBndType createWebServicesBndType(String path, StringType version, Map<String, ServiceRefType> serviceRefMap) {
        WebservicesBndType wsbnd = new WebservicesBndType(path);
        wsbnd.version = version;
        wsbnd.serviceRefTypeMap = serviceRefMap;
        wsbnd.idMap = new DDParser.ComponentIDMap();
        return wsbnd;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.wsbnd.impl.WebservicesBndType", WebservicesBndType.class, null, null);
    }
}

