/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.dopriv.SetAccessiblePrivilegedAction;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public class InjectionTargetField
extends InjectionTarget {
    private static final String CLASS_NAME = InjectionTargetField.class.getName();
    private static final TraceComponent tc = Tr.register(InjectionTargetField.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    Field ivField = null;

    protected InjectionTargetField(Field field, InjectionBinding<?> binding) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + field), (Object[])new Object[0]);
        }
        boolean isFromClient = binding.ivNameSpaceConfig.isClientMain(field.getDeclaringClass());
        int fieldModifiers = field.getModifiers();
        if (Modifier.isFinal(fieldModifiers)) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_TARGET_FIELD_MUST_NOT_BE_FINAL_CWNEN0019E", (Object[])new Object[]{field.getName()});
            InjectionConfigurationException icex = new InjectionConfigurationException("The injection target field " + field.getName() + " must not be declared final");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("<init> : " + icex));
            }
            throw icex;
        }
        if (Modifier.isStatic(fieldModifiers) && !isFromClient) {
            Tr.warning((TraceComponent)tc, (String)"INJECTION_TARGET_MUST_NOT_BE_STATIC_CWNEN0057W", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
            if (binding.isValidationFailable()) {
                throw new InjectionConfigurationException("The " + field.getDeclaringClass().getName() + "." + field.getName() + " injection target must not be declared static.");
            }
        } else if (!Modifier.isStatic(fieldModifiers) && isFromClient) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_TARGET_IN_CLIENT_MUST_BE_STATIC_CWNEN0058E", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
            InjectionConfigurationException icex = new InjectionConfigurationException("The injection target field " + field.getName() + " must be declared static in the client container.");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("<init> : " + icex));
            }
            throw icex;
        }
        if (!Modifier.isPublic(fieldModifiers)) {
            try {
                SetAccessiblePrivilegedAction privilegedFieldAction = new SetAccessiblePrivilegedAction((AccessibleObject)field, true);
                AccessController.doPrivileged(privilegedFieldAction);
            }
            catch (PrivilegedActionException paex) {
                FFDCFilter.processException((Throwable)paex, (String)(CLASS_NAME + ".<init>"), (String)"97", (Object)this, (Object[])new Object[]{field, binding});
                SecurityException ex = (SecurityException)paex.getException();
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("<init> : " + ex));
                }
                throw ex;
            }
        }
        binding.setInjectionClassType(field.getType());
        this.ivField = field;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this.ivField));
        }
    }

    @Override
    public Member getMember() {
        return this.ivField;
    }

    @Override
    public Class<?> getInjectionClassType() {
        return this.ivField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.ivField.getGenericType();
    }

    @Override
    protected void injectMember(Object objectToInject, Object dependentObject) throws Exception {
        this.ivField.set(objectToInject, dependentObject);
    }
}

