/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.tcpchannel.internal.CancelRequest;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class ChannelSelector
implements Runnable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(ChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected static final long TEN_MINUTES = 600000L;
    protected volatile boolean quit = false;
    protected Selector selector = null;
    protected boolean selectorYield = false;
    protected long nextTimeoutTime;
    boolean waitingToQuit = false;
    protected long currentTime;
    private final List<CancelRequest> cancelList = new ArrayList<CancelRequest>();
    private Queue<Object> workQueue1 = null;
    private Queue<Object> workQueue2 = null;
    private final Object queueLock = new QueueLock();
    protected boolean wakeupPending = false;
    boolean checkCancel = false;

    public ChannelSelector(boolean _checkCancel) throws IOException {
        this.selector = Selector.open();
        this.selectorYield = TCPFactoryConfiguration.getSelectorYield();
        this.checkCancel = _checkCancel;
        this.workQueue1 = new LinkedList<Object>();
        this.workQueue2 = new LinkedList<Object>();
    }

    @Override
    public void run() {
        boolean cancelledDone = false;
        boolean forceSelect = false;
        long selectTimeoutValue = 0L;
        int numEmptySelects = 0;
        int numExceptions = 0;
        boolean nothingTimedOut = true;
        long firstEmptySelectorTime = 0L;
        int numKeysOnEmptySelect = -1;
        long lastEmptySelectorFFDCTime = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("selector thread started for " + Thread.currentThread().getName()), (Object[])new Object[0]);
        }
        this.nextTimeoutTime = this.currentTime + TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
        while (!this.quit) {
            this.currentTime = CHFWBundle.getApproxTime();
            try {
                nothingTimedOut = true;
                if (this.selectorYield) {
                    Thread.yield();
                }
                this.wakeupPending = false;
                if (this.checkCancel && forceSelect) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"selectNow() forced", (Object[])new Object[0]);
                    }
                    this.selector.selectNow();
                    forceSelect = false;
                    numEmptySelects = 0;
                } else if (this.nextTimeoutTime > this.currentTime) {
                    selectTimeoutValue = this.nextTimeoutTime - this.currentTime;
                    if (selectTimeoutValue < 1000L) {
                        selectTimeoutValue = 1000L;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("select() with timeout = " + selectTimeoutValue), (Object[])new Object[0]);
                    }
                    this.selector.select(selectTimeoutValue);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"selectNow()", (Object[])new Object[0]);
                    }
                    this.selector.selectNow();
                    nothingTimedOut = false;
                    numEmptySelects = 0;
                }
                this.wakeupPending = false;
                if (this.checkCancel && cancelledDone) {
                    this.notifyCancelRequests();
                    cancelledDone = false;
                }
                this.currentTime = CHFWBundle.getApproxTime();
                if (this.checkCancel && (cancelledDone = this.processCancelRequests())) {
                    forceSelect = true;
                    continue;
                }
                if (this.selector.selectedKeys().isEmpty() && nothingTimedOut && this.areQueuesEmpty()) {
                    if (numEmptySelects == 0) {
                        firstEmptySelectorTime = this.currentTime;
                        numKeysOnEmptySelect = this.selector.keys().size();
                    }
                    if (++numEmptySelects == 40) {
                        if (this.currentTime < firstEmptySelectorTime + 10000L && this.selector.keys().size() == numKeysOnEmptySelect) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"Selector fired 20 times in a row with no keys selected - possible loop in JDK detected", (Object[])new Object[0]);
                            }
                            if (this.currentTime > lastEmptySelectorFFDCTime + 300000L) {
                                ChannelException e = new ChannelException("TCP Channel detected a possible loop on thread: " + Thread.currentThread().getName());
                                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"186", (Object)this, (Object[])new Object[]{"Last FFDC time=" + lastEmptySelectorFFDCTime, "Current time=" + this.currentTime, "Next timeout time=" + this.nextTimeoutTime, "First empty select time=" + firstEmptySelectorTime, "First empty select keys=" + numKeysOnEmptySelect, "Number empty selects=" + numEmptySelects, "Thread interrupted=" + Thread.interrupted(), this.workQueue1, this.workQueue2});
                                lastEmptySelectorFFDCTime = this.currentTime;
                            }
                        }
                        numEmptySelects = 0;
                    }
                } else {
                    numEmptySelects = 0;
                }
                if (this.performRequest()) continue;
                this.updateCount();
                this.checkForTimeouts();
                this.updateSelector();
                numExceptions = 0;
            }
            catch (IOException e) {
                if (!FrameworkState.isStopping()) {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"288", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("IOException (" + numExceptions + ") in run " + e), (Object[])new Object[0]);
                }
                ++numExceptions;
            }
            catch (Throwable unexpectedException) {
                if (!FrameworkState.isStopping()) {
                    FFDCFilter.processException((Throwable)unexpectedException, (String)this.getClass().getName(), (String)"254", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Exception (" + numExceptions + ") in run " + unexpectedException), (Object[])new Object[0]);
                }
                this.nextTimeoutTime = this.currentTime;
                ++numExceptions;
            }
            if (numExceptions >= 400) {
                if (!this.pauseAccept()) continue;
                numExceptions = 0;
                continue;
            }
            if (numExceptions < 100) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.channelSelectorClose();
    }

    protected boolean pauseAccept() {
        Tr.error((TraceComponent)tc, (String)"TCP_NOT_ACCEPTING", (Object[])new Object[0]);
        ChannelException exitEx = new ChannelException("TCP Channel detected continuous exceptions while trying to accept connections and is pausing accepts for thread: " + Thread.currentThread().getName());
        FFDCFilter.processException((Throwable)exitEx, (String)this.getClass().getName(), (String)"278", (Object)this);
        try {
            Thread.sleep(600000L);
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    abstract void updateCount();

    protected void shutDown() {
        this.quit = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areQueuesEmpty() {
        Object object = this.queueLock;
        synchronized (object) {
            return this.workQueue1.isEmpty() && this.workQueue2.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToWorkQueue(Object work) {
        Object object = this.queueLock;
        synchronized (object) {
            this.workQueue1.add(work);
        }
    }

    public final SelectionKey getKey(SocketChannel channel) {
        if (null == channel) {
            return null;
        }
        return channel.keyFor(this.selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Queue<Object> getWorkQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            Queue<Object> tmp = this.workQueue1;
            this.workQueue1 = this.workQueue2;
            this.workQueue2 = tmp;
            return tmp;
        }
    }

    abstract void channelSelectorClose();

    abstract boolean performRequest();

    abstract void updateSelector();

    abstract void checkForTimeouts();

    public String[] introspectSelf() {
        ArrayList<String> rc = new ArrayList<String>();
        rc.add(Thread.currentThread().getName());
        rc.add("quit: " + this.quit);
        rc.add("waitingToQuit: " + this.waitingToQuit);
        rc.add("# of keys=" + this.selector.keys().size());
        try {
            for (SelectionKey key : this.selector.keys()) {
                rc.add("key: " + key.hashCode() + " valid=" + key.isValid() + " ops=" + key.interestOps() + " " + key.channel());
            }
        }
        catch (Throwable x) {
            rc.add("Exception Occurred Gathering Dump Data: " + x);
        }
        return rc.toArray(new String[rc.size()]);
    }

    protected void addWork(Object toAdd) {
        this.addToWorkQueue(toAdd);
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"notifyCancelRequests", (Object[])new Object[0]);
        }
        CancelRequest req = null;
        List<CancelRequest> list = this.cancelList;
        synchronized (list) {
            Iterator<CancelRequest> it = this.cancelList.iterator();
            while (it.hasNext()) {
                req = it.next();
                if (req.state != 2) continue;
                it.remove();
                CancelRequest cancelRequest = req;
                synchronized (cancelRequest) {
                    req.state = 0;
                    req.notify();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"notifyCancelRequests");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCancelRequests() {
        if (this.cancelList.size() == 0) {
            return false;
        }
        boolean needSelectToOccur = false;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        List<CancelRequest> list = this.cancelList;
        synchronized (list) {
            for (CancelRequest req : this.cancelList) {
                if (req.state != 1) continue;
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("cancelling key " + req.key), (Object[])new Object[0]);
                }
                req.key.cancel();
                req.state = 2;
                needSelectToOccur = true;
            }
        }
        return needSelectToOccur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCancelRequest(CancelRequest cr) {
        List<CancelRequest> list = this.cancelList;
        synchronized (list) {
            this.cancelList.add(cr);
        }
        this.wakeup();
    }

    protected void wakeup() {
        this.selector.wakeup();
    }

    protected void resetTimeout(long newTimeoutTime) {
        if (newTimeoutTime < this.nextTimeoutTime) {
            this.nextTimeoutTime = newTimeoutTime;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"resetTimeout waking up selector", (Object[])new Object[0]);
            }
            this.wakeup();
        }
    }

    private static class QueueLock {
        protected QueueLock() {
        }

        public String toString() {
            return "Selector queue lock";
        }
    }
}

