/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.monitor.meters;

import com.ibm.websphere.monitor.meters.GaugeMXBean;
import com.ibm.websphere.monitor.meters.GaugeReading;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.concurrent.atomic.AtomicLong;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class Gauge
extends Meter
implements GaugeMXBean {
    private boolean observedFirstValue = false;
    private boolean bounded = false;
    long lowerBound = Long.MIN_VALUE;
    long upperBound = Long.MAX_VALUE;
    final AtomicLong currentValue = new AtomicLong();
    final AtomicLong maximumValue = new AtomicLong(Long.MIN_VALUE);
    final AtomicLong minimumValue = new AtomicLong(Long.MAX_VALUE);
    static final long serialVersionUID = 3460650491609091058L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public long getCurrentValue() {
        return this.currentValue.get();
    }

    @Override
    public long getMaximumValue() {
        if (this.observedFirstValue) {
            return this.maximumValue.get();
        }
        return 0L;
    }

    @Override
    public long getMinimumValue() {
        if (this.observedFirstValue) {
            return this.minimumValue.get();
        }
        return 0L;
    }

    public void incrementCurrentValue(long increment) {
        long updated = this.currentValue.addAndGet(increment);
        this.updateMinMax(updated);
    }

    public void decrementCurrentValue(long decrement) {
        long updated = this.currentValue.addAndGet(-decrement);
        this.updateMinMax(updated);
    }

    public boolean compareAndSetCurrentValue(long expected, long updated) {
        boolean success = this.currentValue.compareAndSet(expected, updated);
        if (success) {
            this.updateMinMax(updated);
        }
        return success;
    }

    public void setCurrentValue(long value) {
        this.currentValue.set(value);
        this.updateMinMax(value);
    }

    public void setMaximumValue(long value) {
        this.maximumValue.set(value);
        this.updateMinMax(value);
    }

    public void setMinimumValue(long value) {
        this.minimumValue.set(value);
        this.updateMinMax(value);
    }

    @Override
    public long getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public long getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean isBounded() {
        return this.bounded;
    }

    public void setBounds(long lowerBound, long upperBound) {
        this.lowerBound = Math.min(lowerBound, upperBound);
        this.upperBound = Math.max(lowerBound, upperBound);
    }

    private void updateMinMax(long updated) {
        long currentMin = this.minimumValue.get();
        while (updated < currentMin) {
            this.minimumValue.compareAndSet(currentMin, updated);
            currentMin = this.minimumValue.get();
        }
        long currentMax = this.maximumValue.get();
        while (updated > currentMax) {
            this.maximumValue.compareAndSet(currentMax, updated);
            currentMax = this.maximumValue.get();
        }
        if (!this.observedFirstValue) {
            this.observedFirstValue = true;
        }
    }

    @Override
    public GaugeReading getReading() {
        long current = this.getCurrentValue();
        long min = Math.min(current, this.getMinimumValue());
        long max = Math.max(current, this.getMaximumValue());
        return new GaugeReading(current, min, max, this.bounded, this.lowerBound, this.upperBound, this.getUnit());
    }

    public String toString() {
        GaugeReading reading = this.getReading();
        StringBuilder sb = new StringBuilder();
        sb.append("current value = ").append(reading.currentValue);
        sb.append(" minimum value = ").append(reading.minimumValue);
        sb.append(" maximum value = ").append(reading.maximumValue);
        if (reading.bounded) {
            sb.append(" lower bound = ").append(reading.lowerBound);
            sb.append(" upper bound = ").append(reading.upperBound);
        }
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(Gauge.class);
    }
}

