/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.ejb.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.ejb.EJBUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EjbProviderProxy {
    private final Boolean hasEJBExceptionMapper;
    private final String ejbName;
    private final String ejbModuleName;
    private final List<String> ejbLocalInterfaces;
    private static List<Class<?>> PROVIDER_INTERFACES;
    static final long serialVersionUID = -1888677082626401230L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public EjbProviderProxy(Boolean hasEJBExceptionMapper, String ejbName, List<String> localInterfaces, String ejbModuleName) {
        this.ejbName = ejbName;
        this.ejbLocalInterfaces = localInterfaces;
        this.hasEJBExceptionMapper = hasEJBExceptionMapper;
        this.ejbModuleName = ejbModuleName;
    }

    private String getJndiName(Class<?> providerInterface, Class<?> providerClass) {
        StringBuilder jndiName = new StringBuilder();
        StringBuilder stringBuilder = jndiName = this.ejbModuleName == null ? jndiName.append("java:module/") : jndiName.append("java:app/").append(this.ejbModuleName + "/");
        if (this.ejbName != null) {
            jndiName.append(this.ejbName);
            if (providerInterface != null) {
                jndiName.append("!").append(providerInterface.getName());
            }
        } else {
            jndiName.append(providerClass.getName());
            if (providerInterface != null) {
                jndiName.append("!").append(providerInterface.getName());
            }
        }
        return jndiName.toString();
    }

    <T> T lookUpProviderEjb(Class<T> providerInterface, Object providerObject) {
        String jndiName = this.getJndiName(providerInterface, providerObject.getClass());
        try {
            Object ejbServiceObject = new InitialContext().lookup(jndiName);
            return (T)ejbServiceObject;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.ejb.internal.EjbProviderProxy", (String)"96", (Object)this, (Object[])new Object[]{providerInterface, providerObject});
            return providerInterface.cast(providerObject);
        }
    }

    public Object createEjbProviderObject(Object providerObject) {
        HashMap ejbProviderMap = new HashMap();
        if (this.ejbName == null) {
            return providerObject;
        }
        if (this.ejbLocalInterfaces.size() == 0) {
            Object ejbObject = this.lookUpProviderEjb(null, providerObject);
            for (Class<?> inter : providerObject.getClass().getInterfaces()) {
                ejbProviderMap.put(inter, ejbObject);
            }
            return Proxy.newProxyInstance(providerObject.getClass().getClassLoader(), ejbProviderMap.keySet().toArray(new Class[ejbProviderMap.size()]), (InvocationHandler)new EjbProxyInvocationHandler(this.hasEJBExceptionMapper, providerObject, ejbProviderMap));
        }
        for (Class<?> providerInterface : PROVIDER_INTERFACES) {
            for (String ejbLocalInterface : this.ejbLocalInterfaces) {
                if (ejbLocalInterface.equals(providerInterface.getName())) {
                    Object ejbObject = this.lookUpProviderEjb(providerInterface, providerObject);
                    if (ejbObject == providerObject) continue;
                    ejbProviderMap.put(providerInterface, ejbObject);
                    continue;
                }
                try {
                    Object ejbObject;
                    Class<?> ejbLocalInterfaceClazz = providerObject.getClass().getClassLoader().loadClass(ejbLocalInterface);
                    if (!providerInterface.isAssignableFrom(ejbLocalInterfaceClazz) || (ejbObject = this.lookUpProviderEjb(ejbLocalInterfaceClazz, providerObject)) == providerObject) continue;
                    ejbProviderMap.put(ejbLocalInterfaceClazz, ejbObject);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs20.ejb.internal.EjbProviderProxy", (String)"149", (Object)this, (Object[])new Object[]{providerObject});
                }
            }
        }
        switch (ejbProviderMap.size()) {
            case 0: {
                return providerObject;
            }
        }
        return Proxy.newProxyInstance(providerObject.getClass().getClassLoader(), ejbProviderMap.keySet().toArray(new Class[ejbProviderMap.size()]), (InvocationHandler)new EjbProxyInvocationHandler(this.hasEJBExceptionMapper, providerObject, ejbProviderMap));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(EjbProviderProxy.class);
        PROVIDER_INTERFACES = Arrays.asList(ContextResolver.class, ExceptionMapper.class, ReaderInterceptor.class, WriterInterceptor.class, MessageBodyReader.class, MessageBodyWriter.class, ContainerRequestFilter.class, ContainerResponseFilter.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class EjbProxyInvocationHandler
    implements InvocationHandler {
        private final Map<Class<?>, Object> ejbProviderMap;
        private final Object oriProviderObject;
        private final Boolean hasEJBExceptionMapper;
        static final long serialVersionUID = -3302951152674911357L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EjbProxyInvocationHandler(Boolean hasEJBExceptionMapper, Object oriProviderObject, Map<Class<?>, Object> ejbProviderMap) {
            this.ejbProviderMap = ejbProviderMap;
            this.oriProviderObject = oriProviderObject;
            this.hasEJBExceptionMapper = hasEJBExceptionMapper;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Trivial
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object invokeResult = null;
            for (Map.Entry<Class<?>, Object> entry : this.ejbProviderMap.entrySet()) {
                Class<?> providerInterface = entry.getKey();
                Object ejbProviderObject = entry.getValue();
                for (Method iMethod : providerInterface.getMethods()) {
                    if (!EJBUtils.matchMethod(method, iMethod)) continue;
                    try {
                        invokeResult = iMethod.invoke(ejbProviderObject, args);
                    }
                    catch (Exception exception) {
                        Exception causedByException;
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxrs20.ejb.internal.EjbProviderProxy$EjbProxyInvocationHandler", (String)"200", (Object)this, (Object[])new Object[]{proxy, method, args});
                        List<Class<?>> exceptionTypes = Arrays.asList(method.getExceptionTypes());
                        Class<?> exceptionClass = e.getCause().getClass();
                        if (this.hasEJBExceptionMapper.booleanValue()) {
                            Exception causedByException2;
                            if (EJBException.class.equals(exceptionClass) && (causedByException2 = ((EJBException)e.getCause()).getCausedByException()) != null && exceptionTypes.contains(causedByException2.getClass())) {
                                throw causedByException2;
                            }
                        } else if (EJBException.class.isAssignableFrom(exceptionClass) && (causedByException = ((EJBException)e.getCause()).getCausedByException()) != null) {
                            throw causedByException;
                        }
                        if (e instanceof InvocationTargetException) {
                            throw (Exception)e.getCause();
                        }
                        throw e;
                    }
                    return invokeResult;
                }
            }
            try {
                invokeResult = method.invoke(this.oriProviderObject, args);
            }
            catch (Exception exception) {
                Exception causedByException;
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxrs20.ejb.internal.EjbProviderProxy$EjbProxyInvocationHandler", (String)"229", (Object)this, (Object[])new Object[]{proxy, method, args});
                List<Class<?>> exceptionTypes = Arrays.asList(method.getExceptionTypes());
                Class<?> exceptionClass = e.getCause().getClass();
                if (this.hasEJBExceptionMapper != false ? EJBException.class.equals(exceptionClass) && (causedByException = ((EJBException)e.getCause()).getCausedByException()) != null && exceptionTypes.contains(causedByException.getClass()) : EJBException.class.isAssignableFrom(exceptionClass) && (causedByException = ((EJBException)e.getCause()).getCausedByException()) != null) {
                    throw causedByException;
                }
                if (e instanceof InvocationTargetException) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
            return invokeResult;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EjbProxyInvocationHandler.class);
        }
    }
}

