/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.Adapter;
import com.ibm.ws.jndi.WSContextBase;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.WSNameParser;
import com.ibm.ws.jndi.WSNamingEnumeration;
import com.ibm.ws.jndi.internal.AutoBindNode;
import com.ibm.ws.jndi.internal.ContextNode;
import com.ibm.ws.jndi.internal.JNDIServiceBinder;
import com.ibm.ws.jndi.internal.WSContextFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class WSContext
extends WSContextBase
implements Context,
Referenceable {
    private static final TraceComponent tc = Tr.register(WSContext.class);
    private final BundleContext userContext;
    private final Hashtable<String, Object> env;
    final ContextNode myNode;
    static final long serialVersionUID = 8467841144978030246L;

    public WSContext(BundleContext userContext, ContextNode node, Hashtable<String, Object> env) {
        this.userContext = userContext;
        this.myNode = node;
        this.env = env;
    }

    private ServiceRegistration<?> bindIntoServiceRegistry(WSName wsName, Object o) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Binding object into registry with name for bundle", (Object[])new Object[]{o, wsName, this.userContext.getBundle().getSymbolicName()});
        }
        String className = o == null ? null : o.getClass().getName();
        ServiceRegistration reg = this.userContext.registerService(Object.class, o, JNDIServiceBinder.createServiceProperties(wsName, className));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"bind succeeded", (Object[])new Object[]{reg});
        }
        return reg;
    }

    private Object makeReference(WSName subname, Object o) throws NamingException {
        if (o instanceof Referenceable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"converting object to reference", (Object[])new Object[]{o});
            }
            o = ((Referenceable)o).getReference();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"converted object to reference", (Object[])new Object[]{o});
            }
        }
        return this.bindIntoServiceRegistry(subname, o);
    }

    @Sensitive
    @FFDCIgnore(value={NamingException.class})
    Object resolveObject(Object o, WSName subname) throws NamingException {
        ServiceReference ref = null;
        try {
            boolean getObjectInstance;
            if (o instanceof ContextNode) {
                return new WSContext(this.userContext, (ContextNode)o, this.env);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resolving object", (Object[])new Object[]{o});
            }
            if (o instanceof ServiceReference) {
                ref = (ServiceReference)o;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"External service registry entry.", (Object[])new Object[0]);
                }
            } else if (o instanceof AutoBindNode) {
                AutoBindNode abNode;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"AutoBindNode entry.", (Object[])new Object[0]);
                }
                if ((ref = (ServiceReference)(abNode = (AutoBindNode)o).getLastEntry()) == null) {
                    throw new NameNotFoundException(subname.toString());
                }
            } else if (o instanceof ServiceRegistration) {
                ref = ((ServiceRegistration)o).getReference();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Programmatic JNDI entry.", (Object[])new Object[0]);
                }
            }
            if (ref == null) {
                getObjectInstance = true;
            } else {
                o = this.getReference(this.userContext, ref);
                if (o == null) {
                    throw new NamingException(Tr.formatMessage((TraceComponent)tc, (String)"jndi.servicereference.failed", (Object[])new Object[]{subname.toString()}));
                }
                Object origin = ref.getProperty("osgi.jndi.service.origin");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Retrieved service from registry", (Object[])new Object[]{o, "osgi.jndi.service.origin=" + origin, "objectClass=" + Arrays.toString((String[])ref.getProperty("objectClass"))});
                }
                boolean bl = getObjectInstance = "jndi".equals(origin) || WSContext.contains((String[])ref.getProperty("objectClass"), Reference.class.getName());
            }
            if (getObjectInstance) {
                try {
                    Object oldO = o;
                    o = NamingManager.getObjectInstance(o, subname, this, this.env);
                    if (o != oldO && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Resolved object through NamingManager", (Object[])new Object[0]);
                    }
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jndi.internal.WSContext", (String)"156", (Object)this, (Object[])new Object[]{o, subname});
                }
            }
            return o;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jndi.internal.WSContext", (String)"163", (Object)this, (Object[])new Object[]{o, subname});
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    String resolveObjectClassName(Object o) {
        if (o instanceof ContextNode) {
            return Context.class.getName();
        }
        ServiceReference ref = null;
        if (o instanceof ServiceReference) {
            ref = (ServiceReference)o;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"External service registry entry.", (Object[])new Object[0]);
            }
        } else if (o instanceof AutoBindNode) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AutoBindNode entry.", (Object[])new Object[0]);
            }
            AutoBindNode abNode = (AutoBindNode)o;
            ref = (ServiceReference)abNode.getLastEntry();
        } else if (o instanceof ServiceRegistration) {
            ref = ((ServiceRegistration)o).getReference();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Programmatic JNDI entry.", (Object[])new Object[0]);
            }
        }
        if (ref != null) {
            Object origin = ref.getProperty("osgi.jndi.service.origin");
            String className = (String)ref.getProperty("osgi.jndi.service.class");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Service reference", (Object[])new Object[]{"osgi.jndi.service.origin=" + origin, "osgi.jndi.service.class=" + className, "objectClass=" + Arrays.toString((String[])ref.getProperty("objectClass"))});
            }
            if (className != null || "jndi".equals(origin)) {
                return className;
            }
            String[] objectClass = (String[])ref.getProperty("objectClass");
            if (WSContext.contains(objectClass, Reference.class.getName())) {
                o = this.getReference(this.userContext, ref);
                Reference jndiRef = (Reference)o;
                return jndiRef.getClassName();
            }
            return objectClass[0];
        }
        return o == null ? null : o.getClass().getName();
    }

    private static boolean contains(String[] array, String find) {
        for (String value : array) {
            if (!find.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        return this.env.put(s, o);
    }

    @Override
    protected void bind(WSName subname, Object o) throws NamingException {
        this.myNode.bind(subname, this.makeReference(subname, o));
    }

    @Override
    public void close() {
    }

    @Override
    protected Context createSubcontext(WSName n) throws NamingException {
        ContextNode subnode = this.myNode.createSubcontext(n);
        return new WSContext(this.userContext, subnode, this.env);
    }

    @Override
    protected void destroySubcontext(WSName n) throws NamingException {
        this.myNode.destroySubcontext(n);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "" + this.myNode.fullName;
    }

    @Override
    protected NameParser getNameParser(WSName n) throws NamingException {
        if (n == null || n.isEmpty()) {
            return new WSNameParser(this.myNode.root);
        }
        Object obj = this.lookup(n);
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser("");
        }
        if (obj == null) {
            throw new NameNotFoundException("" + this.myNode.fullName.plus((Name)n));
        }
        throw new NotContextException("" + this.myNode.fullName.plus((Name)n));
    }

    @Override
    protected NamingEnumeration<NameClassPair> list(WSName subname) throws NamingException {
        Adapter<Map.Entry<String, Object>, NameClassPair> adapter = new Adapter<Map.Entry<String, Object>, NameClassPair>(){
            static final long serialVersionUID = 5776975023258245449L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public NameClassPair adapt(Map.Entry<String, Object> entry) throws NamingException {
                String className = WSContext.this.resolveObjectClassName(entry.getValue());
                return new NameClassPair(entry.getKey(), className);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        return WSNamingEnumeration.getEnumeration(this.myNode.getChildren(subname), adapter);
    }

    @Override
    protected NamingEnumeration<Binding> listBindings(final WSName subname) throws NamingException {
        Adapter<Map.Entry<String, Object>, Binding> adapter = new Adapter<Map.Entry<String, Object>, Binding>(){
            static final long serialVersionUID = 838921420532753865L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Binding adapt(Map.Entry<String, Object> entry) throws NamingException {
                return new Binding(entry.getKey(), WSContext.this.resolveObject(entry.getValue(), subname.plus(entry.getKey())));
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        return WSNamingEnumeration.getEnumeration(this.myNode.getChildren(subname), adapter);
    }

    @Override
    @Sensitive
    protected Object lookup(WSName subname) throws NamingException {
        Object localObject = this.myNode.lookup(subname);
        return this.resolveObject(localObject, subname);
    }

    @Override
    @FFDCIgnore(value={ClassCastException.class, NullPointerException.class})
    protected Object lookupLink(WSName subname) throws NamingException {
        int i;
        Context target = this;
        try {
            for (i = 0; i < subname.size() - 1; ++i) {
                target = (Context)target.lookup(subname.get(i));
            }
            if (target == null) {
                throw new NullPointerException();
            }
        }
        catch (ClassCastException e) {
            throw new NotContextException("" + this.myNode.fullName.plus((Name)subname.getPrefix(i + 1)));
        }
        catch (NullPointerException e) {
            throw new NameNotFoundException("" + this.myNode.fullName.plus((Name)subname.getPrefix(i + 1)));
        }
        return target.lookup(subname.getLast());
    }

    @Override
    @FFDCIgnore(value={NameNotFoundException.class})
    protected void rebind(WSName subname, Object o) throws NamingException {
        try {
            this.unbind(subname);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.myNode.rebind(subname, this.makeReference(subname, o));
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        return this.env.remove(s);
    }

    @Override
    protected void rename(WSName nOld, WSName nNew) throws NamingException {
        Object entry = this.myNode.lookup(nOld);
        this.checkNotExternal(nOld, entry, "rename");
        if (entry instanceof ServiceRegistration) {
            ServiceRegistration reg = (ServiceRegistration)entry;
            String className = (String)reg.getReference().getProperty("osgi.jndi.service.class");
            reg.setProperties(JNDIServiceBinder.createServiceProperties(this.myNode.fullName.plus((Name)nNew), className));
            this.myNode.bind(nNew, entry);
        } else if (entry instanceof ContextNode) {
            ContextNode oldNode = (ContextNode)entry;
            ContextNode newNode = this.myNode.createSubcontext(nNew);
            if (!this.moveContents(oldNode, newNode)) {
                throw new PartialResultException(this.myNode.fullName + ".rename(" + nOld + ", " + nNew + ")");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected object type found in internal tree", (Object[])new Object[]{entry});
            }
            throw new NameNotFoundException("" + this.myNode.fullName.plus((Name)nOld));
        }
        this.myNode.ensureNotBound(nOld, entry);
    }

    private boolean moveContents(ContextNode oldNode, ContextNode newNode) throws InvalidNameException, NameAlreadyBoundException, NameNotFoundException, NotContextException {
        boolean emptied = true;
        Iterator entries = oldNode.children.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            WSName name = new WSName((String)entry.getKey());
            Object child = entry.getValue();
            if (child instanceof AutoBindNode) {
                emptied = false;
                continue;
            }
            if (child instanceof ServiceRegistration) {
                ServiceRegistration reg = (ServiceRegistration)child;
                String className = (String)reg.getReference().getProperty("osgi.jndi.service.class");
                reg.setProperties(JNDIServiceBinder.createServiceProperties(newNode.fullName.plus((Name)name), className));
                newNode.bind(name, reg);
                entries.remove();
                continue;
            }
            if (child instanceof ContextNode) {
                ContextNode oldChildNode = (ContextNode)child;
                ContextNode newChildNode = newNode.createSubcontext(name);
                if (this.moveContents(oldChildNode, newChildNode)) {
                    entries.remove();
                    continue;
                }
                emptied = false;
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected object type found in internal tree", (Object[])new Object[]{oldNode.fullName + "/" + (String)entry.getKey(), child});
            }
            entries.remove();
        }
        return emptied;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void unbind(WSName subname) throws NamingException {
        Object entry = this.myNode.lookup(subname);
        this.checkNotExternal(subname, entry, "unbind");
        if (entry instanceof ServiceRegistration) {
            ServiceRegistration reg = (ServiceRegistration)entry;
            reg.unregister();
        } else if (entry instanceof ContextNode) {
            ContextNode node = (ContextNode)entry;
            if (!WSContext.scrubContents(node)) {
                throw new PartialResultException(this.myNode.fullName + ".unbind(" + subname + ")");
            }
        } else {
            try {
                this.reportUnexpectedType(subname, entry);
            }
            catch (NameNotFoundException node) {
                void nnfe;
                FFDCFilter.processException((Throwable)node, (String)"com.ibm.ws.jndi.internal.WSContext", (String)"425", (Object)this, (Object[])new Object[]{subname});
                throw nnfe;
            }
        }
        this.myNode.ensureNotBound(subname, entry);
    }

    static boolean scrubContents(ContextNode node) {
        boolean emptied = true;
        Iterator entries = node.children.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object child = entry.getValue();
            if (child instanceof AutoBindNode) {
                emptied = false;
                continue;
            }
            if (child instanceof ServiceRegistration) {
                ServiceRegistration reg = (ServiceRegistration)child;
                WSContext.unregister(reg);
                entries.remove();
                continue;
            }
            if (child instanceof ContextNode) {
                ContextNode childNode = (ContextNode)child;
                if (WSContext.scrubContents(childNode)) {
                    entries.remove();
                    continue;
                }
                emptied = false;
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected object type found in internal tree", (Object[])new Object[]{node.fullName + "/" + (String)entry.getKey(), child});
            }
            entries.remove();
        }
        return emptied;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private static void unregister(ServiceRegistration<?> reg) {
        try {
            reg.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void checkNotExternal(WSName subname, Object entry, String opName) throws OperationNotSupportedException, InvalidNameException {
        if (entry instanceof ServiceReference) {
            throw new OperationNotSupportedException(opName + ": " + this.myNode.fullName.plus((Name)subname));
        }
    }

    private void reportUnexpectedType(WSName subname, Object entry) throws NameNotFoundException, InvalidNameException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unexpected object type found in internal tree", (Object[])new Object[]{this.myNode.fullName + "/" + subname, entry});
        }
        throw new NameNotFoundException("" + this.myNode.fullName.plus((Name)subname));
    }

    @Override
    public Reference getReference() throws NamingException {
        return WSContextFactory.makeReference(this);
    }

    public String toString() {
        return "" + this.myNode;
    }

    private Object getReference(BundleContext context, final ServiceReference<?> ref) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = -2893102354104324480L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                return WSContext.this.userContext.getService(ref);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        });
    }
}

