/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WASURLObjectFactoryFinder
implements URLObjectFactoryFinder {
    private static final TraceComponent tc = Tr.register(WASURLObjectFactoryFinder.class);
    static final long serialVersionUID = 3510482142624895282L;

    @FFDCIgnore(value={ClassNotFoundException.class})
    public ObjectFactory findFactory(String urlSchema, Hashtable<?, ?> env) throws NamingException {
        String str;
        ArrayList<String> pkgPrefixes = new ArrayList<String>();
        if (env != null && null != (str = (String)env.get("java.naming.factory.url.pkgs"))) {
            StringTokenizer st = new StringTokenizer(str, ":");
            while (st.hasMoreTokens()) {
                pkgPrefixes.add(st.nextToken());
            }
        }
        pkgPrefixes.add("com.sun.jndi.url");
        ClassNotFoundException cnfe = null;
        for (String pkgPrefix : pkgPrefixes) {
            String className = pkgPrefix + "." + urlSchema + "." + urlSchema + "URLContextFactory";
            try {
                Class<?> clazz = Class.forName(className, true, this.getClassLoader());
                return (ObjectFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Could not find class " + className), (Object[])new Object[]{e});
                }
                cnfe = e;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jndi.internal.WASURLObjectFactoryFinder", (String)"72", (Object)this, (Object[])new Object[]{urlSchema, env});
            }
        }
        if (cnfe != null) {
            FFDCFilter.processException((Throwable)cnfe, (String)(WASURLObjectFactoryFinder.class.getName() + ".findFactory"), (String)"74", (Object[])new Object[]{pkgPrefixes, urlSchema, env});
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 2050432045231909236L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }
}

