/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.probe.bci.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.request.probe.bci.internal.RequestProbeClassVisitor;
import com.ibm.wsspi.request.probe.bci.RequestProbeHelper;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class RequestProbeTransformer
implements ClassFileTransformer {
    private Instrumentation inst = null;
    private static final TraceComponent tc = Tr.register(RequestProbeTransformer.class);

    public RequestProbeTransformer(Instrumentation instrumentation) {
        this.inst = instrumentation;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] ba = null;
        if (!RequestProbeHelper.interestedClass(className)) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transforming class", (Object[])new Object[]{className});
        }
        ba = this.transformClassForRequestProbe(classfileBuffer, className);
        return ba;
    }

    private byte[] transformClassForRequestProbe(byte[] cBuffer, String nameOfClass) {
        ClassWriter writer;
        ClassReader reader = new ClassReader(cBuffer);
        Object visitor = writer = new ClassWriter(reader, 2);
        visitor = new RequestProbeClassVisitor((ClassVisitor)visitor, nameOfClass);
        reader.accept((ClassVisitor)visitor, 4);
        return writer.toByteArray();
    }

    public void retransformRequestProbeRelatedClasses() {
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            this.classAvailable(clazz);
        }
    }

    public void retransformClass(String stringClass) {
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            if (!clazz.getName().equals(stringClass.replace("/", "."))) continue;
            this.classAvailable(clazz);
        }
    }

    private void classAvailable(Class<?> clazz) {
        if (RequestProbeHelper.interestedClass(clazz.getName().replace(".", "/"))) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Re-transforming class", (Object[])new Object[]{clazz.getName(), this.inst.isRedefineClassesSupported(), this.inst.isRetransformClassesSupported()});
                }
                this.inst.retransformClasses(clazz);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(RequestProbeTransformer.class.getName() + ".classAavilable"), (String)"126");
            }
        }
    }
}

