/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.FactoryManager;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntityFactory;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeHelper;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeXPathHelper;
import com.ibm.ws.security.wim.env.ICacheUtil;
import com.ibm.ws.security.wim.util.ControlsHelper;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import com.ibm.wsspi.security.wim.exception.PasswordCheckFailedException;
import com.ibm.wsspi.security.wim.exception.SearchControlException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Control;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.GroupMembershipControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.LoginControl;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.PropertyControl;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class URBridge
implements Repository {
    private UserRegistry userRegistry = null;
    private static final String KEY_ID = "config.id";
    private String reposId = null;
    private Map<String, String> attrMap = null;
    private Map<String, String> customPropertyMap = null;
    private Map<String, String> propsMap = null;
    private String baseEntryName = null;
    private static final TraceComponent tc = Tr.register(URBridge.class);
    private static final String BASE_ENTRY = "registryBaseEntry";
    static final String BASE_ENTRY_NAME = "name";
    public static final String SPI_PREFIX = "WIM_SPI ";
    private static final String OLD_PASSWORD = "OLD_PASSWORD";
    private static final String NEW_SECURITY_NAME = "NEW_SECURITY_NAME";
    private static final String REPLACE_MEMBERS = "REPLACE_MEMBERS";
    private static final String DELETE_MEMBERS = "DELETE_MEMBERS";
    private static final String SAFRegistryImplClass = "com.ibm.ws.security.registry.saf.internal.SAFRegistry";
    private String personAccountType = null;
    private String groupAccountType = null;
    private HashMap<String, String> entityConfigMap = null;
    private ConfigManager configManager = null;
    private static List<String> defaultSupportedEntities = null;
    private static Map<String, String[]> defaultRDNProperties = null;
    private ICacheUtil iUserSecurityNameCache = null;
    private ICacheUtil iGroupSecurityNameCache = null;
    private ICacheUtil iUserSearchCache = null;
    private ICacheUtil iGroupSearchCache = null;
    private ICacheUtil iUserUniqueIdCache = null;
    private ICacheUtil iUserDispNameCache = null;
    private ICacheUtil iGroupUniqueIdCache = null;
    private ICacheUtil iGroupDispNameCache = null;
    static final long serialVersionUID = 4791268708225675070L;

    private static void initializeSupportedEntities() {
        defaultSupportedEntities = new ArrayList<String>(2);
        defaultSupportedEntities.add("PersonAccount");
        defaultSupportedEntities.add("Group");
    }

    private static void initializeRDNProperties() {
        defaultRDNProperties = new HashMap<String, String[]>();
        String[] personRDN = new String[]{"uid"};
        String[] groupRDN = new String[]{"cn"};
        defaultRDNProperties.put("PersonAccount", personRDN);
        defaultRDNProperties.put("Group", groupRDN);
    }

    private void initializeCaches() {
        int cacheSize = 100;
        long cacheTimeOut = 1200L;
        if (FactoryManager.getCacheUtil().isCacheAvailable()) {
            this.iUserSecurityNameCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iUserUniqueIdCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iUserDispNameCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iGroupSecurityNameCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iUserSearchCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iGroupSearchCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iGroupUniqueIdCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
            this.iGroupDispNameCache = FactoryManager.getCacheUtil().initialize(cacheSize, cacheSize, cacheTimeOut);
        }
    }

    /*
     * WARNING - void declaration
     */
    public URBridge(Map<String, Object> configProps, UserRegistry ur, ConfigManager configMgr) throws InitializationException {
        this.reposId = (String)configProps.get(KEY_ID);
        this.userRegistry = ur;
        this.initializeCaches();
        this.configManager = configMgr;
        if (defaultSupportedEntities == null) {
            URBridge.initializeSupportedEntities();
        }
        if (defaultRDNProperties == null) {
            URBridge.initializeRDNProperties();
        }
        try {
            this.initialize(configProps);
        }
        catch (WIMException wIMException) {
            void e;
            FFDCFilter.processException((Throwable)wIMException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"262", (Object)this, (Object[])new Object[]{configProps, ur, configMgr});
            throw new InitializationException((Throwable)e);
        }
    }

    private void setMapping() {
        this.attrMap = new HashMap<String, String>(6);
        this.attrMap.put("groupSecurityNameProperty", this.customPropertyMap.get("groupSecurityNameProperty") == null ? "uniqueName" : this.customPropertyMap.get("groupSecurityNameProperty"));
        this.attrMap.put("groupDisplayNameProperty", this.customPropertyMap.get("groupDisplayNameProperty") == null ? "displayName" : this.customPropertyMap.get("groupDisplayNameProperty"));
        this.attrMap.put("uniqueGroupIdProperty", this.customPropertyMap.get("uniqueGroupIdProperty") == null ? "uniqueId" : this.customPropertyMap.get("uniqueGroupIdProperty"));
        this.attrMap.put("userDisplayNameProperty", this.customPropertyMap.get("userDisplayNameProperty") == null ? "displayName" : this.customPropertyMap.get("userDisplayNameProperty"));
        this.attrMap.put("userSecurityNameProperty", this.customPropertyMap.get("userSecurityNameProperty") == null ? "uniqueName" : this.customPropertyMap.get("userSecurityNameProperty"));
        this.attrMap.put("uniqueUserIdProperty", this.customPropertyMap.get("uniqueUserIdProperty") == null ? "uniqueId" : this.customPropertyMap.get("uniqueUserIdProperty"));
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(Map<String, Object> configProps) throws WIMException {
        try {
            this.reposId = (String)configProps.get(KEY_ID);
            this.setCustomProperties((List)configProps.get("CustomProperties"));
            this.setMapping();
            this.setBaseEntry(configProps);
            this.setConfigEntityMapping(configProps);
            this.propsMap = new HashMap<String, String>();
            this.propsMap.putAll(this.attrMap);
            this.propsMap.putAll(this.customPropertyMap);
            URBridgeHelper.mapSupportedEntityTypeList(this.getSupportedEntityTypes());
            this.personAccountType = URBridgeHelper.getPersonAccountType();
            this.groupAccountType = URBridgeHelper.getGroupAccountType();
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"344", (Object)this, (Object[])new Object[]{configProps});
            throw new InitializationException("REPOSITORY_INITIALIZATION_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"REPOSITORY_INITIALIZATION_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId, (Object)th.toString())));
        }
    }

    private void setBaseEntry(Map<String, Object> configProps) throws WIMException {
        this.baseEntryName = (String)configProps.get(BASE_ENTRY);
        if (this.baseEntryName == null) {
            throw new WIMApplicationException("MISSING_BASE_ENTRY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_BASE_ENTRY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
        }
    }

    private void setCustomProperties(List<Map<String, String>> propList) throws WIMException {
        String METHODNAME = "setCustomProperties";
        this.customPropertyMap = new HashMap<String, String>();
        if (propList == null) {
            return;
        }
        for (Map<String, String> propMap : propList) {
            String propName = propMap.get(BASE_ENTRY_NAME);
            String propValue = propMap.get("value");
            this.customPropertyMap.put(propName, propValue);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCustomProperties custom properties " + this.customPropertyMap), (Object[])new Object[0]);
        }
    }

    private void setConfigEntityMapping(Map<String, Object> configProps) throws WIMException {
        List<String> entityTypes = this.getSupportedEntityTypes();
        String type = null;
        this.entityConfigMap = new HashMap();
        for (int i = 0; i < entityTypes.size(); ++i) {
            type = entityTypes.get(i);
            String rdnProp = this.getRDNProperties(type) == null ? null : this.getRDNProperties(type)[0];
            this.entityConfigMap.put(type, rdnProp);
        }
        if (this.entityConfigMap.get("LoginAccount") == null && this.entityConfigMap.get(this.personAccountType) != null) {
            this.entityConfigMap.put("LoginAccount", this.entityConfigMap.get(this.personAccountType));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setConfigEntityMapping entityConfigMap:" + this.entityConfigMap), (Object[])new Object[0]);
        }
    }

    private String[] getRDNProperties(String type) {
        String[] rdnProperties = this.configManager.getRDNProperties(type);
        if (rdnProperties == null || rdnProperties.length == 0) {
            rdnProperties = defaultRDNProperties.get(type);
            if (rdnProperties == null || rdnProperties.length == 0) {
                return null;
            }
            return rdnProperties;
        }
        return rdnProperties;
    }

    private List<String> getSupportedEntityTypes() {
        List<String> supportedEntities = this.configManager.getSupportedEntityTypes();
        if (supportedEntities != null && supportedEntities.size() > 0) {
            return supportedEntities;
        }
        return defaultSupportedEntities;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Root get(Root root) throws WIMException {
        Root returnRoot = new Root();
        String uniqueName = null;
        try {
            List<String> attrList = null;
            List<String> grpMbrAttrs = null;
            List<String> grpMbrshipAttrs = null;
            Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
            PropertyControl propertyCtrl = (PropertyControl)ctrlMap.get("PropertyControl");
            GroupMemberControl grpMbrCtrl = (GroupMemberControl)ctrlMap.get("GroupMemberControl");
            GroupMembershipControl grpMbrshipCtrl = (GroupMembershipControl)ctrlMap.get("GroupMembershipControl");
            if (grpMbrCtrl != null) {
                grpMbrAttrs = this.getAttributes((PropertyControl)grpMbrCtrl, this.personAccountType);
            }
            if (grpMbrshipCtrl != null) {
                grpMbrshipAttrs = this.getAttributes((PropertyControl)grpMbrshipCtrl, this.groupAccountType);
            }
            List entities = root.getEntities();
            for (Entity entity : entities) {
                int limit;
                String memberType = this.validateEntity(entity);
                uniqueName = entity.getIdentifier().getUniqueName();
                Object returnEntity = null;
                returnEntity = "Group".equalsIgnoreCase(memberType) ? new Group() : new PersonAccount();
                returnRoot.getEntities().add(returnEntity);
                IdentifierType identifier = new IdentifierType();
                identifier.setRepositoryId(this.reposId);
                returnEntity.setIdentifier(identifier);
                URBridgeEntityFactory osEntityFactory = new URBridgeEntityFactory();
                URBridgeEntity osEntity = osEntityFactory.createObject((Entity)returnEntity, this, this.propsMap, this.baseEntryName, this.entityConfigMap);
                osEntity.setSecurityNameProp(uniqueName);
                attrList = this.getAttributes(propertyCtrl, memberType);
                if (attrList != null) {
                    osEntity.populateEntity(attrList);
                }
                if ("Group".equalsIgnoreCase(memberType) && grpMbrCtrl != null && grpMbrAttrs != null) {
                    limit = 0;
                    if (grpMbrCtrl.isSetCountLimit()) {
                        limit = grpMbrCtrl.getCountLimit();
                    }
                    osEntity.getUsersForGroup(grpMbrAttrs, limit);
                    continue;
                }
                if (!"LoginAccount".equalsIgnoreCase(memberType) && !"PersonAccount".equalsIgnoreCase(memberType) || grpMbrshipCtrl == null || grpMbrshipAttrs == null) continue;
                limit = 0;
                if (grpMbrshipCtrl.isSetCountLimit()) {
                    limit = grpMbrshipCtrl.getCountLimit();
                }
                osEntity.getGroupsForUser(grpMbrshipAttrs, limit);
            }
        }
        catch (EntityNotFoundException attrList) {
            void e;
            FFDCFilter.processException((Throwable)attrList, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"533", (Object)this, (Object[])new Object[]{root});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"535", (Object)this, (Object[])new Object[]{root});
            throw new WIMException((Throwable)e);
        }
        this.setReturnContext(root, returnRoot);
        return returnRoot;
    }

    public String buildRDN(String value) {
        String rdnProperty = "uid";
        String rdnStyleName = rdnProperty + "=" + value + ",o=" + this.reposId;
        return rdnStyleName;
    }

    private List<String> getAttributes(PropertyControl control, String type) throws WIMException {
        List<String> attrList = new ArrayList<String>(10);
        if (control != null && control.getProperties() != null) {
            attrList = control.getProperties();
        }
        if (attrList.size() > 0 && "*".equals(attrList.get(0))) {
            attrList = this.getAttributes(type);
        }
        attrList.addAll(this.getIdentifierAttributes(type));
        return attrList;
    }

    private List<String> getAttributes(String entityType) throws WIMException {
        String METHODNAME = "getAttributes(entityType)";
        ArrayList<String> attrList = new ArrayList<String>();
        if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
            attrList.add(this.entityConfigMap.get(entityType));
            attrList.add(this.attrMap.get("groupDisplayNameProperty"));
        } else if ("LoginAccount".equals(entityType) || Entity.getSubEntityTypes((String)"LoginAccount").contains(entityType)) {
            attrList.add(this.entityConfigMap.get(entityType));
            attrList.add("principalName");
            attrList.add(this.attrMap.get("userDisplayNameProperty"));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAttributes(entityType) Entity type " + entityType + " is invalid and is ignored."), (Object[])new Object[0]);
        }
        return attrList;
    }

    private List<String> getIdentifierAttributes(String entityType) throws WIMException {
        String METHODNAME = "getIdentifierAttributes";
        ArrayList<String> attrList = new ArrayList<String>();
        if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
            attrList.add(this.attrMap.get("uniqueGroupIdProperty"));
            attrList.add(this.attrMap.get("groupSecurityNameProperty"));
        } else if ("LoginAccount".equals(entityType) || Entity.getSubEntityTypes((String)"LoginAccount").contains(entityType)) {
            attrList.add(this.attrMap.get("uniqueUserIdProperty"));
            attrList.add(this.attrMap.get("userSecurityNameProperty"));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getIdentifierAttributes Entity type " + entityType + " is invalid and is ignored."), (Object[])new Object[0]);
        }
        return attrList;
    }

    private String validateEntity(Entity entity) throws WIMException {
        String METHODNAME = "validateEntity";
        String type = null;
        String secName = null;
        String uniqueId = null;
        String uniqueName = null;
        if (entity.getIdentifier().isSet("uniqueName")) {
            uniqueName = entity.getIdentifier().getUniqueName();
        } else if (entity.getIdentifier().isSet("externalName")) {
            uniqueName = entity.getIdentifier().getExternalName();
        } else if (entity.getIdentifier().isSet("uniqueId")) {
            uniqueId = entity.getIdentifier().getUniqueId();
        } else if (entity.getIdentifier().isSet("externalId")) {
            uniqueId = entity.getIdentifier().getExternalId();
        }
        if (uniqueName != null) {
            secName = uniqueName;
        }
        if (uniqueId != null && uniqueId.trim().length() > 0) {
            if (this.isValidUserOrGroup(uniqueId)) {
                uniqueName = uniqueId;
                secName = uniqueId;
            } else {
                uniqueName = secName = this.getSecNameFromUniqueID(uniqueId);
            }
        }
        if (secName != null && secName.trim().length() > 0) {
            String rdnAttr = this.getRDN(entity.getIdentifier().getUniqueName());
            Set<String> EntityTypes = this.entityConfigMap.keySet();
            ArrayList<String> entities = new ArrayList<String>();
            for (String entityType : EntityTypes) {
                if (rdnAttr != null && !rdnAttr.equalsIgnoreCase(this.entityConfigMap.get(entityType))) continue;
                entities.add(entityType);
            }
            String inputType = entity.getTypeName();
            type = this.getEntityTypeFromUniqueName(secName, entities, inputType);
            entity.getIdentifier().setUniqueName(uniqueName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " The entity type for " + secName + " is " + type), (Object[])new Object[0]);
        }
        if (type == null) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)secName)));
        }
        return type;
    }

    private String getSecNameFromUniqueID(String uniqueId) throws WIMException {
        String METHODNAME = "getSecNameFromUniqueID";
        String secName = null;
        try {
            secName = this.getUserSecurityName(uniqueId);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"691", (Object)this, (Object[])new Object[]{uniqueId});
            try {
                secName = this.getGroupSecurityName(uniqueId);
            }
            catch (EntryNotFoundException entryNotFoundException2) {
                FFDCFilter.processException((Throwable)entryNotFoundException2, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"694", (Object)this, (Object[])new Object[]{uniqueId});
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
            }
            catch (RegistryException renf) {
                FFDCFilter.processException((Throwable)renf, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"697", (Object)this, (Object[])new Object[]{uniqueId});
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
            }
        }
        catch (RegistryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"701", (Object)this, (Object[])new Object[]{uniqueId});
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " The Security Name for " + uniqueId + " is " + secName), (Object[])new Object[0]);
        }
        return secName;
    }

    private String getEntityTypeFromUniqueName(String secName, List<String> entityType, String inputType) throws WIMException {
        String METHODNAME = "getEntityTypeFromUniqueName";
        String type = null;
        ArrayList<String> typeList = new ArrayList<String>();
        try {
            int resultSize;
            boolean noSpecificEntityType = false;
            if (entityType.size() == 0 || entityType.size() > 1) {
                noSpecificEntityType = true;
            }
            if ((entityType.contains(this.personAccountType) || noSpecificEntityType) && (resultSize = this.searchUsers(secName, 1).getList().size()) > 0) {
                typeList.add(this.personAccountType);
            }
            if ((entityType.contains(this.groupAccountType) || noSpecificEntityType) && (resultSize = this.searchGroups(secName, 1).getList().size()) > 0) {
                typeList.add(this.groupAccountType);
            }
            if (typeList.size() > 1) {
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!((String)typeList.get(i)).equals(inputType)) continue;
                    type = (String)typeList.get(i);
                    break;
                }
            }
            if (type == null && typeList.size() > 0) {
                type = (String)typeList.get(0);
            }
        }
        catch (RegistryException noSpecificEntityType) {
            FFDCFilter.processException((Throwable)noSpecificEntityType, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"766", (Object)this, (Object[])new Object[]{secName, entityType, inputType});
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)secName)));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " The entity type for " + secName + " is " + type), (Object[])new Object[0]);
        }
        return type;
    }

    private String getKey(String secName, int i) {
        return secName + "|" + i;
    }

    private String getRDN(String name) {
        if (name == null) {
            return name;
        }
        int indexOfEqual = name.indexOf(61);
        if (indexOfEqual < 0) {
            return name;
        }
        String rdnValue = name.substring(0, indexOfEqual);
        return rdnValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Root search(Root root) throws WIMException {
        String METHODNAME = "search";
        Root returnRoot = new Root();
        try {
            URBridgeEntity osEntity;
            IdentifierType id;
            Object matchDO;
            int j;
            URBridgeEntityFactory osEntityFactory;
            List returnNames;
            List<String> searchAttrs;
            int i;
            String expression;
            int countLimit = 0;
            Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
            SearchControl searchControl = (SearchControl)ctrlMap.get("SearchControl");
            if (searchControl.isSetCountLimit()) {
                countLimit = searchControl.getCountLimit();
            }
            if ((expression = searchControl.getExpression()) == null || expression.length() == 0) {
                throw new SearchControlException("MISSING_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SEARCH_EXPRESSION", (Object[])new Object[0]));
            }
            URBridgeXPathHelper xpathHelper = new URBridgeXPathHelper(expression);
            expression = xpathHelper.getExpression();
            boolean returnSubType = searchControl.isReturnSubType();
            List<String> entityTypes = xpathHelper.getEntityTypes();
            HashSet<String> entityTypeSet = new HashSet<String>();
            ArrayList entityTypeList = null;
            if (returnSubType) {
                for (int i2 = 0; i2 < entityTypes.size(); ++i2) {
                    String type = entityTypes.get(i2);
                    HashSet subTypes = Entity.getSubEntityTypes((String)type);
                    entityTypeSet.add(type);
                    if (subTypes == null) continue;
                    entityTypeSet.addAll(subTypes);
                }
            } else {
                entityTypeSet.addAll(entityTypes);
            }
            entityTypeList = new ArrayList(entityTypeSet);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("search entityType List: " + entityTypeList), (Object[])new Object[0]);
            }
            for (i = 0; i < entityTypeList.size(); ++i) {
                String type = (String)entityTypeList.get(i);
                if (!"Group".equalsIgnoreCase(type) && !Entity.getSubEntityTypes((String)"Group").contains(type)) continue;
                searchAttrs = this.getAttributes((PropertyControl)searchControl, type);
                returnNames = new ArrayList();
                if (!expression.contains("*")) {
                    countLimit = 1;
                }
                if ((returnNames = this.searchGroups(expression, countLimit).getList()).size() <= 0) break;
                osEntityFactory = new URBridgeEntityFactory();
                for (j = 0; j < returnNames.size(); ++j) {
                    matchDO = null;
                    matchDO = type.equalsIgnoreCase("PersonAccount") ? new PersonAccount() : new Group();
                    returnRoot.getEntities().add(matchDO);
                    id = new IdentifierType();
                    matchDO.setIdentifier(id);
                    osEntity = osEntityFactory.createObject((Entity)matchDO, this, this.propsMap, this.baseEntryName, this.entityConfigMap);
                    osEntity.setSecurityNameProp((String)returnNames.get(j));
                    osEntity.populateEntity(searchAttrs);
                    id.setRepositoryId(this.reposId);
                }
                break;
            }
            for (i = 0; i < entityTypeList.size(); ++i) {
                String type = (String)entityTypeList.get(i);
                if (!Entity.getSubEntityTypes((String)"LoginAccount").contains(type)) continue;
                searchAttrs = this.getAttributes((PropertyControl)searchControl, type);
                returnNames = new ArrayList();
                if (!expression.contains("*")) {
                    countLimit = 1;
                }
                if ((returnNames = this.searchUsers(expression, countLimit).getList()).size() > 0) {
                    osEntityFactory = new URBridgeEntityFactory();
                    if (type.equalsIgnoreCase("LoginAccount")) {
                        type = URBridgeHelper.getPersonAccountType();
                    }
                    for (j = 0; j < returnNames.size(); ++j) {
                        matchDO = new PersonAccount();
                        returnRoot.getEntities().add(matchDO);
                        id = new IdentifierType();
                        matchDO.setIdentifier(id);
                        osEntity = osEntityFactory.createObject((Entity)matchDO, this, this.propsMap, this.baseEntryName, this.entityConfigMap);
                        osEntity.setSecurityNameProp((String)returnNames.get(j));
                        osEntity.populateEntity(searchAttrs);
                        id.setRepositoryId(this.reposId);
                    }
                }
                break;
            }
        }
        catch (WIMException countLimit) {
            void we;
            FFDCFilter.processException((Throwable)countLimit, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"947", (Object)this, (Object[])new Object[]{root});
            throw we;
        }
        catch (Exception we) {
            void e;
            FFDCFilter.processException((Throwable)we, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"949", (Object)this, (Object[])new Object[]{root});
            throw new WIMApplicationException("ENTITY_SEARCH_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_SEARCH_FAILED", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString())));
        }
        return returnRoot;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={CertificateMapFailedException.class})
    public Root login(Root root) throws WIMException {
        List entities;
        String METHODNAME = "login";
        Root returnRoot = new Root();
        URBridgeEntityFactory osEntityFactory = new URBridgeEntityFactory();
        List<String> attrList = null;
        Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
        LoginControl propertyCtrl = (LoginControl)ctrlMap.get("LoginControl");
        if (propertyCtrl != null) {
            attrList = this.getAttributes((PropertyControl)propertyCtrl, "LoginAccount");
        }
        if ((entities = root.getEntities()).size() > 0) {
            Entity ent = (Entity)entities.get(0);
            String type = ent.getTypeName();
            String securityName = null;
            if ("LoginAccount".equalsIgnoreCase(type) || Entity.getSubEntityTypes((String)"LoginAccount").contains(type)) {
                LoginAccount entity = (LoginAccount)entities.get(0);
                if (entity.isSet("principalName")) {
                    boolean isValidUser;
                    String passwordStr;
                    String pname;
                    block33: {
                        List returnNames;
                        block34: {
                            pname = entity.getPrincipalName();
                            byte[] pwd = entity.getPassword();
                            if (pname == null || pname.trim().length() == 0) {
                                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PRINCIPAL_NAME", (Object[])new Object[0]));
                            }
                            if (pwd == null || pwd.length == 0) {
                                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PASSWORD", (Object[])new Object[0]));
                            }
                            try {
                                passwordStr = new String(pwd, "UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1000", (Object)this, (Object[])new Object[]{root});
                                throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"CUSTOM_REGISTRY_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
                            }
                            isValidUser = false;
                            if (SAFRegistryImplClass.equalsIgnoreCase(this.userRegistry.getClass().getName())) {
                                try {
                                    isValidUser = this.userRegistry.isValidUser(pname);
                                }
                                catch (RegistryException registryException) {
                                    FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1010", (Object)this, (Object[])new Object[]{root});
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"WIM_SPI login", (Object[])new Object[]{" principal, " + pname + ", not found in " + this.reposId});
                                    }
                                    break block33;
                                }
                            }
                            returnNames = null;
                            try {
                                returnNames = this.userRegistry.getUsers(pname, 1).getList();
                            }
                            catch (RegistryException registryException) {
                                FFDCFilter.processException((Throwable)registryException, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1020", (Object)this, (Object[])new Object[]{root});
                                if (!tc.isDebugEnabled()) break block34;
                                Tr.debug((TraceComponent)tc, (String)"WIM_SPI login", (Object[])new Object[]{" principal, " + pname + ", not found in " + this.reposId});
                            }
                        }
                        boolean bl = isValidUser = returnNames != null && returnNames.size() > 0;
                    }
                    if (isValidUser) {
                        try {
                            securityName = this.userRegistry.checkPassword(pname, passwordStr);
                        }
                        catch (RegistryException returnNames) {
                            void e;
                            FFDCFilter.processException((Throwable)returnNames, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1030", (Object)this, (Object[])new Object[]{root});
                            throw new WIMException((Throwable)e);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WIM_SPI login principal, " + pname + ", not found in " + this.reposId), (Object[])new Object[0]);
                    }
                } else if (entity.isSet("certificate")) {
                    List certList = entity.getCertificate();
                    int certListSize = certList.size();
                    if (certListSize > 0) {
                        X509Certificate[] certs = new X509Certificate[certListSize];
                        for (int i = 0; i < certs.length; ++i) {
                            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])certList.get(i));
                            try {
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                certs[i] = (X509Certificate)cf.generateCertificate(bais);
                                bais.close();
                                continue;
                            }
                            catch (Exception cf) {
                                FFDCFilter.processException((Throwable)cf, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1050", (Object)this, (Object[])new Object[]{root});
                                throw new WIMApplicationException("CERTIFICATE_GENERATE_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_GENERATE_FAILED", (Object[])new Object[0]));
                            }
                        }
                        try {
                            securityName = this.userRegistry.mapCertificate(certs[0]);
                        }
                        catch (CertificateMapNotSupportedException i) {
                            void e;
                            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1056", (Object)this, (Object[])new Object[]{root});
                            throw new com.ibm.wsspi.security.wim.exception.CertificateMapNotSupportedException((Throwable)e);
                        }
                        catch (CertificateMapFailedException e) {
                        }
                        catch (RegistryException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.URBridge", (String)"1060", (Object)this, (Object[])new Object[]{root});
                            throw new WIMException((Throwable)e);
                        }
                    }
                } else {
                    throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PRINCIPAL_NAME", (Object[])new Object[0]));
                }
                if (securityName != null) {
                    PersonAccount person = new PersonAccount();
                    returnRoot.getEntities().add(person);
                    IdentifierType id = new IdentifierType();
                    person.setIdentifier(id);
                    person.setPrincipalName(securityName);
                    URBridgeEntity osEntity = osEntityFactory.createObject((Entity)person, this, this.attrMap, this.baseEntryName, this.entityConfigMap);
                    osEntity.setSecurityNameProp(securityName);
                    if (attrList != null) {
                        osEntity.populateEntity(attrList);
                    }
                    id.setRepositoryId(this.reposId);
                }
            } else {
                throw new WIMApplicationException("ENTITY_TYPE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)type)));
            }
        }
        return returnRoot;
    }

    @FFDCIgnore(value={RegistryException.class})
    private boolean isValidUserOrGroup(String uniqueId) {
        try {
            if (this.userRegistry.isValidUser(uniqueId)) {
                return true;
            }
            return this.userRegistry.isValidGroup(uniqueId);
        }
        catch (RegistryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to determine if this is a valid User/Group", (Object[])new Object[0]);
            }
            return false;
        }
    }

    @Override
    public String getRealm() {
        return this.userRegistry.getRealm();
    }

    public String getUserSecurityName(String uniqueId) throws EntryNotFoundException, RegistryException {
        String secName = null;
        if (this.iUserSecurityNameCache.containsKey(uniqueId)) {
            secName = (String)this.iUserSecurityNameCache.get(uniqueId);
        } else {
            secName = this.userRegistry.getUserSecurityName(uniqueId);
            this.iUserSecurityNameCache.put(uniqueId, secName);
        }
        return secName;
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, RegistryException {
        String uniqueId = null;
        if (this.iUserUniqueIdCache.containsKey(securityName)) {
            uniqueId = (String)this.iUserUniqueIdCache.get(securityName);
        } else {
            uniqueId = this.userRegistry.getUniqueUserId(securityName);
            this.iUserUniqueIdCache.put(securityName, uniqueId);
        }
        return uniqueId;
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, RegistryException {
        String displayName = null;
        if (this.iUserDispNameCache.containsKey(securityName)) {
            displayName = (String)this.iUserDispNameCache.get(securityName);
        } else {
            displayName = this.userRegistry.getUserDisplayName(securityName);
            this.iUserDispNameCache.put(securityName, displayName);
        }
        return displayName;
    }

    public String getGroupSecurityName(String uniqueId) throws EntryNotFoundException, RegistryException {
        String secName = null;
        if (this.iGroupSecurityNameCache.containsKey(uniqueId)) {
            secName = (String)this.iGroupSecurityNameCache.get(uniqueId);
        } else {
            secName = this.userRegistry.getGroupSecurityName(uniqueId);
            this.iGroupSecurityNameCache.put(uniqueId, secName);
        }
        return secName;
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, RegistryException {
        String uniqueId = null;
        if (this.iGroupUniqueIdCache.containsKey(securityName)) {
            uniqueId = (String)this.iGroupUniqueIdCache.get(securityName);
        } else {
            uniqueId = this.userRegistry.getUniqueGroupId(securityName);
            this.iGroupUniqueIdCache.put(securityName, uniqueId);
        }
        return uniqueId;
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, RegistryException {
        String displayName = null;
        if (this.iGroupDispNameCache.containsKey(securityName)) {
            displayName = (String)this.iGroupDispNameCache.get(securityName);
        } else {
            displayName = this.userRegistry.getGroupDisplayName(securityName);
            this.iGroupDispNameCache.put(securityName, displayName);
        }
        return displayName;
    }

    private SearchResult searchUsers(String secName, int i) throws RegistryException {
        String key = this.getKey(secName, i);
        if (this.iUserSearchCache.containsKey(key)) {
            return (SearchResult)this.iUserSearchCache.get(key);
        }
        SearchResult result = this.userRegistry.getUsers(secName, i);
        this.iUserSearchCache.put(key, result);
        return result;
    }

    private SearchResult searchGroups(String secName, int i) throws RegistryException {
        String key = this.getKey(secName, i);
        if (this.iGroupSearchCache.containsKey(key)) {
            return (SearchResult)this.iGroupSearchCache.get(key);
        }
        SearchResult result = this.userRegistry.getGroups(secName, i);
        this.iGroupSearchCache.put(key, result);
        return result;
    }

    public List<String> getGroupsForUser(String securityName) throws EntryNotFoundException, RegistryException {
        return this.userRegistry.getGroupsForUser(securityName);
    }

    public SearchResult getUsersForGroup(String securityName, int countLimit) throws RemoteException, NotImplementedException, EntryNotFoundException, CustomRegistryException, RegistryException {
        return this.userRegistry.getUsersForGroup(securityName, countLimit);
    }

    private void setReturnContext(Root inRoot, Root returnRoot) {
        if (returnRoot != null && !returnRoot.getEntities().isEmpty()) {
            boolean hasIsURBrigeResult = false;
            if (inRoot != null) {
                List contexts = inRoot.getContexts();
                for (Context contextInput : contexts) {
                    String key = contextInput.getKey();
                    if (key == null || !"isURBridgeResult".equals(key)) continue;
                    hasIsURBrigeResult = true;
                }
            }
            if (hasIsURBrigeResult) {
                Context context = new Context();
                context.setKey("isURBridgeResult");
                context.setValue((Object)"true");
                returnRoot.getContexts().add(context);
            }
        }
    }

    @Override
    public Root delete(Root root) throws WIMException {
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "delete", auditManager.getRepositoryId(), auditManager.getRepositoryUniqueName(), auditManager.getRepositoryRealm(), root, Integer.valueOf("209")});
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
    }

    @Override
    public Root create(Root root) throws WIMException {
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", auditManager.getRepositoryId(), auditManager.getRepositoryUniqueName(), auditManager.getRepositoryRealm(), root, Integer.valueOf("209")});
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
    }

    @Override
    public Root update(Root root) throws WIMException {
        AuditManager auditManager = new AuditManager();
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", auditManager.getRepositoryId(), auditManager.getRepositoryUniqueName(), auditManager.getRepositoryRealm(), root, Integer.valueOf("209")});
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.reposId)));
    }

    public void stopCacheThreads() {
        if (this.iUserSecurityNameCache != null) {
            this.iUserSecurityNameCache.stopEvictionTask();
        }
        if (this.iUserUniqueIdCache != null) {
            this.iUserUniqueIdCache.stopEvictionTask();
        }
        if (this.iUserDispNameCache != null) {
            this.iUserDispNameCache.stopEvictionTask();
        }
        if (this.iGroupSecurityNameCache != null) {
            this.iGroupSecurityNameCache.stopEvictionTask();
        }
        if (this.iUserSearchCache != null) {
            this.iUserSearchCache.stopEvictionTask();
        }
        if (this.iGroupSearchCache != null) {
            this.iGroupSearchCache.stopEvictionTask();
        }
        if (this.iGroupUniqueIdCache != null) {
            this.iGroupUniqueIdCache.stopEvictionTask();
        }
        if (this.iGroupDispNameCache != null) {
            this.iGroupDispNameCache.stopEvictionTask();
        }
    }
}

