/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.osgi.framework.Version;

public class BootstrapManifest {
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String MANIFEST_KERNEL = "WebSphere-DefaultKernel";
    static final String MANIFEST_LOG_PROVIDER = "WebSphere-DefaultLogProvider";
    static final String MANIFEST_OS_EXTENSION = "WebSphere-DefaultExtension-";
    static final String BOOTPROP_KERNEL = "websphere.kernel";
    static final String BOOTPROP_LOG_PROVIDER = "websphere.log.provider";
    static final String BOOTPROP_OS_EXTENSIONS = "websphere.os.extension";
    static final String SYSTEM_PKG_PREFIX = "OSGI-OPT/websphere/system-packages_";
    static final String SYSTEM_PKG_SUFFIX = ".properties";
    static final String MANIFEST_EXPORT_PACKAGE = "Export-Package";
    private static BootstrapManifest instance = null;
    private final Attributes manifestAttributes;

    public static BootstrapManifest readBootstrapManifest() throws IOException {
        BootstrapManifest manifest = instance;
        if (manifest == null) {
            manifest = instance = new BootstrapManifest();
        }
        return manifest;
    }

    public static void dispose() {
        instance = null;
    }

    protected BootstrapManifest() throws IOException {
        JarFile jf = null;
        try {
            jf = new JarFile(KernelUtils.getBootstrapJar());
            Manifest mf = jf.getManifest();
            this.manifestAttributes = mf.getMainAttributes();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Utils.tryToClose(jf);
                throw throwable;
            }
        }
        Utils.tryToClose(jf);
    }

    public String getKernelDefinition(BootstrapConfig bootProps) {
        String kernelDef = bootProps.get(BOOTPROP_KERNEL);
        if (kernelDef == null) {
            kernelDef = this.manifestAttributes.getValue(MANIFEST_KERNEL);
        }
        if (kernelDef != null) {
            bootProps.put(BOOTPROP_KERNEL, kernelDef);
        }
        return kernelDef;
    }

    public String getLogProviderDefinition(BootstrapConfig bootProps) {
        String logProvider = bootProps.get(BOOTPROP_LOG_PROVIDER);
        if (logProvider == null) {
            logProvider = this.manifestAttributes.getValue(MANIFEST_LOG_PROVIDER);
        }
        if (logProvider != null) {
            bootProps.put(BOOTPROP_LOG_PROVIDER, logProvider);
        }
        return logProvider;
    }

    public String getOSExtensionDefinition(BootstrapConfig bootProps) {
        String osExtension = bootProps.get(BOOTPROP_OS_EXTENSIONS);
        if (osExtension == null) {
            String normalizedName = BootstrapManifest.getNormalizedOperatingSystemName(bootProps.get("os.name"));
            osExtension = this.manifestAttributes.getValue(MANIFEST_OS_EXTENSION + normalizedName);
        }
        if (osExtension != null) {
            bootProps.put(BOOTPROP_OS_EXTENSIONS, osExtension);
        }
        return osExtension;
    }

    public String getBundleVersion() {
        return this.manifestAttributes.getValue(BUNDLE_VERSION);
    }

    public void prepSystemPackages(BootstrapConfig bootProps) {
        String packages = bootProps.get("org.osgi.framework.system.packages.extra");
        String syspackages = bootProps.get("org.osgi.framework.system.packages");
        String mPackages = this.manifestAttributes.getValue(MANIFEST_EXPORT_PACKAGE);
        if (mPackages != null) {
            String string = packages = packages == null ? mPackages : packages + "," + mPackages;
            if (packages != null) {
                bootProps.put("org.osgi.framework.system.packages.extra", packages);
            }
        }
        if (syspackages == null) {
            JarFile jarFile;
            block11: {
                String javaVersion = System.getProperty("java.version", "1.6.0");
                int index = javaVersion.indexOf(95);
                index = index == -1 ? javaVersion.indexOf(45) : index;
                javaVersion = index == -1 ? javaVersion : javaVersion.substring(0, index);
                String pkgListFileName = SYSTEM_PKG_PREFIX + javaVersion + SYSTEM_PKG_SUFFIX;
                jarFile = null;
                try {
                    jarFile = new JarFile(KernelUtils.getBootstrapJar());
                    List<String> systemPackageFileNames = new ArrayList<String>();
                    Enumeration<JarEntry> bootstrapJarEntries = jarFile.entries();
                    while (bootstrapJarEntries.hasMoreElements()) {
                        JarEntry entry = bootstrapJarEntries.nextElement();
                        if (entry == null || !entry.getName().startsWith(SYSTEM_PKG_PREFIX) || !entry.getName().endsWith(SYSTEM_PKG_SUFFIX)) continue;
                        systemPackageFileNames.add(entry.getName());
                    }
                    Collections.sort(systemPackageFileNames, new Comparator<String>(){

                        @Override
                        public int compare(String name1, String name2) {
                            Version oneVersion = this.getVersion(name1);
                            Version twoVersion = this.getVersion(name2);
                            return twoVersion.compareTo(oneVersion);
                        }

                        private Version getVersion(String name) {
                            String version = name.substring(BootstrapManifest.SYSTEM_PKG_PREFIX.length(), name.length());
                            version = version.substring(0, version.indexOf(BootstrapManifest.SYSTEM_PKG_SUFFIX, 0));
                            return new Version(version);
                        }
                    });
                    if (!systemPackageFileNames.isEmpty()) {
                        int indexOfPackageFileToUse = systemPackageFileNames.indexOf(pkgListFileName);
                        if (indexOfPackageFileToUse < 0) {
                            indexOfPackageFileToUse = 0;
                        }
                        systemPackageFileNames = systemPackageFileNames.subList(indexOfPackageFileToUse, systemPackageFileNames.size());
                    } else {
                        systemPackageFileNames = Arrays.asList(pkgListFileName);
                    }
                    syspackages = this.getMergedSystemProperties(jarFile, systemPackageFileNames);
                    if (syspackages == null) break block11;
                    bootProps.put("org.osgi.framework.system.packages", syspackages);
                }
                catch (IOException ioe) {
                    try {
                        throw new LaunchException("Unable to find or read specified properties file; " + pkgListFileName, MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), ioe.toString()), ioe);
                    }
                    catch (Throwable throwable) {
                        Utils.tryToClose(jarFile);
                        throw throwable;
                    }
                }
            }
            Utils.tryToClose(jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMergedSystemProperties(JarFile jarFile, List<String> pkgListFileNames) throws IOException {
        String packages = null;
        for (String pkgListFileName : pkgListFileNames) {
            ZipEntry propFile = jarFile.getEntry(pkgListFileName);
            if (propFile != null) {
                Properties properties = new Properties();
                InputStream is = jarFile.getInputStream(propFile);
                try {
                    properties.load(is);
                    String loadedPackages = properties.getProperty("org.osgi.framework.system.packages");
                    if (loadedPackages == null) continue;
                    packages = packages == null ? loadedPackages : packages + "," + loadedPackages;
                    continue;
                }
                finally {
                    Utils.tryToClose(is);
                    continue;
                }
            }
            throw new IOException("Unable to find specified properties file; " + pkgListFileName);
        }
        return packages;
    }

    static String getNormalizedOperatingSystemName(String osName) {
        String name = osName.toLowerCase(Locale.ENGLISH);
        name = name.replaceAll("[^0-9a-zA-Z_-]", "");
        return name;
    }
}

