/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.security;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.member.security.CollectiveCertificateConfig;
import com.ibm.ws.collective.security.CollectiveDNUtil;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.ssl.SSLConfiguration;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class CollectiveIdentityValidator {
    private static final TraceComponent tc = Tr.register(CollectiveIdentityValidator.class);
    static final String SSL_CONFIG_ID = "controllerConnectionConfig";
    static final String SERVER_IDENTITY_KEYSTORE_NAME = "serverIdentity";
    static final String SERVER_IDENTITY_KEY_ALIAS = "serveridentity";
    static final String KEY_KEYSTORE_SERVICE_REF = "keyStoreService";
    static final String KEY_SSL_SUPPORT_REF = "sslSupport";
    static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    private final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private static final String KEY_COLLECTIVE_CERT_CONFIG_SERVICE_REF = "CollectiveCertificateConfig";
    private final AtomicServiceReference<CollectiveCertificateConfig> collectiveCertConfigServiceRef = new AtomicServiceReference("CollectiveCertificateConfig");
    private ServerInfoMBean serverIdentity = null;
    private ScheduledValidate scheduledValidate;
    static final long serialVersionUID = -6919494982870064748L;

    @Reference(service=ServerInfoMBean.class)
    protected void setServerIdentityMBean(ServerInfoMBean reference) {
        this.serverIdentity = reference;
    }

    protected void unsetServerIdentityMBean(ServerInfoMBean reference) {
        if (this.serverIdentity == reference) {
            this.serverIdentity = null;
        }
    }

    @Reference(service=SSLConfiguration.class, target="(id=controllerConnectionConfig)")
    protected void setSSLConfiguration(ServiceReference<SSLConfiguration> ref) {
    }

    protected void unsetSSLConfiguration(ServiceReference<SSLConfiguration> ref) {
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.setReference(reference);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.unsetReference(reference);
    }

    @Reference(name="sslSupport", service=SSLSupport.class)
    protected void setSSLSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void unsetSSLSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    @Reference(name="CollectiveCertificateConfig", service=CollectiveCertificateConfig.class)
    protected void setCollectiveCertificateConfig(ServiceReference<CollectiveCertificateConfig> reference) {
        this.collectiveCertConfigServiceRef.setReference(reference);
    }

    protected void unsetCollectiveCertificateConfig(ServiceReference<CollectiveCertificateConfig> ref) {
        this.collectiveCertConfigServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.keyStoreServiceRef.activate(cc);
        this.sslSupportRef.activate(cc);
        this.executorServiceRef.activate(cc);
        this.collectiveCertConfigServiceRef.activate(cc);
        this.scheduledValidate = new ScheduledValidate();
        this.getScheduledExecutorServiceService().submit(this.scheduledValidate);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (this.scheduledValidate != null) {
            this.scheduledValidate.cancel();
        }
        this.keyStoreServiceRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        this.executorServiceRef.deactivate(cc);
        this.collectiveCertConfigServiceRef.deactivate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={FileNotFoundException.class, IOException.class})
    private void validateServerIdentity() throws KeyStoreException, CertificateException, InvalidNameException {
        String containerName;
        X509Certificate cert = (X509Certificate)this.getKeyStoreServiceService().getCertificateFromKeyStore(SERVER_IDENTITY_KEYSTORE_NAME, SERVER_IDENTITY_KEY_ALIAS);
        String serverIdentityDN = cert.getSubjectDN().getName();
        if (this.isCACertificate(serverIdentityDN)) {
            return;
        }
        String idHostName = CollectiveDNUtil.getHostName((String)serverIdentityDN);
        String idUserDir = RepositoryPathUtility.decodeURLEncodedDir((String)CollectiveDNUtil.getURLEncodedUserDir((String)serverIdentityDN));
        String idServerName = CollectiveDNUtil.getServerName((String)serverIdentityDN);
        String hostName = this.serverIdentity.getDefaultHostname();
        String rawUserDir = this.serverIdentity.getUserDirectory();
        String userDir = RepositoryPathUtility.decodeURLEncodedDir((String)RepositoryPathUtility.getURLEncodedPath((String)rawUserDir));
        String serverName = this.serverIdentity.getName();
        FileInputStream fis = null;
        Properties fileProperties = new Properties();
        try {
            fis = new FileInputStream("/opt/ibm/docker/env.properties");
            fileProperties.load(fis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)"Loaded Docker env.properties", (Object[])new Object[0]);
            }
        }
        catch (FileNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)"Docker env.properties not found", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)("Docker env.properties failed to open: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        finally {
            block25: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                        Tr.debug(DockerEnvironmentUtil.class, (TraceComponent)tc, (String)("Docker env.properties failed to close: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if ((containerName = fileProperties.getProperty("containerName")) != null) {
            serverName = serverName + "@" + containerName;
        }
        if (!idHostName.equals(hostName)) {
            Tr.error((TraceComponent)tc, (String)"IDENTITY_HOSTNAME_HAS_CHANGED_SINCE_IDENTITY_CREATED", (Object[])new Object[]{idHostName, hostName});
        }
        if (!idUserDir.equals(userDir)) {
            Tr.error((TraceComponent)tc, (String)"IDENTITY_USERDIR_HAS_CHANGED_SINCE_IDENTITY_CREATED", (Object[])new Object[]{idUserDir, userDir});
        }
        if (!idServerName.equals(serverName)) {
            Tr.error((TraceComponent)tc, (String)"IDENTITY_SERVERNAME_HAS_CHANGED_SINCE_IDENTITY_CREATED", (Object[])new Object[]{idServerName, serverName});
        }
    }

    private boolean isCACertificate(String dn) throws InvalidNameException {
        Rdn configuredRdn;
        CollectiveCertificateConfig collectiveCertificateConfig = (CollectiveCertificateConfig)this.collectiveCertConfigServiceRef.getService();
        LdapName name = new LdapName(dn);
        List<Rdn> certificateDN = name.getRdns();
        return certificateDN.contains(configuredRdn = new Rdn(collectiveCertificateConfig.getRDN()));
    }

    @Trivial
    private ScheduledExecutorService getScheduledExecutorServiceService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that ScheduledExecutorService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ScheduledExecutorService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The ScheduledExecutorService service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private SSLSupport getSSLSupportService() {
        SSLSupport service = (SSLSupport)this.sslSupportRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that SSLSupportService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSLSupportService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The SSLSupport service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private KeyStoreService getKeyStoreServiceService() {
        KeyStoreService service = (KeyStoreService)this.keyStoreServiceRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that KeyStoreService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"KeyStoreService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The KeyStoreService service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class ScheduledValidate
    implements Callable<Void> {
        private final int MAX_ATTEMPTS = 5;
        private int attempts = 0;
        private boolean isCanceled = false;
        private boolean scheduled = false;
        private ScheduledFuture<Void> scheduledFuture = null;
        static final long serialVersionUID = -734877917605544400L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ScheduledValidate() {
        }

        public synchronized void schedule() {
            if (!this.scheduled) {
                if (FrameworkState.isStopping()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Framework is stopping, will not schedule any new attempts.", (Object[])new Object[0]);
                    }
                    return;
                }
                if (this.isCanceled) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Task is canceled, will not schedule any new attempts.", (Object[])new Object[0]);
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Scheduling a connection attempt in 5 seconds", (Object[])new Object[0]);
                }
                this.scheduledFuture = CollectiveIdentityValidator.this.getScheduledExecutorServiceService().schedule(this, 5L, TimeUnit.SECONDS);
                this.scheduled = true;
            }
        }

        @Override
        @FFDCIgnore(value={SSLConfigurationNotAvailableException.class, CertificateException.class})
        public synchronized Void call() throws Exception {
            this.scheduled = false;
            if (this.isCanceled) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Work has been explicitly canceled, no performing any work.", (Object[])new Object[0]);
                }
                return null;
            }
            ++this.attempts;
            if (this.attempts > 5) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Max number of attempts to validate have been exceeded, giving up", (Object[])new Object[0]);
                }
                Tr.warning((TraceComponent)tc, (String)"IDENTITY_CANNOT_BE_VALIDATED", (Object[])new Object[0]);
                this.cancel();
                return null;
            }
            try {
                try {
                    JSSEHelper jsseHelper = CollectiveIdentityValidator.this.getSSLSupportService().getJSSEHelper();
                    jsseHelper.getSSLContext(CollectiveIdentityValidator.SSL_CONFIG_ID, null, null, false);
                    CollectiveIdentityValidator.this.validateServerIdentity();
                }
                catch (SSLConfigurationNotAvailableException e) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"SSL configuration controllerConnectionConfig is not yet ready, scheduling another attempt.", (Object[])new Object[]{e});
                    }
                    this.schedule();
                    return null;
                }
                catch (SSLException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.security.CollectiveIdentityValidator$ScheduledValidate", (String)"216", (Object)this, (Object[])new Object[0]);
                    throw e;
                }
            }
            catch (CertificateException e) {
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.security.CollectiveIdentityValidator$ScheduledValidate", (String)"221", (Object)this, (Object[])new Object[0]);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected Exception caught while trying to validate the server identity", (Object[])new Object[]{e});
                }
                Tr.warning((TraceComponent)tc, (String)"IDENTITY_CANNOT_BE_VALIDATED", (Object[])new Object[0]);
            }
            return null;
        }

        public synchronized void cancel() {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Canceling the currently scheduled future", (Object[])new Object[0]);
            }
            this.isCanceled = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ScheduledValidate.class);
        }
    }
}

