/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.beanvalidation.config.ValidationConfigurationInterface;
import com.ibm.ws.beanvalidation.service.BeanValidationContext;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.InputStream;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;

@Trivial
public class OSGiBeanValidationScopeData
implements BeanValidationContext {
    private static final TraceComponent tc = Tr.register(OSGiBeanValidationScopeData.class);
    final Container ivModuleContainer;
    volatile ValidatorFactory ivValidatorFactory;
    volatile ClassLoader classloader;
    ValidationConfigurationInterface configurator;
    boolean configuratorReleased;

    public OSGiBeanValidationScopeData(Container moduleContainer) {
        this.ivModuleContainer = moduleContainer;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public ClassLoader setClassLoader(ClassLoader loader) {
        ClassLoader oldLoader = this.classloader;
        this.classloader = loader;
        return oldLoader;
    }

    @Override
    public String getPath() {
        return this.ivModuleContainer.getPath();
    }

    @Override
    public InputStream getInputStream(String fileName) throws ValidationException {
        InputStream fileInputStream;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInputStream(" + fileName + ")"), (Object[])new Object[0]);
        }
        Entry fileEntry = this.ivModuleContainer.getEntry(fileName);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("file entry = " + fileEntry), (Object[])new Object[0]);
        }
        if (fileEntry == null) {
            throw new ValidationException("File not found : " + this.ivModuleContainer.getPath() + "/" + fileName);
        }
        try {
            fileInputStream = (InputStream)fileEntry.adapt(InputStream.class);
        }
        catch (UnableToAdaptException ex) {
            throw new ValidationException("Unable to open " + this.ivModuleContainer.getPath() + "/" + fileName, (Throwable)ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInputStream : " + fileInputStream));
        }
        return fileInputStream;
    }

    public String toString() {
        return OSGiBeanValidationScopeData.class.getSimpleName() + "[" + this.ivModuleContainer.getName() + ", " + Util.identity((Object)this.ivValidatorFactory) + "]";
    }
}

