/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DBPortability {
    public static final int UNKNOWN = 0;
    public static final int DB2_NT = 1;
    public static final int DB2_AS400 = 2;
    public static final int INSTANTDB = 3;
    public static final int DB2_AIX = 1;
    public static final int DB2_SUN = 1;
    public static final int DB2_HPUX = 1;
    public static final int ORACLE = 4;
    public static final int SYBASE = 5;
    public static final int DB2_CONNECT = 6;
    public static final int MICROSOFT_SQLSERVER = 7;
    public static final int INFORMIX = 8;
    public static final int CLOUDSCAPE = 9;
    public static final int DB2_zOS = 10;
    public static final int DERBY = 11;
    public static final int SOLIDDB = 12;
    public static final int POSTGRESQL = 13;
    public static final int MYSQL = 14;

    public static int getDBCode(DatabaseMetaData dbMetaData) throws SQLException {
        String dbProductName = dbMetaData.getDatabaseProductName();
        if (dbProductName.toUpperCase().indexOf("INSTANTDB") != -1) {
            return 3;
        }
        if (dbProductName.toUpperCase().indexOf("DB2/NT") != -1) {
            return 1;
        }
        if (dbProductName.toUpperCase().indexOf("DB2/SUN") != -1) {
            return 1;
        }
        if (dbProductName.toUpperCase().indexOf("DB2/6000") != -1) {
            return 1;
        }
        if (dbProductName.toUpperCase().indexOf("DB2/HPUX") != -1) {
            return 1;
        }
        if (dbProductName.toUpperCase().indexOf("DB2 UDB FOR AS/400") != -1 || dbProductName.toUpperCase().indexOf("DB2/400 SQL") != -1 || dbProductName.toUpperCase().indexOf("DB2 UDB for eServer iSeries") != -1) {
            return 2;
        }
        if (dbProductName.toUpperCase().indexOf("DB2/LINUX") != -1) {
            return 1;
        }
        if (dbProductName.toUpperCase().indexOf("ORACLE") != -1) {
            return 4;
        }
        if (dbProductName.toUpperCase().indexOf("SYBASE SQL SERVER") != -1 || dbProductName.toUpperCase().indexOf("ADAPTIVE SERVER ENTERPRISE") != -1) {
            return 5;
        }
        if (dbProductName.toUpperCase().trim().equals("DB2")) {
            String dbProductVersion = dbMetaData.getDatabaseProductVersion();
            if (dbProductVersion.toUpperCase().indexOf("DSN") != -1) {
                return 10;
            }
            return 6;
        }
        if (dbProductName.toUpperCase().indexOf("MICROSOFT") != -1) {
            return 7;
        }
        if (dbProductName.toUpperCase().indexOf("INFORMIX") != -1 || dbProductName.toUpperCase().indexOf("IDS") != -1) {
            return 8;
        }
        if (dbProductName.toUpperCase().indexOf("DSN") != -1) {
            return 10;
        }
        if (dbProductName.toUpperCase().indexOf("DERBY") != -1 || dbProductName.toUpperCase().indexOf("DB2J") != -1) {
            return 11;
        }
        if (dbProductName.toUpperCase().indexOf("CLOUDSCAPE") != -1 || dbProductName.toUpperCase().indexOf("DB2J") != -1) {
            return 9;
        }
        if (dbProductName.toUpperCase().indexOf("IBM SOLIDDB") != -1) {
            return 12;
        }
        if (dbProductName.toUpperCase().indexOf("POSTGRESQL") != -1) {
            return 13;
        }
        if (dbProductName.toUpperCase().indexOf("MYSQL") != -1) {
            return 14;
        }
        return 1;
    }
}

