/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LogicalHandlerInInterceptor
extends AbstractJAXWSHandlerInterceptor<Message> {
    static final long serialVersionUID = -8962508936237995905L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LogicalHandlerInInterceptor(Binding binding) {
        super(binding, "pre-protocol-frontend");
        this.addAfter(SOAPHandlerInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        if (this.binding.getHandlerChain().isEmpty()) {
            return;
        }
        HandlerChainInvoker invoker = this.getInvoker(message);
        if (invoker.getLogicalHandlers().isEmpty()) {
            return;
        }
        LogicalMessageContextImpl lctx = new LogicalMessageContextImpl(message);
        invoker.setLogicalMessageContext(lctx);
        boolean requestor = this.isRequestor(message);
        if (!requestor) {
            this.setupBindingOperationInfo(message.getExchange(), lctx);
        }
        if (!invoker.invokeLogicalHandlers(requestor, lctx) && !requestor) {
            this.handleAbort(message, null);
        }
        if (!this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        }
    }

    private void handleAbort(Message message, W3CDOMStreamWriter writer) {
        message.getInterceptorChain().abort();
        if (!message.getExchange().isOneWay()) {
            Endpoint e = (Endpoint)message.getExchange().get(Endpoint.class);
            MessageImpl responseMsg = new MessageImpl();
            responseMsg.setExchange(message.getExchange());
            responseMsg = e.getBinding().createMessage((Message)responseMsg);
            message.getExchange().setOutMessage((Message)responseMsg);
            XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (reader == null && writer != null) {
                reader = StaxUtils.createXMLStreamReader((Document)writer.getDocument());
            }
            InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange());
            responseMsg.setInterceptorChain(chain);
            responseMsg.put((Object)"LogicalHandlerInterceptor.INREADER", (Object)reader);
            chain.doIntercept((Message)responseMsg);
        }
    }

    public void handleFault(Message message) {
    }

    @Override
    protected QName getOpQName(Exchange ex, Object data) {
        LogicalMessageContextImpl sm = (LogicalMessageContextImpl)data;
        Source src = sm.getMessage().getPayload();
        if (src instanceof DOMSource) {
            DOMSource dsrc = (DOMSource)src;
            String ln = dsrc.getNode().getLocalName();
            String ns = dsrc.getNode().getNamespaceURI();
            return new QName(ns, ln);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LogicalHandlerInInterceptor.class);
    }
}

