/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.wab.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.wab.internal.WAB;
import com.ibm.ws.app.manager.wab.internal.WABInstaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class WABGroup {
    private ConcurrentLinkedQueue<WAB> wabs;
    private volatile boolean groupUninstalled = false;
    private final DeployedAppInfo deployedAppInfo;
    static final long serialVersionUID = 2339552970658495285L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    WABGroup(DeployedAppInfo deployedAppInfo) {
        this.deployedAppInfo = deployedAppInfo;
    }

    DeployedAppInfo getDeployedAppInfo() {
        return this.deployedAppInfo;
    }

    void addWab(WAB wab, WABInstaller installer) {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException();
        }
        if (this.wabs == null) {
            this.wabs = new ConcurrentLinkedQueue();
        }
        this.wabs.add(wab);
        if (this.groupUninstalled) {
            this.uninstallGroup(installer);
        }
    }

    void uninstallGroup(WABInstaller installer) {
        if (this.wabs != null) {
            ArrayList<WAB> toRemove = new ArrayList<WAB>();
            for (WAB wab : this.wabs) {
                wab.terminateWAB();
                wab.removeWAB();
                toRemove.add(wab);
            }
            this.wabs.removeAll(toRemove);
            if (this.wabs.size() != 0) {
                installer.wabLifecycleDebug("First pass wab group uninstall detected outstanding WABs", this.wabs);
                toRemove.clear();
                for (WAB wab : this.wabs) {
                    wab.terminateWAB();
                    wab.removeWAB();
                    toRemove.add(wab);
                }
                this.wabs.removeAll(toRemove);
                if (this.wabs.size() != 0) {
                    installer.wabLifecycleDebug("Second pass wab group uninstall detected outstanding WABs", this.wabs);
                }
            }
        }
    }

    void removeWAB(WAB wab) {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException();
        }
        this.wabs.remove(wab);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hashCode());
        sb.append(":");
        sb.append(this.wabs);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WABGroup.class);
    }
}

