/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.collective.repository;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.RepositoryClient;
import com.ibm.wsspi.collective.repository.RepositoryMember;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RepositoryConnectionFactory.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class RepositoryConnectionFactory {
    private static final TraceComponent tc = Tr.register(RepositoryConnectionFactory.class);
    static final String KEY_REPOSITORY_CLIENT = "repositoryClient";
    static final String KEY_REPOSITORY_MEMBER = "repositoryMember";
    private static final AtomicServiceReference<RepositoryClient> repositoryClientRef = new AtomicServiceReference("repositoryClient");
    private static final AtomicServiceReference<RepositoryMember> repositoryMemberRef = new AtomicServiceReference("repositoryMember");
    static final long serialVersionUID = -8768739139611813646L;

    @Reference(name="repositoryClient", service=RepositoryClient.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(clientType=RepositoryClientDelegate)")
    protected void setRepositoryClient(ServiceReference<RepositoryClient> ref) {
        if (repositoryClientRef.getReference() != null) {
            Tr.error((TraceComponent)tc, (String)"REGISTRY_CONFIG_FACTORY_TOO_MANY_CLIENT_SERVICES", (Object[])new Object[]{repositoryClientRef.getReference().getBundle().getSymbolicName(), ref.getBundle().getSymbolicName()});
        }
        repositoryClientRef.setReference(ref);
    }

    protected void unsetRepositoryClient(ServiceReference<RepositoryClient> ref) {
        repositoryClientRef.unsetReference(ref);
    }

    @Reference(name="repositoryMember", service=RepositoryMember.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(memberType=RepositoryMemberDelegate)")
    protected void setRepositoryMember(ServiceReference<RepositoryMember> ref) {
        if (repositoryMemberRef.getReference() != null) {
            Tr.error((TraceComponent)tc, (String)"REGISTRY_CONFIG_FACTORY_TOO_MANY_MEMBER_SERVICES", (Object[])new Object[]{repositoryMemberRef.getReference().getBundle().getSymbolicName(), ref.getBundle().getSymbolicName()});
        }
        repositoryMemberRef.setReference(ref);
    }

    protected void unsetRepositoryMember(ServiceReference<RepositoryMember> ref) {
        repositoryMemberRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        repositoryClientRef.activate(cc);
        repositoryMemberRef.activate(cc);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"RepositoryConnectionFactory is now active and available as an OSGi service", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"RepositoryConnectionFactory has been deactived and is no longer available as an OSGi service", (Object[])new Object[0]);
        }
        repositoryClientRef.deactivate(cc);
        repositoryMemberRef.deactivate(cc);
    }

    public static RepositoryClient getRepositoryClient() {
        RepositoryClient client = (RepositoryClient)repositoryClientRef.getService();
        if (client == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No RepositoryClient service is available.", (Object[])new Object[0]);
        }
        return client;
    }

    public RepositoryClient obtainRepositoryClient() {
        return RepositoryConnectionFactory.getRepositoryClient();
    }

    public static RepositoryMember getRepositoryMember() {
        RepositoryMember member = (RepositoryMember)repositoryMemberRef.getService();
        if (member == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No RepositoryClient service is available.", (Object[])new Object[0]);
        }
        return member;
    }

    public RepositoryMember obtainRepositoryMember() {
        return RepositoryConnectionFactory.getRepositoryMember();
    }
}

