/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ws.session.SessionCookieConfigImpl;
import java.util.EnumSet;
import javax.servlet.ServletContext;
import javax.servlet.SessionTrackingMode;

public class SessionApplicationParameters {
    private String sapAppName = null;
    private long sapSessionTimeout = 0L;
    private SessionCookieConfigImpl sapSessionCookieConfig = null;
    private EnumSet<SessionTrackingMode> sapSessionTrackingMode = null;
    private final boolean sapDistributableWebApp;
    private final boolean sapAllowDispatchRemoteInclude;
    private final ServletContext sapServletContext;
    private String _J2EEName = null;
    private final ClassLoader _appClassLoader;
    private boolean hasApplicationSession = false;
    private String applicationSessionName = null;
    private boolean sessionConfigOverridden = false;

    public SessionApplicationParameters(String appName, boolean session_timeout_set, long session_timeout, boolean distributableWebApp, boolean allowDispatchRemoteInclude, ServletContext sc, ClassLoader appClassLoader, String j2eeName, SessionCookieConfigImpl cookieConfig, boolean moduleSessionTrackingModeSet, EnumSet<SessionTrackingMode> sessionTrackingMode) {
        this.sapAppName = appName;
        this._J2EEName = j2eeName;
        this.sapSessionTimeout = !session_timeout_set ? 0L : (session_timeout > 0L ? session_timeout * 60L : -1L);
        this.sapSessionCookieConfig = cookieConfig;
        if (this.sapSessionCookieConfig != null) {
            this.sessionConfigOverridden = true;
        }
        if (moduleSessionTrackingModeSet) {
            this.sessionConfigOverridden = true;
            this.sapSessionTrackingMode = sessionTrackingMode;
        }
        this.sapDistributableWebApp = distributableWebApp;
        this.sapAllowDispatchRemoteInclude = allowDispatchRemoteInclude;
        this.sapServletContext = sc;
        this._appClassLoader = appClassLoader;
    }

    public void setSapSessionTimeout(long sapSessionTimeout) {
        this.sapSessionTimeout = sapSessionTimeout;
    }

    public String getAppName() {
        return this.sapAppName;
    }

    public long getSessionTimeout() {
        return this.sapSessionTimeout;
    }

    SessionCookieConfigImpl getSessionCookieConfig() {
        return this.sapSessionCookieConfig;
    }

    EnumSet<SessionTrackingMode> getSessionTrackingModes() {
        return this.sapSessionTrackingMode;
    }

    boolean getDistributableWebApp() {
        return this.sapDistributableWebApp;
    }

    public boolean getAllowDispatchRemoteInclude() {
        return this.sapAllowDispatchRemoteInclude;
    }

    public ServletContext getServletContext() {
        return this.sapServletContext;
    }

    public String getJ2EEName() {
        return this._J2EEName;
    }

    public ClassLoader getAppClassLoader() {
        return this._appClassLoader;
    }

    public void setHasApplicationSession(boolean b) {
        this.hasApplicationSession = b;
    }

    public boolean getHasApplicationSession() {
        return this.hasApplicationSession;
    }

    public void setApplicationSessionName(String s) {
        this.applicationSessionName = s;
    }

    public String getApplicationSessionName() {
        return this.applicationSessionName;
    }

    public boolean isSessionConfigOverridden() {
        return this.sessionConfigOverridden;
    }
}

