/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.security.authentication.tai.TAIUtil;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIAuthenticator
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(TAIAuthenticator.class);
    private TAIService taiService = null;
    private ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef = null;
    private SSOCookieHelper ssoCookieHelper = null;
    private AuthenticationService authenticationService = null;
    private final AuthenticationResult AUTHN_CONTINUE_RESULT = new AuthenticationResult(AuthResult.CONTINUE, "Authentication continue");
    private final String DISABLE_LTPA_AND_SESSION_NOT_ON_OR_AFTER = "com.ibm.ws.saml.spcookie.session.not.on.or.after";
    Map<String, TrustAssociationInterceptor> invokeBeforeSSOTais = new LinkedHashMap<String, TrustAssociationInterceptor>();
    Map<String, TrustAssociationInterceptor> invokeAfterSSOTais = new LinkedHashMap<String, TrustAssociationInterceptor>();
    static final long serialVersionUID = 5416276392955680341L;

    public TAIAuthenticator(TAIService taiService, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, AuthenticationService authenticationService, SSOCookieHelper ssoCookieHelper) {
        this.taiService = taiService;
        this.interceptorServiceRef = interceptorServiceRef;
        this.authenticationService = authenticationService;
        this.ssoCookieHelper = ssoCookieHelper;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        return this.authenticate(webRequest, false);
    }

    /*
     * WARNING - void declaration
     */
    public AuthenticationResult authenticate(WebRequest webRequest, boolean invokeBeforeSSO) {
        AuthenticationResult authResult = this.AUTHN_CONTINUE_RESULT;
        TAIResult taiResult = null;
        String taiType = null;
        boolean isTargetIntercept = false;
        Map<String, TrustAssociationInterceptor> tais = this.getInterceptorServices(invokeBeforeSSO);
        if (this.skipTai(webRequest, tais, invokeBeforeSSO)) {
            return this.AUTHN_CONTINUE_RESULT;
        }
        HttpServletRequest req = webRequest.getHttpServletRequest();
        HttpServletResponse res = webRequest.getHttpServletResponse();
        try {
            Iterator<Map.Entry<String, TrustAssociationInterceptor>> i = tais.entrySet().iterator();
            while (i.hasNext()) {
                TrustAssociationInterceptor tai = i.next().getValue();
                if (!tai.isTargetInterceptor(req)) continue;
                isTargetIntercept = true;
                taiType = tai.getType();
                taiResult = tai.negotiateValidateandEstablishTrust(req, res);
                break;
            }
            if (!isTargetIntercept) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TAI authenticator" + (invokeBeforeSSO ? " before SSO " : " after SSO ") + "does not intercept this request"), (Object[])new Object[0]);
                }
                return this.AUTHN_CONTINUE_RESULT;
            }
        }
        catch (WebTrustAssociationFailedException i) {
            void e;
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.webcontainer.security.internal.TAIAuthenticator", (String)"120", (Object)this, (Object[])new Object[]{webRequest, invokeBeforeSSO});
            Tr.error((TraceComponent)tc, (String)"SEC_TAI_VALIDATE_FAILED", (Object[])new Object[]{e});
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        catch (WebTrustAssociationUserException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.security.internal.TAIAuthenticator", (String)"123", (Object)this, (Object[])new Object[]{webRequest, invokeBeforeSSO});
            Tr.error((TraceComponent)tc, (String)"SEC_TAI_USER_EXCEPTION", (Object[])new Object[]{e});
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.security.internal.TAIAuthenticator", (String)"126", (Object)this, (Object[])new Object[]{webRequest, invokeBeforeSSO});
            Tr.error((TraceComponent)tc, (String)"SEC_TAI_GENERAL_EXCEPTION", (Object[])new Object[]{e});
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        if (authResult.getStatus() == AuthResult.FAILURE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TAI throws an un-expected exception: " + authResult.getReason()), (Object[])new Object[0]);
            }
            return authResult;
        }
        return this.handleTaiResult(taiResult, taiType, req, res);
    }

    private void processInterceptorServices() {
        TAIUtil taiUtil = new TAIUtil();
        Set interceptorIds = this.interceptorServiceRef.keySet();
        for (String interceptorId : interceptorIds) {
            TrustAssociationInterceptor tai = (TrustAssociationInterceptor)this.interceptorServiceRef.getService((Object)interceptorId);
            taiUtil.processTAIUserFeatureProps(this.interceptorServiceRef, interceptorId);
            if (taiUtil.isInvokeBeforeSSO()) {
                this.invokeBeforeSSOTais.put(interceptorId, tai);
            }
            if (!taiUtil.isInvokeAfterSSO()) continue;
            this.invokeAfterSSOTais.put(interceptorId, tai);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invokeBeforeSSOTais " + this.invokeBeforeSSOTais.toString()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("invokeAfterSSOTais " + this.invokeAfterSSOTais.toString()), (Object[])new Object[0]);
        }
    }

    private Map<String, TrustAssociationInterceptor> getInterceptorServices(boolean invokeBeforeSSO) {
        if (this.taiService != null) {
            return this.taiService.getTais(invokeBeforeSSO);
        }
        this.processInterceptorServices();
        if (invokeBeforeSSO) {
            return this.invokeBeforeSSOTais;
        }
        return this.invokeAfterSSOTais;
    }

    private boolean skipTai(WebRequest webRequest, Map<String, TrustAssociationInterceptor> tais, boolean invokeBeforeSSO) {
        boolean skipIt = false;
        if (tais == null || tais.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There is no interceptor config to invoke" + (invokeBeforeSSO ? " before SSO " : " after SSO ") + ", skipping TAI..."), (Object[])new Object[0]);
            }
            return true;
        }
        if (webRequest.isUnprotectedURI() && !webRequest.isProviderSpecialUnprotectedURI() && this.taiService != null && !this.taiService.isInvokeForUnprotectedURI()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Skipping interceptor for unprotected URI...", (Object[])new Object[0]);
            }
            return true;
        }
        return skipIt;
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationResult handleTaiResult(TAIResult taiResult, String taiType, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationResult authResult;
        try {
            authResult = taiResult != null && taiResult.getStatus() == 200 ? this.authenticateWithTAIResult(req, res, taiResult) : this.handleFallBackToAppAuthType(taiType, taiResult);
        }
        catch (AuthenticationException authenticationException) {
            void e;
            FFDCFilter.processException((Throwable)authenticationException, (String)"com.ibm.ws.webcontainer.security.internal.TAIAuthenticator", (String)"220", (Object)this, (Object[])new Object[]{taiResult, taiType, req, res});
            authResult = new AuthenticationResult(AuthResult.SEND_401, e.getMessage());
        }
        return authResult;
    }

    private AuthenticationResult handleFallBackToAppAuthType(String taiType, TAIResult taiResult) throws AuthenticationException {
        AuthenticationResult authResult = null;
        if (this.taiService != null && this.taiService.isFailOverToAppAuthType() || taiResult != null && taiResult.getStatus() == 100) {
            if (taiResult == null) {
                return new AuthenticationResult(AuthResult.CONTINUE, "TAI allows fall back to application authentication type");
            }
            return new AuthenticationResult(AuthResult.CONTINUE, taiResult.getSubject());
        }
        authResult = taiResult == null ? new AuthenticationResult(AuthResult.FAILURE, "taiResult is null") : new AuthenticationResult(AuthResult.TAI_CHALLENGE, "TrustAssociation Interception returns error", taiResult.getStatus());
        return authResult;
    }

    private AuthenticationResult authenticateWithTAIResult(HttpServletRequest req, HttpServletResponse res, TAIResult taiResult) throws AuthenticationException {
        AuthenticationResult authResult = null;
        String taiUserName = taiResult.getAuthenticatedPrincipal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TAI user name: " + taiUserName), (Object[])new Object[0]);
        }
        if (taiUserName != null) {
            Subject taiSubject = taiResult.getSubject();
            if (taiSubject != null) {
                SubjectHelper subjectHelper = new SubjectHelper();
                WSCredential wsCred = subjectHelper.getWSCredential(taiSubject);
                if (wsCred != null && wsCred.isUnauthenticated()) {
                    new AuthenticationResult(AuthResult.FAILURE, "Subject from TAI is invalid for user: " + taiUserName);
                }
                authResult = this.authenticateWithSubject(req, res, taiSubject);
            }
            if (!(authResult != null && authResult.getStatus() == AuthResult.SUCCESS || (authResult = this.loginWithTAIUserName(req, res, taiSubject, taiUserName)) != null && authResult.getStatus() == AuthResult.SUCCESS)) {
                authResult = new AuthenticationResult(AuthResult.CONTINUE, "authenticate failed.... allow to continue");
            }
        } else {
            authResult = new AuthenticationResult(AuthResult.FAILURE, "TAI user name is null");
        }
        return authResult;
    }

    private AuthenticationResult loginWithTAIUserName(HttpServletRequest req, HttpServletResponse res, Subject taiSubject, String taiUserName) {
        AuthenticationResult authResult = null;
        Subject subject = this.createUserIdHashtableSubject(taiSubject, taiUserName);
        authResult = this.authenticateWithSubject(req, res, subject);
        return authResult;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private AuthenticationResult authenticateWithSubject(HttpServletRequest req, HttpServletResponse res, Subject subject) {
        AuthenticationResult authResult;
        try {
            AuthenticationData authenticationData = this.createAuthenticationData(req, res, subject);
            Subject new_subject = this.authenticationService.authenticate("system.WEB_INBOUND", authenticationData, subject);
            authResult = new AuthenticationResult(AuthResult.SUCCESS, new_subject);
            if (!this.isDisableLtpaCookie(new_subject)) {
                this.ssoCookieHelper.addSSOCookiesToResponse(new_subject, req, res);
            }
        }
        catch (AuthenticationException e) {
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        return authResult;
    }

    private boolean isDisableLtpaCookie(Subject subject) {
        SubjectHelper subjectHelper = new SubjectHelper();
        Hashtable hashtable = subjectHelper.getHashtableFromSubject(subject, new String[]{"com.ibm.ws.saml.spcookie.session.not.on.or.after"});
        return hashtable != null;
    }

    private Subject createUserIdHashtableSubject(Subject taiSubject, String taiUserName) {
        Subject newSubject = taiSubject;
        if (newSubject == null) {
            newSubject = new Subject();
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.authenticationService == null || !this.authenticationService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            hashtable.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        hashtable.put("com.ibm.wsspi.security.cred.userId", taiUserName);
        newSubject.getPublicCredentials().add(hashtable);
        return newSubject;
    }

    @Trivial
    protected AuthenticationData createAuthenticationData(HttpServletRequest req, HttpServletResponse res, Subject subject) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
        authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)res);
        try {
            Cookie ltpaCookie;
            if (subject != null && (ltpaCookie = WebSecurityHelperImpl.getLTPACookie(subject)) != null) {
                authenticationData.set("TOKEN64", (Object)ltpaCookie.getValue());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.internal.TAIAuthenticator", (String)"366", (Object)this, (Object[])new Object[]{req, res, subject});
        }
        return authenticationData;
    }

    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap props) throws Exception {
        return null;
    }
}

