/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.AlgorithmIds;
import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class EncKeyPairTypesInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.enc_key_pair_types_oid;
    private AlgorithmIds value;
    private byte[] encodedValue;

    public EncKeyPairTypesInfoValue(AlgorithmIds algorithmIds) throws IOException {
        if (algorithmIds == null) {
            throw new IllegalArgumentException("EncKeyPairTypesInfoValue error, algids not specified");
        }
        this.value = (AlgorithmIds)algorithmIds.clone();
        this.setEncodedValue();
    }

    public EncKeyPairTypesInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public EncKeyPairTypesInfoValue(AlgorithmId[] algorithmIdArray) throws IOException {
        if (algorithmIdArray == null) {
            throw new IllegalArgumentException("EncKeyPairTypesInfoValue error, algids not specified");
        }
        if (algorithmIdArray.length == 0) {
            throw new IllegalArgumentException("EncKeyPairTypesInfoValue error, there should be at least one algorithm identifier");
        }
        this.value = new AlgorithmIds(algorithmIdArray);
        this.setEncodedValue();
    }

    public Object clone() {
        try {
            return new EncKeyPairTypesInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.value = new AlgorithmIds(derValue.toByteArray());
        try {
            this.setEncodedValue();
        }
        catch (Exception exception) {
            throw new IOException("EncKeyPairTypesInfoValue parsing error, " + exception);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncodedValue());
    }

    public boolean equals(EncKeyPairTypesInfoValue encKeyPairTypesInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (encKeyPairTypesInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            encKeyPairTypesInfoValue.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof EncKeyPairTypesInfoValue) {
            return this.equals((EncKeyPairTypesInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "EncKeyPairTypes";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        return (AlgorithmIds)this.value.clone();
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode(derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "EncKeyPairTypesInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\n" + this.value;
        return string;
    }
}

