/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.common.ClientCommsDiagnosticModule;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.server.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServerCommsDiagnosticModule
extends ClientCommsDiagnosticModule {
    private static final TraceComponent tc = SibTr.register(ServerCommsDiagnosticModule.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static ServerCommsDiagnosticModule _serverSingleton = null;

    public static ServerCommsDiagnosticModule getInstance() {
        if (_serverSingleton == null) {
            _serverSingleton = new ServerCommsDiagnosticModule();
        }
        return _serverSingleton;
    }

    private ServerCommsDiagnosticModule() {
    }

    protected void dumpJFapServerStatus(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapServerStatus", (Object)is);
        }
        this.dumpMEtoMEConversations(is);
        this.dumpInboundConversations(is);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpJFapServerStatus");
        }
    }

    private void dumpMEtoMEConversations(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversations", (Object)is);
        }
        ServerConnectionManager scm = ServerConnectionManager.getRef();
        List obc = scm.getActiveOutboundMEtoMEConversations();
        is.writeLine("", "");
        is.writeLine("\n------ ME to ME Conversation Dump ------ ", ">");
        if (obc != null) {
            Map connectionToConversationMap = this.convertToMap(is, obc);
            for (Map.Entry entry : connectionToConversationMap.entrySet()) {
                is.writeLine("\nOutbound connection:", entry.getKey());
                LinkedList conversationList = (LinkedList)entry.getValue();
                while (!conversationList.isEmpty()) {
                    Conversation c = (Conversation)conversationList.removeFirst();
                    is.writeLine("\nOutbound Conversation[" + c.getId() + "]: ", c.getFullSummary());
                    try {
                        this.dumpMEtoMEConversation(is, c);
                    }
                    catch (Throwable t) {
                        is.writeLine("\nUnable to dump conversation", (Object)t);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversations");
        }
    }

    private void dumpInboundConversations(IncidentStream is) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpInboundConversations", (Object)is);
        }
        List serverConvs = ServerTransportAcceptListener.getInstance().getActiveConversations();
        is.writeLine("", "");
        is.writeLine("\n------ Inbound Conversation Dump ------ ", ">");
        if (serverConvs != null) {
            HashMap<ConnectionInterface, LinkedList> connectionToConversationMap = new HashMap<ConnectionInterface, LinkedList>();
            Iterator i = serverConvs.iterator();
            while (i.hasNext()) {
                try {
                    LinkedList conversationList;
                    Conversation c = (Conversation)i.next();
                    ConnectionInterface connectionObject = c.getConnectionReference();
                    if (!connectionToConversationMap.containsKey(connectionObject)) {
                        conversationList = new LinkedList();
                        connectionToConversationMap.put(connectionObject, conversationList);
                    } else {
                        conversationList = (LinkedList)connectionToConversationMap.get(connectionObject);
                    }
                    conversationList.add(c);
                }
                catch (Throwable t) {
                    is.writeLine("\nUnable to dump conversation", (Object)t);
                }
            }
            Set entries = connectionToConversationMap.entrySet();
            for (Map.Entry entry : entries) {
                Object connectionObject = entry.getKey();
                is.writeLine("\nInbound connection:", connectionObject);
                LinkedList conversationList = (LinkedList)entry.getValue();
                while (!conversationList.isEmpty()) {
                    Conversation c = (Conversation)conversationList.removeFirst();
                    is.writeLine("\nInbound Conversation[" + c.getId() + "]: ", c.getFullSummary());
                    try {
                        this.dumpServerConversation(is, c);
                    }
                    catch (Throwable t) {
                        is.writeLine("\nUnable to dump conversation", (Object)t);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpInboundConversations");
        }
    }

    private void dumpServerConversation(IncidentStream is, Conversation conv) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpServerConversation", (Object)new Object[]{is, conv});
        }
        ConversationState convState = (ConversationState)conv.getAttachment();
        List allObjs = convState.getAllObjects();
        is.writeLine("Number of associated resources", allObjs.size());
        for (Object obj : allObjs) {
            if (obj instanceof SICoreConnection) {
                SICoreConnection conn = (SICoreConnection)obj;
                is.writeLine("  ", "SICoreConnection@" + Integer.toHexString(obj.hashCode()) + ": ME Name: " + conn.getMeName() + " [" + conn.getMeUuid() + "] Version: " + conn.getApiLevelDescription());
                continue;
            }
            is.writeLine("  ", obj);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpServerConversation");
        }
    }

    private void dumpMEtoMEConversation(IncidentStream is, Conversation conv) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversation", (Object)new Object[]{is, conv});
        }
        ConversationState convState = (ConversationState)conv.getAttachment();
        MEConnection commsConnection = (MEConnection)convState.getCommsConnection();
        is.writeLine("  Connected using: ", (Object)commsConnection);
        JsMessagingEngine me = commsConnection.getMessagingEngine();
        String meInfo = me == null ? "<null>" : me.getName() + " [" + me.getUuid() + "]";
        is.writeLine("  Local ME: ", meInfo);
        is.writeLine("  Target ME: ", commsConnection.getTargetInformation());
        is.introspectAndWriteLine("Introspection of the conversation state:", (Object)convState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"dumpMEtoMEConversation");
        }
    }
}

