/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal.impl;

import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XBinary;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.XInt;
import com.ibm.xml.xlxp2.datatype.XList;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.datatype.validation.BooleanDV;
import com.ibm.xml.xlxp2.datatype.validation.DoubleDV;
import com.ibm.xml.xlxp2.datatype.validation.FloatDV;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringTokenizer;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.datatype.validation.XSBase64BinaryUtil;
import com.ibm.xml.xlxp2.datatype.validation.XSHexBinaryUtil;
import com.ibm.xml.xlxp2.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp2.jaxb.model.ElementDeclaration;
import com.ibm.xml.xlxp2.jaxb.model.ElementProperty;
import com.ibm.xml.xlxp2.jaxb.model.EnumClass;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.model.ValueTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.converter.DecimalDV;
import com.ibm.xml.xlxp2.jaxb.model.converter.IntegerDV;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationStub;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationStubFactory;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.UTF8Support;
import com.ibm.xml.xlxp2.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DeserializationContext
extends ValidationContext {
    public static final CollapsedStringAdapter COLLAPSED_STRING_ADAPTER = new CollapsedStringAdapter();
    private static final Class<Object> OBJECT_CLASS = Object.class;
    public final Unmarshaller unmarshaller;
    public final JAXBModel model;
    public final DeserializationStubFactory stubFactory;
    public final DeserializationStub rootStub;
    public final DeserializationStub[] freeStubs;
    public final int[] oneIntArray = ArrayAllocator.newIntArray(1);
    public final DatatypeFactory datatypeFactory;
    public ElementDeclaration rootElementDecl;
    public int currentPropertyId;
    public boolean currentElementNilled;
    public ElementProperty elementProperty;
    ValueTypeInformation currentSimpleType;
    public DeserializationStub currentStub;
    public boolean elementContentDeserialized;
    public Class<?> declaredType = OBJECT_CLASS;
    private final XMLStringTokenizer tokenizer = new XMLStringTokenizer();
    private final XMLString token = new XMLString();
    private final XList list = new XList();
    private final HashMap<String, Object> idMap = new HashMap();
    private final List<IDREFValue> idrefList = new ArrayList<IDREFValue>();
    private Document documentNode;
    private Node currentNode;
    private String[] inScopeMappings;
    public boolean isFragmentRoot = true;
    int skipDepth = 0;
    private final XDecimal fXDecimal = new XDecimal();
    private final XDecimal2 fXDecimal2 = new XDecimal2(this.fXDecimal);
    private final XDateTime2 fXDateTime2 = new XDateTime2();
    private final XBoolean fXBoolean = new XBoolean();
    private final XInt fXInt = new XInt();
    private final XLong fXLong = new XLong();
    private final boolean[] normalized = ArrayAllocator.newBooleanArray(1);
    private static final String XOP_INCLUDE_LOCAL_NAME = "Include";
    private static final String XOP_INCLUDE_NS_URI = "http://www.w3.org/2004/08/xop/include";
    private static final String HREF_LOCAL_NAME = "href";
    public final JAXPQNameProducer jaxpQNameProducer;

    public DeserializationContext(JAXBModel jAXBModel, DeserializationStubFactory deserializationStubFactory, DatatypeFactory datatypeFactory) {
        this(jAXBModel, deserializationStubFactory, datatypeFactory, null);
    }

    public DeserializationContext(JAXBModel jAXBModel, DeserializationStubFactory deserializationStubFactory, DatatypeFactory datatypeFactory, Unmarshaller unmarshaller) {
        this.model = jAXBModel;
        this.stubFactory = deserializationStubFactory;
        this.datatypeFactory = datatypeFactory;
        this.unmarshaller = unmarshaller;
        this.rootStub = deserializationStubFactory.createRootStub(jAXBModel);
        this.rootStub.setContext(this);
        this.freeStubs = ArrayAllocator.newObjectArray(DeserializationStub.class, jAXBModel.valueClassCount);
        this.jaxpQNameProducer = new JAXPQNameProducer();
    }

    public final void handleStartDocumentEvent() {
        this.rootStub.o = null;
        this.currentStub = this.rootStub;
    }

    public final void handleEndDocumentEvent() {
        int n = this.idrefList.size();
        for (int i = 0; i < n; ++i) {
            IDREFValue iDREFValue = this.idrefList.get(i);
            Object object = this.idMap.get(iDREFValue.value);
            if (object == null) continue;
            iDREFValue.stub.writeIDREFValue(iDREFValue.propertyId, iDREFValue.target, object);
        }
    }

    public final void handleRootElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName, boolean bl) {
        this.handleRootElementEvent(qName, null, bl);
    }

    public final void handleRootElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName, ValueTypeInformation valueTypeInformation, boolean bl) {
        ValueTypeInformation valueTypeInformation2;
        this.currentStub = this.rootStub;
        if (this.vmContext.eDecl != null) {
            this.currentPropertyId = this.vmContext.eDeclIndex;
            this.rootElementDecl = this.model.elementDeclarations[this.currentPropertyId];
            valueTypeInformation2 = this.vmContext.eDecl.type == this.vmContext.eType ? this.rootElementDecl.typeInfo.valueType : this.model.typeInformation[this.vmContext.eType.index];
        } else {
            this.currentPropertyId = this.model.elementDeclarations.length;
            this.rootElementDecl = null;
            int n = this.vmContext.eType.index;
            valueTypeInformation2 = n >= 0 ? this.model.typeInformation[n] : valueTypeInformation;
        }
        ValueClass valueClass = valueTypeInformation2.valueClass;
        if (valueClass != null) {
            boolean bl2;
            this.startComplexType(valueClass, bl);
            boolean bl3 = bl2 = valueClass.simpleContentProperty != null;
            if (bl2) {
                this.setupSimpleContent(valueClass.simpleContentProperty.propertyTypeInfo.valueType);
            }
            if (bl) {
                if (bl2) {
                    if (!this.elementContentDeserialized) {
                        this.handleSimpleContent(this.vmContext.leafNilled);
                    }
                    this.currentSimpleType = null;
                }
                this.endComplexType();
            }
        } else {
            this.setupSimpleContent(valueTypeInformation2);
            if (bl) {
                if (!this.elementContentDeserialized) {
                    this.handleSimpleContent(this.vmContext.leafNilled);
                }
                this.currentSimpleType = null;
            }
        }
    }

    public final void handleSkippedRootElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName, boolean bl) {
        JAXBMessageProvider.throwUnmarshalExceptionWrapper(JAXBMessageProvider.createMessage(null, 0, new QName(qName.nsURI, qName.localName).toString(), this.getExpectedElementsAtRoot()));
    }

    public final void handleStartElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName) {
        ValueTypeInformation valueTypeInformation;
        if (this.vmContext.eDecl != null) {
            this.currentPropertyId = this.vmContext.eDeclIndex;
            this.elementProperty = this.currentStub.valueClass.elementProperties[this.currentPropertyId];
            valueTypeInformation = this.vmContext.eDecl.type == this.vmContext.eType ? this.elementProperty.propertyTypeInfo.valueType : this.model.typeInformation[this.vmContext.eType.index];
        } else {
            this.currentPropertyId = this.currentStub.valueClass.elementWildcardProperty.propertyId;
            this.elementProperty = null;
            valueTypeInformation = this.model.typeInformation[this.vmContext.eType.index];
        }
        ValueClass valueClass = valueTypeInformation.valueClass;
        if (!this.vmContext.nilled && valueClass != null) {
            this.startComplexType(valueClass, false);
            if (valueClass.simpleContentProperty != null) {
                this.setupSimpleContent(valueClass.simpleContentProperty.propertyTypeInfo.valueType);
            }
        } else {
            this.setupSimpleContent(valueTypeInformation);
        }
    }

    public final void handleSkippedStartElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName) {
        if (this.skipDepth++ == 0) {
            if (this.currentSimpleType != null) {
                this.handleAttachment(qName, this.currentSimpleType.typeId);
                return;
            }
            ValueClass valueClass = this.currentStub.valueClass;
            if (valueClass != null) {
                if (valueClass.elementWildcardProperty != null) {
                    this.documentNode = new DocumentImpl();
                    this.documentNode.setStrictErrorChecking(false);
                    this.currentNode = this.createElementNode(this.documentNode, qName, this.isFragmentRoot);
                    this.documentNode.appendChild(this.currentNode);
                } else if (valueClass.simpleContentProperty != null) {
                    this.handleAttachment(qName, valueClass.simpleContentProperty.propertyTypeInfo.valueType.typeId);
                }
            }
        } else if (this.currentNode != null) {
            Element element = this.createElementNode(this.documentNode, qName, false);
            this.currentNode.appendChild(element);
            this.currentNode = element;
        }
    }

    public final void handleEndElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName) {
        if (!this.vmContext.nilled && !this.vmContext.currentElementHasSimpleContent()) {
            this.endComplexType();
        } else {
            if (!this.elementContentDeserialized) {
                this.handleSimpleContent(this.vmContext.nilled);
            }
            this.currentSimpleType = null;
            if (!this.vmContext.nilled && this.currentStub.valueClass != null && this.currentStub.valueClass.hasSimpleContent()) {
                this.endComplexType();
            }
        }
    }

    public final void handleSkippedEndElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName) {
        if (--this.skipDepth == 0) {
            if (this.currentNode != null) {
                this.currentStub.write((Element)this.currentNode);
                this.documentNode.setStrictErrorChecking(true);
                this.currentNode = null;
                this.documentNode = null;
            }
        } else if (this.currentNode != null) {
            this.currentNode = this.currentNode.getParentNode();
        }
    }

    public final void handleLeafElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName) {
        ValueTypeInformation valueTypeInformation;
        if (this.vmContext.eDecl != null) {
            this.currentPropertyId = this.vmContext.eDeclIndex;
            this.elementProperty = this.currentStub.valueClass.elementProperties[this.currentPropertyId];
            valueTypeInformation = this.vmContext.eDecl.type == this.vmContext.eType ? this.elementProperty.propertyTypeInfo.valueType : this.model.typeInformation[this.vmContext.eType.index];
        } else {
            this.currentPropertyId = this.currentStub.valueClass.elementWildcardProperty.propertyId;
            this.elementProperty = null;
            valueTypeInformation = this.model.typeInformation[this.vmContext.eType.index];
        }
        ValueClass valueClass = valueTypeInformation.valueClass;
        if (!this.vmContext.leafNilled && valueClass != null) {
            this.startComplexType(valueClass, true);
            if (valueClass.simpleContentProperty != null) {
                this.setupSimpleContent(valueClass.simpleContentProperty.propertyTypeInfo.valueType);
                if (!this.elementContentDeserialized) {
                    this.handleSimpleContent(this.vmContext.leafNilled);
                }
                this.currentSimpleType = null;
            }
            this.endComplexType();
        } else {
            this.setupSimpleContent(valueTypeInformation);
            if (!this.elementContentDeserialized) {
                this.handleSimpleContent(this.vmContext.leafNilled);
            }
            this.currentSimpleType = null;
        }
    }

    public final void handleSkippedLeafElementEvent(com.ibm.xml.xlxp2.scan.util.QName qName) {
        if (this.skipDepth == 0) {
            if (this.currentSimpleType != null) {
                this.handleAttachment(qName, this.currentSimpleType.typeId);
                return;
            }
            ValueClass valueClass = this.currentStub.valueClass;
            if (valueClass != null) {
                if (valueClass.elementWildcardProperty != null) {
                    this.documentNode = new DocumentImpl();
                    this.documentNode.setStrictErrorChecking(false);
                    Element element = this.createElementNode(this.documentNode, qName, this.isFragmentRoot);
                    this.documentNode.appendChild(element);
                    this.currentStub.write(element);
                    this.documentNode.setStrictErrorChecking(true);
                    this.documentNode = null;
                } else if (valueClass.simpleContentProperty != null) {
                    this.handleAttachment(qName, valueClass.simpleContentProperty.propertyTypeInfo.valueType.typeId);
                }
            }
        } else if (this.currentNode != null) {
            this.currentNode.appendChild(this.createElementNode(this.documentNode, qName, false));
        }
    }

    public final void handleSkippedCharacters(XMLString xMLString) {
        if (this.currentNode != null) {
            this.currentNode.appendChild(this.documentNode.createTextNode(xMLString.toString()));
        }
    }

    public final void handleSkippedCharacter(int n) {
        if (this.currentNode != null) {
            this.oneIntArray[0] = n;
            this.currentNode.appendChild(this.documentNode.createTextNode(new String(this.oneIntArray, 0, 1)));
        }
    }

    public final void handleMixedContent() {
        XMLString xMLString = this.vmContext.getElementString();
        if (xMLString.length > 0) {
            this.currentStub.write(this.getStringValue(xMLString));
        }
    }

    public final Element createElementNode(Document document, com.ibm.xml.xlxp2.scan.util.QName qName, boolean bl) {
        int n;
        Object object;
        int n2;
        VMContext vMContext = this.vmContext;
        Element element = document.createElementNS(qName.nsURI, qName.rawName);
        if (bl) {
            n2 = vMContext.totalMappingsCount() << 1;
            if (this.inScopeMappings == null || this.inScopeMappings.length < n2) {
                this.inScopeMappings = ArrayAllocator.newObjectArray(String.class, n2);
            }
            object = this.inScopeMappings;
            n = (vMContext.inScopeNamespaces((String[])object) << 1) - 2;
            for (int i = 0; i < n; ++i) {
                String string = object[i++];
                String string2 = object[i];
                if (string == "") {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
                stringBuilder.append("xmlns");
                stringBuilder.append(':');
                stringBuilder.append(string);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", stringBuilder.toString(), string2);
            }
        } else {
            n = vMContext.nsDeclCount();
            for (n2 = 0; n2 < n; ++n2) {
                object = vMContext.nsDeclQName(n2);
                String string = vMContext.nsDeclURI(n2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)object, string);
            }
        }
        n = vMContext.attributeCount();
        for (n2 = 0; n2 < n; ++n2) {
            object = vMContext.attributeName(n2);
            XMLString xMLString = vMContext.attributeValue(n2);
            element.setAttributeNS(object.nsURI, object.rawName, xMLString.toString());
        }
        return element;
    }

    private void handleAttachment(com.ibm.xml.xlxp2.scan.util.QName qName, int n) {
        switch (n) {
            case 17: {
                this.handleByteArrayAttachment(qName);
                break;
            }
            case 22: {
                this.handleImageAttachment(qName);
                break;
            }
            case 23: {
                this.handleDataHandlerAttachment(qName);
                break;
            }
            case 24: {
                this.handleSourceAttachment(qName);
            }
        }
    }

    private void handleByteArrayAttachment(com.ibm.xml.xlxp2.scan.util.QName qName) {
        byte[] byArray = this.getByteArrayAttachment(qName);
        if (byArray != null) {
            this.currentStub.write(this.currentPropertyId, byArray);
            this.elementContentDeserialized = true;
        }
    }

    private void handleImageAttachment(com.ibm.xml.xlxp2.scan.util.QName qName) {
        DataHandler dataHandler = this.getDataHandlerAttachment(qName);
        if (dataHandler != null) {
            try {
                Image image = this.getImageValue(dataHandler.getInputStream());
                this.currentStub.write(this.currentPropertyId, image);
                this.elementContentDeserialized = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleDataHandlerAttachment(com.ibm.xml.xlxp2.scan.util.QName qName) {
        DataHandler dataHandler = this.getDataHandlerAttachment(qName);
        if (dataHandler != null) {
            this.currentStub.write(this.currentPropertyId, dataHandler);
            this.elementContentDeserialized = true;
        }
    }

    private void handleSourceAttachment(com.ibm.xml.xlxp2.scan.util.QName qName) {
        byte[] byArray = this.getByteArrayAttachment(qName);
        if (byArray != null) {
            Source source = this.getSourceValue(byArray);
            this.currentStub.write(this.currentPropertyId, source);
            this.elementContentDeserialized = true;
        }
    }

    private DataHandler getDataHandlerAttachment(com.ibm.xml.xlxp2.scan.util.QName qName) {
        AttachmentUnmarshaller attachmentUnmarshaller = this.unmarshaller.getAttachmentUnmarshaller();
        if (XOP_INCLUDE_LOCAL_NAME == qName.localName && XOP_INCLUDE_NS_URI == qName.nsURI && attachmentUnmarshaller != null && attachmentUnmarshaller.isXOPPackage()) {
            VMContext vMContext = this.vmContext;
            int n = vMContext.attributeCount();
            for (int i = 0; i < n; ++i) {
                com.ibm.xml.xlxp2.scan.util.QName qName2 = vMContext.attributeName(i);
                if (HREF_LOCAL_NAME != qName2.localName || "" != qName2.nsURI) continue;
                XMLString xMLString = vMContext.attributeValue(i);
                return attachmentUnmarshaller.getAttachmentAsDataHandler(this.getStringValue(xMLString));
            }
        }
        return null;
    }

    private byte[] getByteArrayAttachment(com.ibm.xml.xlxp2.scan.util.QName qName) {
        AttachmentUnmarshaller attachmentUnmarshaller = this.unmarshaller.getAttachmentUnmarshaller();
        if (XOP_INCLUDE_LOCAL_NAME == qName.localName && XOP_INCLUDE_NS_URI == qName.nsURI && attachmentUnmarshaller != null && attachmentUnmarshaller.isXOPPackage()) {
            VMContext vMContext = this.vmContext;
            int n = vMContext.attributeCount();
            for (int i = 0; i < n; ++i) {
                com.ibm.xml.xlxp2.scan.util.QName qName2 = vMContext.attributeName(i);
                if (HREF_LOCAL_NAME != qName2.localName || "" != qName2.nsURI) continue;
                XMLString xMLString = vMContext.attributeValue(i);
                return attachmentUnmarshaller.getAttachmentAsByteArray(this.getStringValue(xMLString));
            }
        }
        return null;
    }

    private final String getExpectedElementsAtRoot() {
        ElementDeclaration[] elementDeclarationArray = this.model.elementDeclarations;
        StringBuilder stringBuilder = new StringBuilder();
        int n = elementDeclarationArray != null ? elementDeclarationArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(elementDeclarationArray[i].elementName.qName.toString());
        }
        return stringBuilder.toString();
    }

    public final boolean currentElementContainsAttributes() {
        return this.vmContext.attributeCount() > 0;
    }

    public final void startComplexType(ValueClass valueClass, boolean bl) {
        int n = valueClass.classId;
        DeserializationStub deserializationStub = this.freeStubs[n];
        if (deserializationStub != null) {
            this.freeStubs[n] = deserializationStub.next;
            deserializationStub.next = null;
        } else {
            deserializationStub = this.stubFactory.createStub(valueClass, this.model);
            deserializationStub.setContext(this);
        }
        deserializationStub.setParent(this.currentStub, this.currentPropertyId);
        this.currentStub = deserializationStub;
        this.currentElementNilled = bl ? this.vmContext.leafNilled : this.vmContext.nilled;
        deserializationStub.start();
    }

    public final void endComplexType() {
        DeserializationStub deserializationStub = this.currentStub;
        int n = deserializationStub.typeId;
        deserializationStub.end();
        deserializationStub.next = this.freeStubs[n];
        this.freeStubs[n] = deserializationStub;
        this.currentStub = deserializationStub.getParent();
    }

    public final Object endComplexType2() {
        DeserializationStub deserializationStub = this.currentStub;
        int n = deserializationStub.typeId;
        Object object = deserializationStub.end2();
        deserializationStub.next = this.freeStubs[n];
        this.freeStubs[n] = deserializationStub;
        this.currentStub = deserializationStub.getParent();
        return object;
    }

    final void setupSimpleContent(ValueTypeInformation valueTypeInformation) {
        this.currentSimpleType = valueTypeInformation;
        this.elementContentDeserialized = false;
    }

    private final void handleEnumStringAsToken() {
        if (this.currentSimpleType == null || this.currentSimpleType.enumClass == null) {
            return;
        }
        try {
            int n = this.currentSimpleType.enumClass.getPrimitiveEnumConstantValueTypeId();
            if (n == 0) {
                this.currentStub.write(this.currentPropertyId, this.getTokenValue(this.vmContext.getElementString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final void handleSimpleContent(boolean bl) {
        block3: {
            try {
                if (bl) {
                    this.currentStub.write(this.currentPropertyId, (Object)null);
                    return;
                }
                this.currentStub.write(this.currentPropertyId, this.vmContext.getElementString());
            }
            catch (Exception exception) {
                if (!(exception instanceof IllegalArgumentException)) break block3;
                this.handleEnumStringAsToken();
            }
        }
    }

    public final void writeSimpleContent(int n, XMLString xMLString) {
        ValueTypeInformation valueTypeInformation = this.currentSimpleType;
        EnumClass enumClass = valueTypeInformation.enumClass;
        int n2 = enumClass != null ? enumClass.getPrimitiveEnumConstantValueTypeId() : valueTypeInformation.typeId;
        switch (n2) {
            case 0: {
                this.currentStub.write(n, this.getStringValue(xMLString));
                break;
            }
            case 1: {
                this.currentStub.write(n, this.getNormalizedStringValue(xMLString));
                break;
            }
            case 2: {
                this.currentStub.write(n, this.getTokenValue(xMLString));
                break;
            }
            case 3: {
                Boolean bl = this.getBooleanObjectValue(xMLString);
                if (valueTypeInformation.javaType == Boolean.class) {
                    this.currentStub.write(n, bl);
                    break;
                }
                if (bl == null) break;
                this.currentStub.write(n, bl);
                break;
            }
            case 4: {
                this.currentStub.write(n, this.getBigDecimalValue(xMLString));
                break;
            }
            case 5: {
                this.currentStub.write(n, this.getBigIntegerValue(xMLString));
                break;
            }
            case 6: {
                if (valueTypeInformation.javaType == Long.class) {
                    this.currentStub.write(n, this.getLongObjectValue(xMLString));
                    break;
                }
                long l = this.getLongValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, l);
                break;
            }
            case 7: {
                if (valueTypeInformation.javaType == Integer.class) {
                    this.currentStub.write(n, this.getIntegerObjectValue(xMLString));
                    break;
                }
                int n3 = this.getIntValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, n3);
                break;
            }
            case 8: {
                if (valueTypeInformation.javaType == Short.class) {
                    this.currentStub.write(n, this.getShortObjectValue(xMLString));
                    break;
                }
                short s = this.getShortValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, s);
                break;
            }
            case 9: {
                if (valueTypeInformation.javaType == Byte.class) {
                    this.currentStub.write(n, this.getByteObjectValue(xMLString));
                    break;
                }
                byte by = this.getByteValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, by);
                break;
            }
            case 10: {
                if (valueTypeInformation.javaType == Float.class) {
                    this.currentStub.write(n, this.getFloatObjectValue(xMLString));
                    break;
                }
                float f = this.getFloatValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, f);
                break;
            }
            case 11: {
                if (valueTypeInformation.javaType == Double.class) {
                    this.currentStub.write(n, this.getDoubleObjectValue(xMLString));
                    break;
                }
                double d = this.getDoubleValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, d);
                break;
            }
            case 12: {
                this.currentStub.write(n, this.getDurationValue(xMLString));
                break;
            }
            case 13: {
                this.currentStub.write(n, this.getCalendarValue(xMLString));
                break;
            }
            case 14: {
                this.currentStub.write(n, this.getDateValue(xMLString));
                break;
            }
            case 15: {
                this.currentStub.write(n, this.getXMLGregorianCalendarValue(xMLString));
                break;
            }
            case 16: {
                this.currentStub.write(n, this.getHexBinaryValue(xMLString));
                break;
            }
            case 17: {
                this.currentStub.write(n, this.getBase64BinaryValue(xMLString));
                break;
            }
            case 18: {
                this.currentStub.write(n, this.getQNameValue(xMLString));
                break;
            }
            case 21: {
                this.currentStub.write(n, this.getURIValue(xMLString));
                break;
            }
            case 22: {
                this.currentStub.write(n, this.getImageValue(xMLString));
                break;
            }
            case 23: {
                this.currentStub.write(n, this.getDataHandlerValue(xMLString));
                break;
            }
            case 24: {
                this.currentStub.write(n, this.getSourceValue(xMLString));
                break;
            }
            case 25: {
                this.currentStub.write(n, this.getUUIDValue(xMLString));
                break;
            }
            case 26: {
                if (valueTypeInformation.javaType == Character.class) {
                    this.currentStub.write(n, this.getCharObjectValue(xMLString));
                    break;
                }
                char c = this.getCharValue(xMLString);
                if (this.oneIntArray[0] != 0) break;
                this.currentStub.write(n, c);
                break;
            }
            case 27: {
                this.currentStub.write(n, this.getGregorianCalendarValue(xMLString));
                break;
            }
            case 28: {
                this.currentStub.write(n, this.getFileValue(xMLString));
                break;
            }
            case 29: {
                this.currentStub.write(n, this.getURLValue(xMLString));
            }
        }
    }

    private static void ensureCapacity(XList xList, int n) {
        if (xList.value == null) {
            xList.value = ArrayAllocator.newObjectArray(2);
        } else if (n >= xList.value.length) {
            xList.value = ArrayAllocator.resizeObjectArray(xList.value, xList.value.length << 1);
        }
    }

    public final String getStringValue(XMLString xMLString) {
        return xMLString.toString();
    }

    public final XList getStringListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getStringValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final String getNormalizedStringValue(XMLString xMLString) {
        return xMLString.toNormalizedString();
    }

    public final XList getNormalizedStringListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getNormalizedStringValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final String getTokenValue(XMLString xMLString) {
        return COLLAPSED_STRING_ADAPTER.unmarshal(this.getStringValue(xMLString));
    }

    public final XList getTokenListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getTokenValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final boolean getBooleanValue(XMLString xMLString) {
        Boolean bl = this.getBooleanObjectValue(xMLString);
        return bl != null ? bl : false;
    }

    public final Boolean getBooleanObjectValue(XMLString xMLString) {
        return BooleanDV.parseBoolean(xMLString);
    }

    public final XList getBooleanObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getBooleanObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final BigDecimal getBigDecimalValue(XMLString xMLString) {
        XDecimal2 xDecimal2 = DecimalDV.parseDecimal(xMLString, this.fXDecimal2);
        if (xDecimal2 != null) {
            if (xDecimal2.isLong) {
                return BigDecimal.valueOf(xDecimal2.longValue, xDecimal2.scale);
            }
            return new BigDecimal(xDecimal2.decimalValue.toString());
        }
        return null;
    }

    public final XList getBigDecimalListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getBigDecimalValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final BigInteger getBigIntegerValue(XMLString xMLString) {
        XDecimal2 xDecimal2 = IntegerDV.parseInteger(xMLString, this.fXDecimal2);
        if (xDecimal2 != null) {
            if (xDecimal2.isLong) {
                return BigInteger.valueOf(xDecimal2.longValue);
            }
            return new BigInteger(xDecimal2.decimalValue.toString());
        }
        return null;
    }

    public final XList getBigIntegerListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getBigIntegerValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final long getLongValue(XMLString xMLString) {
        return XSIntegerUtil.parseLong(xMLString, this.oneIntArray);
    }

    public final Long getLongObjectValue(XMLString xMLString) {
        long l = this.getLongValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return l;
        }
        return null;
    }

    public final XList getLongObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getLongObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final int getIntValue(XMLString xMLString) {
        return XSIntegerUtil.parseInt(xMLString, this.oneIntArray);
    }

    public final Integer getIntegerObjectValue(XMLString xMLString) {
        int n = this.getIntValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return n;
        }
        return null;
    }

    public final XList getIntegerObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getIntegerObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final short getShortValue(XMLString xMLString) {
        return XSIntegerUtil.parseShort(xMLString, this.oneIntArray);
    }

    public final Short getShortObjectValue(XMLString xMLString) {
        short s = this.getShortValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return s;
        }
        return null;
    }

    public final XList getShortObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getShortObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final byte getByteValue(XMLString xMLString) {
        return XSIntegerUtil.parseByte(xMLString, this.oneIntArray);
    }

    public final Byte getByteObjectValue(XMLString xMLString) {
        byte by = this.getByteValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return by;
        }
        return null;
    }

    public final XList getByteObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getByteObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final float getFloatValue(XMLString xMLString) {
        return FloatDV.parse(xMLString, this.oneIntArray);
    }

    public final Float getFloatObjectValue(XMLString xMLString) {
        float f = this.getFloatValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return Float.valueOf(f);
        }
        return null;
    }

    public final XList getFloatObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getFloatObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final double getDoubleValue(XMLString xMLString) {
        return DoubleDV.parse(xMLString, this.oneIntArray);
    }

    public final Double getDoubleObjectValue(XMLString xMLString) {
        double d = this.getDoubleValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return d;
        }
        return null;
    }

    public final XList getDoubleObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getDoubleObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final char getCharValue(XMLString xMLString) {
        return (char)XSIntegerUtil.parseUShort(xMLString, this.oneIntArray);
    }

    public final Character getCharObjectValue(XMLString xMLString) {
        char c = this.getCharValue(xMLString);
        if (this.oneIntArray[0] == 0) {
            return Character.valueOf(c);
        }
        return null;
    }

    public final XList getCharObjectListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getCharObjectValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final Duration getDurationValue(XMLString xMLString) {
        try {
            return this.datatypeFactory.newDuration(this.getTokenValue(xMLString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final XList getDurationListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getDurationValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final GregorianCalendar getGregorianCalendarValue(XMLString xMLString) {
        XMLGregorianCalendar xMLGregorianCalendar = this.getXMLGregorianCalendarValue(xMLString);
        return xMLGregorianCalendar != null ? xMLGregorianCalendar.toGregorianCalendar() : null;
    }

    public final XList getGregorianCalendarListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getGregorianCalendarValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final Calendar getCalendarValue(XMLString xMLString) {
        return this.getGregorianCalendarValue(xMLString);
    }

    public final XList getCalendarListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getCalendarValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final Date getDateValue(XMLString xMLString) {
        GregorianCalendar gregorianCalendar = this.getGregorianCalendarValue(xMLString);
        return gregorianCalendar != null ? gregorianCalendar.getTime() : null;
    }

    public final XList getDateListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getDateValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final XMLGregorianCalendar getXMLGregorianCalendarValue(XMLString xMLString) {
        try {
            return this.datatypeFactory.newXMLGregorianCalendar(this.getTokenValue(xMLString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final XList getXMLGregorianCalendarListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getXMLGregorianCalendarValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final byte[] getHexBinaryValue(XMLString xMLString) {
        XBinary xBinary = XSHexBinaryUtil.parseHexBinary(xMLString);
        if (xBinary != null) {
            byte[] byArray = xBinary.value;
            if (xBinary.length < byArray.length) {
                byte[] byArray2 = ArrayAllocator.newByteArray(xBinary.length);
                System.arraycopy(byArray, 0, byArray2, 0, xBinary.length);
                return byArray2;
            }
            return byArray;
        }
        return null;
    }

    public final XList getHexBinaryListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getHexBinaryValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final byte[] getBase64BinaryValue(XMLString xMLString) {
        XBinary xBinary = XSBase64BinaryUtil.parseBase64Binary(xMLString);
        if (xBinary != null) {
            byte[] byArray = xBinary.value;
            if (xBinary.length < byArray.length) {
                byte[] byArray2 = ArrayAllocator.newByteArray(xBinary.length);
                System.arraycopy(byArray, 0, byArray2, 0, xBinary.length);
                return byArray2;
            }
            return byArray;
        }
        return null;
    }

    public final XList getBase64BinaryListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getBase64BinaryValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final QName getQNameValue(XMLString xMLString) {
        return this.jaxpQNameProducer.getQNameValue(xMLString);
    }

    public final XList getQNameListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getQNameValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final URI getURIValue(XMLString xMLString) {
        try {
            return new URI(this.getStringValue(xMLString));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public final XList getURIListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getURIValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final Image getImageValue(XMLString xMLString) {
        byte[] byArray = this.getBase64BinaryValue(xMLString);
        if (byArray != null) {
            return this.getImageValue(new ByteArrayInputStream(byArray));
        }
        return null;
    }

    private final Image getImageValue(final InputStream inputStream) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Image>(){

                @Override
                public Image run() throws Exception {
                    return ImageIO.read(inputStream);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public final XList getImageListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getImageValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final DataHandler getDataHandlerValue(XMLString xMLString) {
        byte[] byArray = this.getBase64BinaryValue(xMLString);
        if (byArray != null) {
            return new DataHandler((DataSource)new BinaryDataSource(byArray));
        }
        return null;
    }

    public final XList getDataHandlerListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getDataHandlerValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final DataHandler getAttachmentValue(XMLString xMLString) {
        AttachmentUnmarshaller attachmentUnmarshaller = this.unmarshaller.getAttachmentUnmarshaller();
        if (attachmentUnmarshaller != null) {
            return attachmentUnmarshaller.getAttachmentAsDataHandler(this.getStringValue(xMLString));
        }
        return null;
    }

    public final XList getAttachmentListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getAttachmentValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final Source getSourceValue(XMLString xMLString) {
        byte[] byArray = this.getBase64BinaryValue(xMLString);
        if (byArray != null) {
            return this.getSourceValue(byArray);
        }
        return null;
    }

    private final Source getSourceValue(byte[] byArray) {
        return new BinaryStreamSource(byArray);
    }

    public final XList getSourceListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getSourceValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final UUID getUUIDValue(XMLString xMLString) {
        try {
            return UUID.fromString(this.getStringValue(xMLString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final XList getUUIDListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getUUIDValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final File getFileValue(XMLString xMLString) {
        return new File(this.getTokenValue(xMLString));
    }

    public final XList getFileListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getFileValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final URL getURLValue(XMLString xMLString) {
        try {
            return new URL(this.getStringValue(xMLString));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final XList getURLListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getURLValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final String getIDValue(XMLString xMLString) {
        String string = this.getTokenValue(xMLString);
        this.idMap.put(string, this.currentStub.o);
        return string;
    }

    public final XList getIDListValue(XMLString xMLString) {
        this.tokenizer.setString(xMLString);
        int n = 0;
        while (this.tokenizer.next(this.token)) {
            DeserializationContext.ensureCapacity(this.list, n);
            this.list.value[n++] = this.getIDValue(this.token);
        }
        this.list.length = n;
        return this.list;
    }

    public final void processIDREFValue(XMLString xMLString, int n) {
        String string = this.getTokenValue(xMLString);
        this.idrefList.add(new IDREFValue(string, this.currentStub.o, n, this.currentStub));
    }

    public final void processIDREFListValue(XMLString xMLString, int n) {
        this.tokenizer.setString(xMLString);
        while (this.tokenizer.next(this.token)) {
            this.processIDREFValue(this.token, n);
        }
    }

    public final void reset(boolean bl) {
        this.skipDepth = 0;
        this.elementContentDeserialized = false;
        this.currentSimpleType = null;
        this.idMap.clear();
        this.idrefList.clear();
        this.documentNode = null;
        this.currentNode = null;
        this.isFragmentRoot = true;
        this.declaredType = OBJECT_CLASS;
        if (!bl) {
            for (int i = 0; i < this.freeStubs.length; ++i) {
                this.freeStubs[i] = null;
            }
            this.currentStub = null;
            this.rootElementDecl = null;
            this.elementProperty = null;
        }
    }

    public final XBoolean getXBoolean() {
        return this.fXBoolean;
    }

    public final XInt getXInt() {
        return this.fXInt;
    }

    public final XLong getXLong() {
        return this.fXLong;
    }

    public final XDecimal getXDecimal() {
        return this.fXDecimal;
    }

    public final XDecimal2 getXDecimal2() {
        return this.fXDecimal2;
    }

    public final XDateTime2 getXDateTime2() {
        this.fXDateTime2.clear();
        return this.fXDateTime2;
    }

    public final boolean[] getNormalizedArray() {
        return this.normalized;
    }

    public final void unregisterBuffers() {
        if (this.fXDecimal.rawData != null && this.fXDecimal.rawData.firstBuffer != null) {
            this.fXDecimal.rawData.unregister();
        }
        if (this.jaxpQNameProducer.fTemp.firstBuffer != null) {
            this.jaxpQNameProducer.fTemp.unregister();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class BinaryStreamSource
    extends StreamSource {
        private final byte[] bytes;

        public BinaryStreamSource(byte[] byArray) {
            this.bytes = byArray;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public void setInputStream(InputStream inputStream) {
            throw new UnsupportedOperationException();
        }

        public void setReader(Reader reader) {
            throw new UnsupportedOperationException();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class BinaryDataSource
    implements DataSource {
        private final byte[] bytes;

        public BinaryDataSource(byte[] byArray) {
            this.bytes = byArray;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class JAXPQNameProducer {
        final XMLString fTemp = new XMLString();

        public QName getQNameValue(XMLString xMLString) {
            return this.parseQName(xMLString, this.fTemp);
        }

        public QName getQNameValue(com.ibm.xml.xlxp2.scan.util.QName qName) {
            return new QName(qName.nsURI, qName.localName, qName.prefix);
        }

        private QName parseQName(XMLString xMLString, XMLString xMLString2) {
            if (xMLString.length == 0) {
                return null;
            }
            if (xMLString.bytes != null) {
                return this.parseQNameUnbuffered(xMLString, xMLString2);
            }
            return this.parseQNameBuffered(xMLString, xMLString2);
        }

        private QName parseQNameUnbuffered(XMLString xMLString, XMLString xMLString2) {
            int n = xMLString.startOffset;
            int n2 = xMLString.endOffset;
            byte by = 0;
            byte[] byArray = null;
            int[] nArray = null;
            xMLString2.setValues(xMLString);
            String string = "";
            xMLString2.startOffset = n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2);
            if (n < n2) {
                by = xMLString.bytes[n];
                if (!XMLCharacterProperties.nameStartChar10(by)) {
                    return null;
                }
                ++n;
                while (n < n2) {
                    by = xMLString.bytes[n];
                    if (by >= 0) {
                        if (by == 58) {
                            if (string != "" || n + 1 == n2 || xMLString.startOffset == n) {
                                return null;
                            }
                            xMLString2.endOffset = n;
                            xMLString2.length = xMLString2.endOffset - xMLString.startOffset;
                            string = DeserializationContext.this.getSymbol(xMLString2);
                            xMLString2.startOffset = n + 1;
                            xMLString2.length = n2 - (n + 1);
                            xMLString2.endOffset = n2;
                        } else if (!XMLCharacterProperties.nameChar10(by)) {
                            xMLString2.endOffset = n;
                            if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) >= n2) break;
                            return null;
                        }
                        ++n;
                        continue;
                    }
                    if (byArray == null) {
                        byArray = ArrayAllocator.newByteArray(4);
                        nArray = ArrayAllocator.newIntArray(2);
                    }
                    byArray[0] = by;
                    int n3 = 1;
                    while (n3 < 4 && n + n3 < n2) {
                        byArray[n3++] = xMLString.bytes[n + n3 - 1];
                    }
                    UTF8Support.decodeCharacter(byArray, 0, n3, nArray);
                    if (!XMLCharacterProperties.nameChar10(nArray[0])) {
                        return null;
                    }
                    n += nArray[1];
                }
            }
            String string2 = DeserializationContext.this.getSymbol(xMLString2);
            String string3 = DeserializationContext.this.prefixMapping(string);
            if (string3 == null) {
                if (string != "") {
                    return null;
                }
                string3 = "";
            }
            return new QName(string3, string2, string);
        }

        /*
         * Enabled aggressive block sorting
         */
        private QName parseQNameBuffered(XMLString xMLString, XMLString xMLString2) {
            String string;
            String string2;
            DataBuffer dataBuffer = xMLString.firstBuffer;
            DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
            int n = xMLString.startOffset;
            int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            byte by = 0;
            byte[] byArray = null;
            int[] nArray = null;
            xMLString2.setValues(xMLString);
            String string3 = "";
            by = dataBuffer.bytes[n];
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
                xMLString2.setValues(dataBuffer, dataBuffer2, n, xMLString.endOffset);
            }
            if (!XMLCharacterProperties.nameStartChar10(by)) {
                return null;
            }
            ++n;
            while (true) {
                block17: {
                    block23: {
                        block21: {
                            block22: {
                                block18: {
                                    block20: {
                                        block19: {
                                            if (n >= n2) break block17;
                                            by = dataBuffer.bytes[n];
                                            if (by < 0) break block18;
                                            if (by != 58) break block19;
                                            if (string3 != "" || n + 1 == n2 && dataBuffer == dataBuffer2 || xMLString.startOffset == n && dataBuffer == xMLString.firstBuffer) {
                                                return null;
                                            }
                                            xMLString2.setEndPos(dataBuffer, n);
                                            string3 = DeserializationContext.this.getSymbol(xMLString2);
                                            xMLString2.setValues(dataBuffer, dataBuffer2, n + 1, xMLString.endOffset);
                                            break block20;
                                        }
                                        if (XMLCharacterProperties.nameChar10(by)) break block20;
                                        xMLString2.setEndPos(dataBuffer, n);
                                        if (by > 32) break block21;
                                        break block22;
                                    }
                                    ++n;
                                    continue;
                                }
                                if (byArray != null) break block23;
                                byArray = ArrayAllocator.newByteArray(4);
                                nArray = ArrayAllocator.newIntArray(2);
                                break block23;
                            }
                            while (true) {
                                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                                    by = dataBuffer.bytes[n];
                                    continue;
                                }
                                if (n != n2 || dataBuffer == dataBuffer2) break;
                                dataBuffer = dataBuffer.next;
                                n = dataBuffer.startOffset;
                                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                                by = dataBuffer.bytes[n];
                            }
                        }
                        if (n < n2 || dataBuffer != dataBuffer2) {
                            return null;
                        }
                        break block17;
                    }
                    byArray[0] = by;
                    int n3 = 1;
                    while (true) {
                        if (n3 < 4 && n + n3 < n2) {
                            byArray[n3++] = dataBuffer.bytes[n + n3 - 1];
                            continue;
                        }
                        if (dataBuffer == dataBuffer2) {
                            UTF8Support.decodeCharacter(byArray, 0, n3, nArray);
                            if (!XMLCharacterProperties.nameChar10(nArray[0])) {
                                return null;
                            }
                            break;
                        }
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - n3;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    if ((n += nArray[1]) >= 0) continue;
                    DataBuffer dataBuffer3 = xMLString.firstBuffer;
                    while (dataBuffer3.next != dataBuffer) {
                        dataBuffer3 = dataBuffer3.next;
                    }
                    dataBuffer = dataBuffer3;
                    n = dataBuffer.endOffset + n;
                    n2 = dataBuffer.endOffset;
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    string2 = DeserializationContext.this.getSymbol(xMLString2);
                    string = DeserializationContext.this.prefixMapping(string3);
                    if (string != null) return new QName(string, string2, string3);
                    break;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (string3 != "") {
                return null;
            }
            string = "";
            return new QName(string, string2, string3);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class XBoolean {
        public boolean value;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class XDateTime2 {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;
        public int milliseconds;
        public int timezone;

        void clear() {
            this.year = Integer.MIN_VALUE;
            this.month = Integer.MIN_VALUE;
            this.day = Integer.MIN_VALUE;
            this.hour = Integer.MIN_VALUE;
            this.minute = Integer.MIN_VALUE;
            this.second = Integer.MIN_VALUE;
            this.milliseconds = Integer.MIN_VALUE;
            this.timezone = Integer.MIN_VALUE;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class XDecimal2 {
        public final XDecimal decimalValue;
        public long longValue;
        public int scale;
        public boolean isLong;

        public XDecimal2(XDecimal xDecimal) {
            this.decimalValue = xDecimal;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class IDREFValue {
        final String value;
        final Object target;
        final int propertyId;
        final DeserializationStub stub;

        public IDREFValue(String string, Object object, int n, DeserializationStub deserializationStub) {
            this.value = string;
            this.target = object;
            this.propertyId = n;
            this.stub = deserializationStub;
        }
    }
}

