/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.XMLStreamWriterBase;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
class SAXStreamWriterImpl
extends XMLStreamWriterBase {
    private static final char[] fgEmptyCharArray = ArrayAllocator.checkCharArray(new char[0]);
    protected ContentHandler fCHandler;
    protected LexicalHandler fLHandler;
    protected String[] fCurrentElementArray;
    protected int fCurrentElementDepth;
    protected AttributesImpl fAttributes;
    private HashMap<String, String> fStoredNamespaceDecls = new HashMap();

    public SAXStreamWriterImpl(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean bl) throws XMLStreamException {
        this();
        this.setHandlers(contentHandler, lexicalHandler, bl);
    }

    protected SAXStreamWriterImpl() throws XMLStreamException {
        this.fAttributes = new AttributesImpl();
        this.fCurrentElementArray = ArrayAllocator.newStringArray(24);
    }

    public void setHandlers(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean bl) {
        this.fCHandler = contentHandler;
        this.fLHandler = lexicalHandler;
        this.reset(bl);
    }

    public void setHandlersNoReset(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.fCHandler = contentHandler;
        this.fLHandler = lexicalHandler;
    }

    private void pushElementContext(String string, String string2, String string3) {
        int n = this.fCurrentElementDepth * 3;
        if (n == this.fCurrentElementArray.length) {
            this.fCurrentElementArray = ArrayAllocator.resizeStringArray(this.fCurrentElementArray, n << 1);
        }
        this.fCurrentElementArray[n] = string;
        this.fCurrentElementArray[n + 1] = string2;
        this.fCurrentElementArray[n + 2] = string3;
        ++this.fCurrentElementDepth;
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        this.fCurrentElementDepth = 0;
        this.fStoredNamespaceDecls.clear();
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            if (this.fCHandler != null) {
                this.fCHandler.startDocument();
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument();
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.writeStartDocument();
    }

    protected void handleStartElement(String string, String string2, String string3) throws XMLStreamException {
        String string4 = string == "" ? string2 : string + ":" + string2;
        this.pushElementContext(string3, string2, string4);
    }

    protected void finishStartElement() throws XMLStreamException {
        try {
            if (this.fCHandler != null) {
                String string;
                String string22;
                for (String string22 : this.fStoredNamespaceDecls.keySet()) {
                    string = this.fStoredNamespaceDecls.get(string22);
                    this.fCHandler.startPrefixMapping(string22, string);
                }
                this.fStoredNamespaceDecls.clear();
                int n = this.fCurrentElementDepth * 3;
                string22 = this.fCurrentElementArray[n - 1];
                string = this.fCurrentElementArray[n - 2];
                String string3 = this.fCurrentElementArray[n - 3];
                this.fCHandler.startElement(string3, string, string22, this.fAttributes);
            }
            this.fAttributes.clear();
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    protected void handleAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        String string5 = string.equals("") ? string3 : string + ":" + string3;
        this.fAttributes.addAttribute(string2, string3, string5, "CDATA", string4);
    }

    protected void handleNamespace(String string, String string2) throws XMLStreamException {
        this.fStoredNamespaceDecls.put(string, string2);
    }

    protected boolean atRootContext() {
        return this.fCurrentElementDepth == 0;
    }

    protected void handleEndElement() throws XMLStreamException {
        if (this.atRootContext()) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 39));
        }
        try {
            if (this.fCHandler != null) {
                int n = this.fCurrentElementDepth * 3;
                String string = this.fCurrentElementArray[n - 1];
                String string2 = this.fCurrentElementArray[n - 2];
                String string3 = this.fCurrentElementArray[n - 3];
                this.fCHandler.endElement(string3, string2, string);
                for (int i = this.fNamespaceContext.fMappingSize; i > this.fNamespaceContext.fScopes[this.fNamespaceContext.fScope]; i -= 2) {
                    this.fCHandler.endPrefixMapping(this.fNamespaceContext.fMapping[i - 2]);
                }
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
        --this.fCurrentElementDepth;
    }

    public void writeEndDocument() throws XMLStreamException {
        super.writeEndDocument();
        try {
            if (this.fCHandler != null) {
                this.fCHandler.endDocument();
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void close() throws XMLStreamException {
        super.close();
        this.fCHandler = null;
        this.fLHandler = null;
        this.fCurrentElementDepth = 0;
        this.fAttributes.clear();
        this.fPoolableHelper.returnToPool();
    }

    public void writeComment(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (this.fLHandler != null) {
                if (string != null) {
                    this.fLHandler.comment(string.toCharArray(), 0, string.length());
                } else {
                    this.fLHandler.comment(fgEmptyCharArray, 0, 0);
                }
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 49));
        }
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 50));
        }
        try {
            if (this.fCHandler != null) {
                this.fCHandler.processingInstruction(string, string2);
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 48));
        }
        try {
            if (this.fLHandler != null) {
                this.fLHandler.startCDATA();
            }
            if (this.fCHandler != null) {
                this.fCHandler.characters(string.toCharArray(), 0, string.length());
            }
            if (this.fLHandler != null) {
                this.fLHandler.endCDATA();
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        try {
            if (this.fLHandler != null) {
                super.parseDTD(string);
                if (this.fDTDRoot != null) {
                    this.fLHandler.startDTD(this.fDTDRoot, this.fDTDPubId, this.fDTDSysId);
                    this.fLHandler.endDTD();
                }
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (this.fLHandler != null) {
                this.fLHandler.startEntity(string);
            }
            if (this.fLHandler != null) {
                this.fLHandler.endEntity(string);
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.writeCharacters(string.toCharArray(), 0, string.length());
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            if (this.fCHandler != null) {
                this.fCHandler.characters(cArray, n, n2);
            }
        }
        catch (SAXException sAXException) {
            StAXMessageProvider.throwXMLStreamException(sAXException);
        }
    }
}

