/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigUtil;
import com.ibm.ws.config.xml.internal.ConfigVariable;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigVariableRegistry
implements VariableRegistry {
    private static final TraceComponent tc = Tr.register(ConfigVariableRegistry.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String UNIQUE = "UNIQUE_";
    public static final String IN_USE = "WLP_VAR_IN_USE";
    private final VariableRegistry registry;
    private final File variableCacheFile;
    private Map<String, ConfigVariable> configVariables;
    private Map<String, Object> variableCache;
    private Map<String, Object> defaultVariableCache;
    static final long serialVersionUID = -1196293758344540930L;

    public ConfigVariableRegistry(VariableRegistry registry) {
        this(registry, null);
    }

    public ConfigVariableRegistry(VariableRegistry registry, File variableCacheFile) {
        this.registry = registry;
        this.configVariables = Collections.emptyMap();
        this.variableCacheFile = variableCacheFile;
        if (variableCacheFile != null) {
            this.loadVariableCache();
        }
        if (this.variableCache == null) {
            this.variableCache = new HashMap<String, Object>();
        }
        if (this.defaultVariableCache == null) {
            this.defaultVariableCache = new HashMap<String, Object>();
        }
    }

    public void updateSystemVariables(Map<String, ConfigVariable> newVariables) {
        for (String string : this.configVariables.keySet()) {
            if (newVariables.containsKey(string)) continue;
            this.registry.removeVariable(string);
        }
        for (Map.Entry entry : newVariables.entrySet()) {
            String variableName = (String)entry.getKey();
            String variableValue = ((ConfigVariable)entry.getValue()).getValue();
            this.registry.replaceVariable(variableName, variableValue);
        }
        this.configVariables = newVariables;
    }

    public synchronized void updateVariableCache(Map<String, Object> variables) {
        boolean dirty = false;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            Object variableValue;
            String variableName = entry.getKey();
            if (this.configVariables.containsKey(variableName) || this.isVariableCached(variableName, variableValue = entry.getValue())) continue;
            this.variableCache.put(variableName, variableValue);
            dirty = true;
        }
        if (dirty) {
            this.saveVariableCache();
        }
    }

    private boolean isVariableCached(String variableName, Object variableValue) {
        if (this.variableCache.containsKey(variableName)) {
            Object cachedVariableValue = this.variableCache.get(variableName);
            return ConfigVariableRegistry.isEqual(cachedVariableValue, variableValue);
        }
        return false;
    }

    private static boolean isEqual(Object oldVariableValue, Object newVariableValue) {
        if (oldVariableValue == null) {
            return newVariableValue == null;
        }
        if (newVariableValue == null) {
            return false;
        }
        return oldVariableValue.equals(newVariableValue);
    }

    public synchronized boolean variablesChanged() {
        for (Map.Entry<String, Object> entry : this.variableCache.entrySet()) {
            String variableName = entry.getKey();
            Object oldVariableValue = entry.getValue();
            Object newVariableValue = this.lookupVariable(variableName);
            if (newVariableValue == null) {
                newVariableValue = this.defaultVariableCache.get(variableName);
            }
            if (ConfigVariableRegistry.isEqual(oldVariableValue, newVariableValue)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Variable " + variableName + " has changed. Old value: " + oldVariableValue + " New value: " + newVariableValue), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public synchronized void clearVariableCache() {
        this.variableCache.clear();
        this.defaultVariableCache.clear();
    }

    public String lookupVariable(String variableName) {
        String resolvedVar;
        String varReference = "${" + variableName + "}";
        return varReference.equalsIgnoreCase(resolvedVar = this.registry.resolveRawString(varReference)) ? null : resolvedVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    private synchronized void loadVariableCache() {
        block6: {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(this.variableCacheFile);
                ois = new ObjectInputStream(fis);
                this.variableCache = (Map)ois.readObject();
                this.defaultVariableCache = (Map)ois.readObject();
                ConfigUtil.closeIO(ois);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loadVariableCache():  Exception = " + e.getMessage()), (Object[])new Object[0]);
                }
                break block6;
            }
            finally {
                ConfigUtil.closeIO(ois);
                ConfigUtil.closeIO(fis);
            }
            ConfigUtil.closeIO(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private synchronized void saveVariableCache() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.variableCacheFile, false);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.variableCache);
            oos.writeObject(this.defaultVariableCache);
        }
        catch (IOException e) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("saveVariableCache():  Exception = " + e.getMessage()), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)ConfigVariableRegistry.class.getName(), (String)("saveVariableCache(): Exception = " + e.getMessage()));
            }
            catch (Throwable throwable) {
                ConfigUtil.closeIO(oos);
                ConfigUtil.closeIO(fos);
                throw throwable;
            }
            ConfigUtil.closeIO(oos);
            ConfigUtil.closeIO(fos);
        }
        ConfigUtil.closeIO(oos);
        ConfigUtil.closeIO(fos);
    }

    public synchronized void setDefaultVariables(Map<String, ConfigVariable> variables) {
        boolean dirty = false;
        for (Map.Entry<String, ConfigVariable> entry : variables.entrySet()) {
            String variableName = entry.getKey();
            String currentValue = this.lookupVariable(variableName);
            if (currentValue != null) continue;
            String defaultValue = entry.getValue().getValue();
            this.registry.addVariable(variableName, defaultValue);
            Object oldValue = this.defaultVariableCache.put(variableName, defaultValue);
            dirty = oldValue == null ? true : !oldValue.equals(defaultValue);
        }
        if (dirty) {
            this.saveVariableCache();
        }
    }

    public boolean addVariable(String variable, String value) {
        return this.registry.addVariable(variable, value);
    }

    public void replaceVariable(String variable, String value) {
        this.registry.replaceVariable(variable, value);
    }

    public String resolveString(String string) {
        return this.registry.resolveString(string);
    }

    public String resolveRawString(String string) {
        return this.registry.resolveRawString(string);
    }

    public void removeVariable(String symbol) {
        this.registry.removeVariable(symbol);
    }

    public String getUniqueVarString(ExtendedAttributeDefinition attrDef, String value) {
        return UNIQUE + attrDef.getUniqueCategory() + value;
    }

    public void removeUniqueVariable(ExtendedAttributeDefinition attrDef, String attributeValue) {
        this.removeVariable(this.getUniqueVarString(attrDef, attributeValue));
    }

    public void addVariableInUse(String variable) {
        this.addVariable(variable, IN_USE);
    }
}

