/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ChangeHandler;
import com.ibm.ws.config.xml.internal.ConfigComparator;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.ConfigurationMonitor;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigRefresher {
    static final TraceComponent tc = Tr.register(ConfigRefresher.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final ChangeHandler changeHandler;
    private final ServerXMLConfiguration serverXMLConfig;
    private final ConfigurationMonitor configurationMonitor;
    private final ServiceTracker<RuntimeUpdateManager, RuntimeUpdateManager> runtimeUpdateManagerTracker;
    private final ServiceTracker<Executor, Executor> executorTracker;
    private final ServiceTracker<MetaTypeRegistry, MetaTypeRegistry> metatypeTracker;
    private long configStartTime = 0L;
    private Collection<Future<?>> futuresForChanges = null;
    static final long serialVersionUID = -5383773398630005622L;

    ConfigRefresher(BundleContext bundleContext, ChangeHandler changeHandler, ServerXMLConfiguration serverXMLConfig) {
        this.changeHandler = changeHandler;
        this.serverXMLConfig = serverXMLConfig;
        this.configurationMonitor = new ConfigurationMonitor(bundleContext, serverXMLConfig, this);
        this.runtimeUpdateManagerTracker = new ServiceTracker(bundleContext, RuntimeUpdateManager.class.getName(), null);
        this.runtimeUpdateManagerTracker.open();
        this.executorTracker = new ServiceTracker(bundleContext, ExecutorService.class.getName(), null);
        this.executorTracker.open();
        this.metatypeTracker = new ServiceTracker(bundleContext, MetaTypeRegistry.class.getName(), null);
        this.metatypeTracker.open();
    }

    void start() {
        this.configurationMonitor.registerService();
    }

    void stop() {
        this.configurationMonitor.stopConfigurationMonitoring();
        this.runtimeUpdateManagerTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    synchronized void refreshConfiguration() {
        if (FrameworkState.isStopping()) {
            return;
        }
        this.configStartTime = System.nanoTime();
        RuntimeUpdateManager runtimeUpdateManager = (RuntimeUpdateManager)this.runtimeUpdateManagerTracker.getService();
        RuntimeUpdateNotification configUpdatesDelivered = runtimeUpdateManager.createNotification("ConfigUpdatesDelivered");
        this.futuresForChanges = null;
        try {
            Tr.audit((TraceComponent)tc, (String)"info.config.refresh.start", (Object[])new Object[0]);
            ServerConfiguration newConfiguration = this.serverXMLConfig.loadNewConfiguration();
            if (newConfiguration == null) {
                return;
            }
            ConfigComparator.ComparatorResult result = this.compareConfigurations(this.serverXMLConfig.getConfiguration(), newConfiguration);
            if (result == null) {
                return;
            }
            Collection<ConfigurationInfo> configurations = null;
            if (!result.hasDelta()) {
                Tr.audit((TraceComponent)tc, (String)"info.config.refresh.nochanges", (Object[])new Object[0]);
            } else {
                try {
                    configurations = this.changeHandler.switchConfiguration(this.serverXMLConfig, result);
                }
                catch (ConfigUpdateException configUpdateException) {
                    void e;
                    FFDCFilter.processException((Throwable)configUpdateException, (String)"com.ibm.ws.config.xml.internal.ConfigRefresher", (String)"115", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e.getMessage()});
                }
            }
            this.configurationMonitor.updateFileMonitor(this.serverXMLConfig.getFilesToMonitor());
            this.configurationMonitor.updateDirectoryMonitor(this.serverXMLConfig.getDirectoriesToMonitor());
            if (configurations != null) {
                this.futuresForChanges = this.fireConfigurationChanges(configurations);
            }
        }
        catch (Exception newConfiguration) {
            void e;
            FFDCFilter.processException((Throwable)newConfiguration, (String)"com.ibm.ws.config.xml.internal.ConfigRefresher", (String)"127", (Object)this, (Object[])new Object[0]);
            configUpdatesDelivered.setResult((Throwable)e);
        }
        finally {
            this.changesEnded(configUpdatesDelivered);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ConfigComparator.ComparatorResult compareConfigurations(ServerConfiguration serverConfiguration, ServerConfiguration newConfiguration) {
        ConfigComparator.ComparatorResult result;
        ConfigComparator comparator = new ConfigComparator(serverConfiguration, newConfiguration, (MetaTypeRegistry)this.metatypeTracker.getService());
        try {
            result = comparator.computeDelta();
        }
        catch (ConfigUpdateException configUpdateException) {
            void e1;
            FFDCFilter.processException((Throwable)configUpdateException, (String)"com.ibm.ws.config.xml.internal.ConfigRefresher", (String)"141", (Object)this, (Object[])new Object[]{serverConfiguration, newConfiguration});
            Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e1.getMessage()});
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("doRefreshConfiguration(): Configuration changes: " + result), (Object[])new Object[0]);
        }
        result.setNewConfiguration(newConfiguration);
        return result;
    }

    private Collection<Future<?>> fireConfigurationChanges(Collection<ConfigurationInfo> configurations) {
        ArrayList futures = new ArrayList();
        for (ConfigurationInfo info : configurations) {
            info.fireEvents(futures);
        }
        return futures;
    }

    void changesEnded(final RuntimeUpdateNotification configUpdatesDelivered) {
        final long endingConfigStartTime = this.configStartTime;
        final Collection<Future<?>> endingFuturesForChanges = this.futuresForChanges;
        this.configStartTime = 0L;
        this.futuresForChanges = null;
        Executor executor = (Executor)this.executorTracker.getService();
        if (executor != null) {
            executor.execute(new Runnable(){
                static final long serialVersionUID = -2771400905243585973L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    ConfigRefresher.this.endConfigChanges(configUpdatesDelivered, endingConfigStartTime, endingFuturesForChanges);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        } else {
            this.endConfigChanges(configUpdatesDelivered, endingConfigStartTime, endingFuturesForChanges);
        }
    }

    private void endConfigChanges(RuntimeUpdateNotification configUpdatesDelivered, long endingConfigStartTime, Collection<Future<?>> endingFuturesForChanges) {
        RuntimeUpdateNotification appsStarting;
        boolean noTimeout = endingFuturesForChanges != null ? this.waitForAll(endingFuturesForChanges, 1L, TimeUnit.MINUTES) : true;
        configUpdatesDelivered.setResult(true);
        RuntimeUpdateManager runtimeUpdateManager = (RuntimeUpdateManager)this.runtimeUpdateManagerTracker.getService();
        RuntimeUpdateNotification featureUpdatesCompleted = runtimeUpdateManager.getNotification("FeatureUpdatesCompleted");
        if (featureUpdatesCompleted != null) {
            featureUpdatesCompleted.waitForCompletion();
        }
        if ((appsStarting = runtimeUpdateManager.getNotification("ApplicationsStarting")) != null) {
            appsStarting.waitForCompletion();
        }
        if (endingFuturesForChanges != null) {
            if (noTimeout) {
                Tr.audit((TraceComponent)tc, (String)"info.config.refresh.stop", (Object[])new Object[]{TimestampUtils.getElapsedTimeNanos((long)endingConfigStartTime)});
            } else {
                Tr.warning((TraceComponent)tc, (String)"info.config.refresh.timeout", (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={InterruptedException.class, ExecutionException.class, TimeoutException.class})
    private boolean waitForAll(Collection<Future<?>> futureList, long timeout, TimeUnit timeUnit) {
        long timeoutNanos = timeUnit.toNanos(timeout);
        for (Future<?> future : futureList) {
            if (future == null || future.isDone()) continue;
            if (timeoutNanos <= 0L) {
                return false;
            }
            long startTime = System.nanoTime();
            try {
                future.get(timeoutNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
            long endTime = System.nanoTime();
            timeoutNanos -= endTime - startTime;
        }
        return true;
    }
}

