/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.HoldingExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Lock {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    private HashMap _sharedThreads = null;
    private Thread _threadHoldingExclusiveLock = null;
    private Thread _threadRequestingExclusiveLock = null;
    private String _traceId;
    static final long serialVersionUID = 510382391632143956L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Lock(String ownerIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Lock", (Object)ownerIdentifier);
        }
        this._sharedThreads = new HashMap();
        this._threadHoldingExclusiveLock = null;
        this._threadRequestingExclusiveLock = null;
        this._traceId = "Lock:ownerIdentifier=" + ownerIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"Lock", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void getSharedLock(int requestId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getSharedLock", (Object)new Object[]{this, new Integer(requestId)});
        }
        Thread currentThread = Thread.currentThread();
        Integer count = null;
        Lock lock = this;
        synchronized (lock) {
            if (!this._sharedThreads.containsKey(currentThread) && (this._threadRequestingExclusiveLock != null || this._threadHoldingExclusiveLock != null && !this._threadHoldingExclusiveLock.equals(currentThread))) {
                while (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is waiting for the exclusive lock to be released"));
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " waiting.."));
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        void exc;
                        com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.Lock", (String)"195", (Object)this, (Object[])new Object[]{requestId});
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.Lock.getSharedLock", (String)"180", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition"));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is has detected that the exclusive lock has been released"));
                }
            }
            count = (count = (Integer)this._sharedThreads.get(currentThread)) == null ? new Integer(1) : new Integer(count + 1);
            this._sharedThreads.put(currentThread, count);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Count: " + count));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getSharedLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedLock(int requestId) throws NoSharedLockException {
        Integer count;
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"releaseSharedLock", (Object)new Object[]{this, new Integer(requestId)});
        }
        Thread currentThread = Thread.currentThread();
        int newValue = 0;
        Lock lock = this;
        synchronized (lock) {
            count = (Integer)this._sharedThreads.get(currentThread);
            if (count == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"releaseSharedLock", (Object)"NoSharedLockException");
                }
                throw new NoSharedLockException();
            }
            newValue = count - 1;
            if (newValue > 0) {
                count = new Integer(newValue);
                this._sharedThreads.put(currentThread, count);
            } else {
                count = null;
                this._sharedThreads.remove(currentThread);
            }
            if (count == null) {
                this.notifyAll();
            }
        }
        if (tc.isDebugEnabled()) {
            int countValue = 0;
            count = (Integer)this._sharedThreads.get(currentThread);
            if (count != null) {
                countValue = count;
            }
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Count: " + count));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"releaseSharedLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean attemptExclusiveLock() throws HoldingExclusiveLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"attemptExclusiveLock", (Object)this);
        }
        boolean obtained = false;
        Thread currentThread = Thread.currentThread();
        Lock lock = this;
        synchronized (lock) {
            if (this._threadHoldingExclusiveLock != null && this._threadHoldingExclusiveLock.equals(currentThread)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"attemptExclusiveLock", (Object)"HoldingExclusiveLockException");
                }
                throw new HoldingExclusiveLockException();
            }
            if (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                Integer suspendedSharedLockCount = (Integer)this._sharedThreads.get(currentThread);
                this._sharedThreads.remove(currentThread);
                this.notifyAll();
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is waiting for the exclusive lock to be released"));
                }
                while (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " waiting.."));
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        void exc;
                        com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.Lock", (String)"344", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.Lock.attemptExclusiveLock", (String)"325", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition"));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " has detected that the exclusive lock has been released"));
                }
                if (suspendedSharedLockCount != null) {
                    this._sharedThreads.put(currentThread, suspendedSharedLockCount);
                }
                obtained = false;
            } else {
                this._threadRequestingExclusiveLock = currentThread;
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is waiting for the shared locks to quiesce"));
                }
                while (this._sharedThreads.size() > 1 || this._sharedThreads.size() == 1 && !this._sharedThreads.containsKey(currentThread)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " waiting.."));
                        }
                        this.wait();
                    }
                    catch (InterruptedException suspendedSharedLockCount) {
                        void exc;
                        com.ibm.ws.ffdc.FFDCFilter.processException((Throwable)suspendedSharedLockCount, (String)"com.ibm.ws.recoverylog.spi.Lock", (String)"381", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.Lock.attemptExclusiveLock", (String)"362", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition"));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " has detected that the shared locks have quiesced"));
                }
                this._threadHoldingExclusiveLock = currentThread;
                this._threadRequestingExclusiveLock = null;
                obtained = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"attemptExclusiveLock", (Object)("" + obtained));
        }
        return obtained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusiveLock() throws NoExclusiveLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"releaseExclusiveLock", (Object)this);
        }
        Thread currentThread = Thread.currentThread();
        Lock lock = this;
        synchronized (lock) {
            if (this._threadHoldingExclusiveLock == null || !this._threadHoldingExclusiveLock.equals(currentThread)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"releaseExclusiveLock", (Object)"NoExclusiveLockException");
                }
                throw new NoExclusiveLockException();
            }
            this._threadHoldingExclusiveLock = null;
            this._threadRequestingExclusiveLock = null;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"releaseExclusiveLock");
        }
    }

    public String toString() {
        return this._traceId;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(Lock.class);
        tc = Tr.register(Lock.class, (String)"Transaction", null);
    }
}

