/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.server.rest.helpers.AttributeRoutingHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/mbeans/{objectName}/attributes", "com.ibm.wsspi.rest.handler.root=/mbeans/{objectName}/attributes/{attribute}"})
public class AttributeHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(AttributeHandler.class);
    private final String KEY_ROUTING_HELPER = "routingHelper";
    private final AtomicServiceReference<AttributeRoutingHelper> routingHelperRef = new AtomicServiceReference("routingHelper");
    static final long serialVersionUID = 6168275426307674437L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.routingHelperRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.routingHelperRef.deactivate(context);
    }

    @Reference(service=AttributeRoutingHelper.class, name="routingHelper", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRoutingHelper(ServiceReference<AttributeRoutingHelper> routingHelper) {
        this.routingHelperRef.setReference(routingHelper);
    }

    protected void unsetRoutingHelper(ServiceReference<AttributeRoutingHelper> routingHelper) {
        this.routingHelperRef.unsetReference(routingHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (request.getPathVariable("attribute") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.getAttribute(request, response);
                return;
            } else {
                if (!RESTHelper.isPutMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,PUT");
                this.setAttribute(request, response);
            }
            return;
        } else if (RESTHelper.isGetMethod(method)) {
            this.getAttributes(request, response);
            return;
        } else {
            if (!RESTHelper.isPostMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,POST");
            this.setAttributes(request, response);
        }
    }

    private void getAttributes(RESTRequest request, RESTResponse response) {
        MBeanInfo info;
        MBeanAttributeInfo[] attributeInfo;
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        List<String> queryAttributes = RESTHelper.getQueryParams(request, "attribute");
        if (RESTHelper.containsSingleRoutingContext(request)) {
            this.getRoutingHelper().getAttributes(request, response, objectName, queryAttributes, false);
            return;
        }
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, null);
        if (queryAttributes.isEmpty() && (attributeInfo = (info = MBeanServerHelper.getMBeanInfo(objectNameObj)).getAttributes()) != null) {
            for (int i = 0; i < attributeInfo.length; ++i) {
                queryAttributes.add(attributeInfo[i].getName());
            }
        }
        String[] queryArray = new String[queryAttributes.size()];
        AttributeList attributeList = MBeanServerHelper.getAttributes(objectNameObj, queryAttributes.toArray(queryArray));
        OutputHelper.writeAttributeListOutput(response, attributeList, JSONConverter.getConverter());
    }

    @FFDCIgnore(value={ConversionException.class, IOException.class, ClassNotFoundException.class})
    private void setAttributes(RESTRequest request, RESTResponse response) {
        if (RESTHelper.containsSingleRoutingContext(request)) {
            this.getRoutingHelper().setAttributes(request, response, false);
            return;
        }
        RESTHelper.ensureConsumesJson(request);
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        InputStream is = RESTHelper.getInputStream(request);
        JSONConverter converter = JSONConverter.getConverter();
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, converter);
        AttributeList inputAttributeList = null;
        try {
            inputAttributeList = converter.readAttributeList(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        AttributeList attributeList = MBeanServerHelper.setAttributes(objectNameObj, inputAttributeList, converter);
        OutputHelper.writeAttributeListOutput(response, attributeList, converter);
    }

    private void getAttribute(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        String attributeName = RESTHelper.getRequiredParam(request, "attribute");
        if (RESTHelper.containsSingleRoutingContext(request)) {
            this.getRoutingHelper().getAttribute(request, response, objectName, attributeName, false);
            return;
        }
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, null);
        Object pojo = MBeanServerHelper.getAttribute(objectNameObj, attributeName);
        OutputHelper.writePOJOOutput(response, pojo, JSONConverter.getConverter());
    }

    @FFDCIgnore(value={ConversionException.class, IOException.class, ClassNotFoundException.class})
    private void setAttribute(RESTRequest request, RESTResponse response) {
        if (RESTHelper.containsSingleRoutingContext(request)) {
            this.getRoutingHelper().setAttribute(request, response, false);
            return;
        }
        RESTHelper.ensureConsumesJson(request);
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        String attributeName = RESTHelper.getRequiredParam(request, "attribute");
        InputStream is = RESTHelper.getInputStream(request);
        JSONConverter converter = JSONConverter.getConverter();
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, converter);
        Object newValue = null;
        try {
            newValue = converter.readPOJO(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        Attribute attribute = new Attribute(attributeName, newValue);
        MBeanServerHelper.setAttribute(objectNameObj, attribute, converter);
        JSONConverter.returnConverter((JSONConverter)converter);
        response.setContentType("application/json");
        response.setStatus(204);
    }

    private AttributeRoutingHelper getRoutingHelper() {
        AttributeRoutingHelper routingHelper = (AttributeRoutingHelper)this.routingHelperRef.getService();
        if (routingHelper == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"AttributeRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return routingHelper;
    }
}

