/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.AcceptorInfo;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.Transport;
import org.omg.CORBA.SystemException;

abstract class GIOPServerStarter {
    static final Logger logger = Logger.getLogger(GIOPServerStarter.class.getName());
    protected final ORBInstance orbInstance_;
    protected final Acceptor acceptor_;
    protected final OAInterface oaInterface_;
    protected final Vector connections_ = new Vector();
    public static final int StateActive = 0;
    public static final int StateHolding = 1;
    public static final int StateClosed = 2;
    protected int state_;

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.state_ == 2);
        super.finalize();
    }

    protected void logCloseAcceptor() {
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            AcceptorInfo info = this.acceptor_.get_info();
            String msg = "stopped accepting connections\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("incoming", msg);
        }
    }

    protected void reapWorkers() {
        int i = 0;
        while (i < this.connections_.size()) {
            GIOPConnection connection = (GIOPConnection)this.connections_.elementAt(i);
            if (connection.destroyed()) {
                this.connections_.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    GIOPServerStarter(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface) {
        this.orbInstance_ = orbInstance;
        this.acceptor_ = acceptor;
        this.oaInterface_ = oaInterface;
        this.state_ = 1;
        try {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                AcceptorInfo info = this.acceptor_.get_info();
                String msg = "accepting connections\n";
                msg = msg + info.describe();
                this.orbInstance_.getLogger().trace("incoming", msg);
            }
            this.acceptor_.listen();
        }
        catch (SystemException ex) {
            this.acceptor_.close();
            this.state_ = 2;
            throw ex;
        }
    }

    public synchronized GIOPConnection getMatchingConnection(ConnectorInfo connInfo) {
        this.reapWorkers();
        for (int i = 0; i < this.connections_.size(); ++i) {
            Transport transport;
            GIOPConnection worker = (GIOPConnection)this.connections_.elementAt(i);
            if (worker.isOutbound() || (transport = worker.transport()) == null || !transport.get_info().endpoint_alias_match(connInfo)) continue;
            return worker;
        }
        return null;
    }

    public abstract void setState(int var1);
}

