/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CORBA;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import org.apache.yoko.orb.CORBA.Any;
import org.apache.yoko.orb.CORBA.Context;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.OB_Extras;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.TypeCodeCache;
import org.apache.yoko.orb.OB.TypeCodeFactory;
import org.apache.yoko.orb.OB.ValueReader;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.SendingContext.CodeBase;

public final class InputStream
extends org.omg.CORBA_2_3.portable.InputStream
implements ValueInputStream {
    static final Logger logger = Logger.getLogger(InputStream.class.getName());
    ORBInstance orbInstance_;
    public Buffer buf_;
    boolean swap_;
    private GiopVersion giopVersion_ = OB_Extras.DEFAULT_GIOP_VERSION;
    private int origPos_;
    private boolean origSwap_;
    private ValueReader valueReader_;
    private TypeCodeCache cache_;
    private CodeConverters codeConverters_;
    private boolean charReaderRequired_;
    private boolean charConversionRequired_;
    private boolean wCharReaderRequired_;
    private boolean wCharConversionRequired_;
    private CodeBase sendingContextRuntime_;
    private String codebase_;

    private TypeCode checkCache(String id, int startPos, int length) {
        TypeCode tc = null;
        if (id.length() > 0 && (tc = this.cache_.get(id)) != null) {
            this._OB_skip(length + startPos - this.buf_.pos_);
        }
        return tc;
    }

    private org.omg.CORBA.TypeCode readTypeCodeImpl(Hashtable history, boolean isTopLevel) {
        int kind = this.read_ulong();
        int oldPos = this.buf_.pos_ - 4;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Reading a TypeCode of kind %d from position 0x%x", kind, oldPos));
        }
        TypeCode tc = null;
        if (kind == -1) {
            TypeCode p;
            int offs = this.read_long();
            int indirectionPos = this.buf_.pos_ - 4 + offs;
            if ((p = (TypeCode)((java.lang.Object)history.get(new Integer(indirectionPos += indirectionPos & 3)))) == null) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974950), 1095974950, CompletionStatus.COMPLETED_NO);
            }
            history.put(new Integer(oldPos), p);
            tc = p;
        } else {
            switch (kind) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    tc = (TypeCode)TypeCodeFactory.createPrimitiveTC(org.omg.CORBA_2_4.TCKind.from_int((int)kind));
                    history.put(new Integer(oldPos), tc);
                    break;
                }
                case 28: {
                    short digits = this.read_ushort();
                    short scale = this.read_short();
                    tc = (TypeCode)TypeCodeFactory.createFixedTC(digits, scale);
                    history.put(new Integer(oldPos), tc);
                    break;
                }
                case 14: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createInterfaceTC(id, this.read_string());
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    history.put(new Integer(oldPos), tc);
                    this.swap_ = swap;
                    break;
                }
                case 15: 
                case 22: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        TypeCode p = new TypeCode();
                        history.put(new Integer(oldPos), p);
                        p.kind_ = org.omg.CORBA_2_4.TCKind.from_int((int)kind);
                        p.id_ = id;
                        p.name_ = this.read_string();
                        int num = this.read_ulong();
                        p.memberNames_ = new String[num];
                        p.memberTypes_ = new TypeCode[num];
                        for (int i = 0; i < num; ++i) {
                            p.memberNames_[i] = this.read_string();
                            p.memberTypes_[i] = (TypeCode)this.readTypeCodeImpl(history, false);
                        }
                        tc = p;
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 16: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        TypeCode p = new TypeCode();
                        history.put(new Integer(oldPos), p);
                        p.kind_ = TCKind.tk_union;
                        p.id_ = id;
                        p.name_ = this.read_string();
                        p.discriminatorType_ = (TypeCode)this.readTypeCodeImpl(history, false);
                        int defaultIndex = this.read_long();
                        int num = this.read_ulong();
                        p.labels_ = new Any[num];
                        p.memberNames_ = new String[num];
                        p.memberTypes_ = new TypeCode[num];
                        TypeCode origTC = p.discriminatorType_._OB_getOrigType();
                        switch (origTC.kind().value()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 8: 
                            case 9: 
                            case 17: 
                            case 23: 
                            case 24: {
                                break;
                            }
                            default: {
                                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
                            }
                        }
                        for (int i = 0; i < num; ++i) {
                            p.labels_[i] = new Any();
                            if (i == defaultIndex) {
                                Any dummy = new Any();
                                dummy.read_value((org.omg.CORBA.portable.InputStream)this, p.discriminatorType_);
                                p.labels_[i].insert_octet((byte)0);
                            } else {
                                p.labels_[i].read_value((org.omg.CORBA.portable.InputStream)this, p.discriminatorType_);
                            }
                            p.memberNames_[i] = this.read_string();
                            p.memberTypes_[i] = (TypeCode)this.readTypeCodeImpl(history, false);
                        }
                        tc = p;
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 17: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        String name = this.read_string();
                        int num = this.read_ulong();
                        String[] members = new String[num];
                        for (int i = 0; i < num; ++i) {
                            members[i] = this.read_string();
                        }
                        tc = (TypeCode)TypeCodeFactory.createEnumTC(id, name, members);
                        history.put(new Integer(oldPos), tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 18: {
                    tc = (TypeCode)TypeCodeFactory.createStringTC(this.read_ulong());
                    history.put(new Integer(oldPos), tc);
                    break;
                }
                case 27: {
                    tc = (TypeCode)TypeCodeFactory.createWStringTC(this.read_ulong());
                    history.put(new Integer(oldPos), tc);
                    break;
                }
                case 19: 
                case 20: {
                    this.read_ulong();
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    TypeCode p = new TypeCode();
                    history.put(new Integer(oldPos), p);
                    p.kind_ = org.omg.CORBA_2_4.TCKind.from_int((int)kind);
                    p.contentType_ = (TypeCode)this.readTypeCodeImpl(history, false);
                    p.length_ = this.read_ulong();
                    tc = p;
                    this.swap_ = swap;
                    break;
                }
                case 21: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createAliasTC(id, this.read_string(), this.readTypeCodeImpl(history, false));
                        history.put(new Integer(oldPos), tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 29: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        TypeCode p = new TypeCode();
                        history.put(new Integer(oldPos), p);
                        p.kind_ = org.omg.CORBA_2_4.TCKind.from_int((int)kind);
                        p.id_ = id;
                        p.name_ = this.read_string();
                        p.typeModifier_ = this.read_short();
                        p.concreteBaseType_ = (TypeCode)this.readTypeCodeImpl(history, false);
                        if (p.concreteBaseType_.kind().value() == 0) {
                            p.concreteBaseType_ = null;
                        }
                        int num = this.read_ulong();
                        p.memberNames_ = new String[num];
                        p.memberTypes_ = new TypeCode[num];
                        p.memberVisibility_ = new short[num];
                        for (int i = 0; i < num; ++i) {
                            p.memberNames_[i] = this.read_string();
                            p.memberTypes_[i] = (TypeCode)this.readTypeCodeImpl(history, false);
                            p.memberVisibility_[i] = this.read_short();
                        }
                        tc = p;
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 30: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createValueBoxTC(id, this.read_string(), this.readTypeCodeImpl(history, false));
                        history.put(new Integer(oldPos), tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 32: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("Abstract interface typecode encapsulaton length=0x%x id=%s", length, id));
                    }
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createAbstractInterfaceTC(id, this.read_string());
                        history.put(new Integer(oldPos), tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                case 31: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createNativeTC(id, this.read_string());
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    history.put(new Integer(oldPos), tc);
                    this.swap_ = swap;
                    break;
                }
                case 33: {
                    int length = this.read_ulong();
                    this.checkChunk();
                    int typePos = this.buf_.pos_;
                    boolean swap = this.swap_;
                    this._OB_readEndian();
                    String id = this.read_string();
                    if (isTopLevel && this.cache_ != null) {
                        tc = this.checkCache(id, typePos, length);
                    }
                    if (tc == null) {
                        tc = (TypeCode)TypeCodeFactory.createLocalInterfaceTC(id, this.read_string());
                        history.put(new Integer(oldPos), tc);
                        if (id.length() > 0 && this.cache_ != null) {
                            this.cache_.put(id, tc);
                        }
                    }
                    this.swap_ = swap;
                    break;
                }
                default: {
                    throw new BAD_TYPECODE("Unknown TypeCode kind: " + kind);
                }
            }
        }
        return tc;
    }

    private ValueReader valueReader() {
        if (this.valueReader_ == null) {
            this.valueReader_ = new ValueReader(this);
        }
        return this.valueReader_;
    }

    private char _OB_read_wchar_old() {
        this.checkChunk();
        if (this.wCharConversionRequired_) {
            char value;
            CodeConverterBase converter = this.codeConverters_.inputWcharConverter;
            switch (this.giopVersion_) {
                case GIOP1_1: {
                    if (converter.getFrom().max_bytes <= 2) {
                        value = (char)this.read_ushort();
                        break;
                    }
                    value = (char)this.read_ulong();
                    break;
                }
                default: {
                    int wcharLen = this.buf_.data_[this.buf_.pos_++] & 0xFF;
                    if (this.buf_.pos_ + wcharLen > this.buf_.len_) {
                        throw new MARSHAL(MinorCodes.describeMarshal(1095974916), 1095974916, CompletionStatus.COMPLETED_NO);
                    }
                    value = converter.read_wchar(this, wcharLen);
                    break;
                }
            }
            return converter.convert(value);
        }
        switch (this.giopVersion_) {
            case GIOP1_0: {
                this.buf_.pos_ += this.buf_.pos_ & 1;
                if (this.buf_.pos_ + 2 > this.buf_.len_) {
                    throw new MARSHAL(1095974916, CompletionStatus.COMPLETED_NO);
                }
                return (char)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF);
            }
            case GIOP1_1: {
                return (char)this.read_ushort();
            }
        }
        int wcharLen = this.buf_.data_[this.buf_.pos_++] & 0xFF;
        if (this.buf_.pos_ + wcharLen > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974916), 1095974916, CompletionStatus.COMPLETED_NO);
        }
        return (char)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF);
    }

    private char _OB_read_wchar_new(boolean partOfString) {
        char value;
        this.checkChunk();
        CodeConverterBase converter = this.codeConverters_.inputWcharConverter;
        if (this.wCharReaderRequired_) {
            if (!partOfString) {
                converter.set_reader_flags(2);
            }
            int wcLen = 2;
            switch (this.giopVersion_) {
                case GIOP1_0: {
                    Assert._OB_assert(false);
                    break;
                }
                case GIOP1_1: {
                    this.buf_.pos_ += this.buf_.pos_ & 1;
                    break;
                }
                default: {
                    wcLen = this.buf_.data_[this.buf_.pos_++] & 0xFF;
                }
            }
            if (this.buf_.pos_ + wcLen > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974916), 1095974916, CompletionStatus.COMPLETED_NO);
            }
            value = converter.read_wchar(this, wcLen);
        } else {
            switch (this.giopVersion_) {
                case GIOP1_0: {
                    Assert._OB_assert(!this.wCharConversionRequired_);
                    this.buf_.pos_ += this.buf_.pos_ & 1;
                    if (this.buf_.pos_ + 2 > this.buf_.len_) {
                        throw new MARSHAL(1095974916, CompletionStatus.COMPLETED_NO);
                    }
                    return (char)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF);
                }
                case GIOP1_1: {
                    if (converter.getFrom().max_bytes <= 2) {
                        value = (char)this.read_ushort();
                        break;
                    }
                    value = (char)this.read_ulong();
                    break;
                }
                default: {
                    int wcLen = this.buf_.data_[this.buf_.pos_++] & 0xFF;
                    if (this.buf_.pos_ + wcLen > this.buf_.len_) {
                        throw new MARSHAL(1095974916, CompletionStatus.COMPLETED_NO);
                    }
                    if (this.swap_) {
                        value = (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF | this.buf_.data_[this.buf_.pos_++] << 8);
                        break;
                    }
                    value = (char)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF);
                    break;
                }
            }
        }
        if (this.wCharConversionRequired_) {
            value = converter.convert(value);
        }
        return value;
    }

    private String _OB_read_wstring_old() {
        String s = "";
        this.checkChunk();
        switch (this.giopVersion_) {
            case GIOP1_1: 
            case GIOP1_0: {
                int len;
                if (len == 0) {
                    throw new MARSHAL(MinorCodes.describeMarshal(1095974932), 1095974932, CompletionStatus.COMPLETED_NO);
                }
                char[] tmp = new char[len];
                this.read_wchar_array(tmp, 0, len);
                if (tmp[len - 1] != '\u0000') {
                    throw new MARSHAL(MinorCodes.describeMarshal(1095974934), 1095974934, CompletionStatus.COMPLETED_NO);
                }
                s = new String(tmp, 0, len - 1);
                break;
            }
            default: {
                int len;
                StringBuffer stringBuffer = new StringBuffer(len);
                if (this.wCharConversionRequired_) {
                    int wcharLen;
                    CodeConverterBase converter = this.codeConverters_.inputWcharConverter;
                    for (len = this.read_ulong(); len > 0; len -= wcharLen) {
                        wcharLen = converter.read_count_wchar((char)this.buf_.data_[this.buf_.pos_]);
                        if (this.buf_.pos_ + wcharLen > this.buf_.len_) {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974931), 1095974931, CompletionStatus.COMPLETED_NO);
                        }
                        char c = converter.read_wchar(this, wcharLen);
                        if ((c = converter.convert(c)) == '\u0000') {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974933), 1095974933, CompletionStatus.COMPLETED_NO);
                        }
                        stringBuffer.append(c);
                    }
                } else {
                    while (len > 0) {
                        char c;
                        int wcharLen = 2;
                        len -= 2;
                        if (this.buf_.pos_ + 2 > this.buf_.len_) {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974931), 1095974931, CompletionStatus.COMPLETED_NO);
                        }
                        if ((c = (char)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF)) == '\u0000') {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974933), 1095974933, CompletionStatus.COMPLETED_NO);
                        }
                        stringBuffer.append(c);
                    }
                }
                s = stringBuffer.toString();
                break;
            }
        }
        return s;
    }

    private String _OB_read_wstring_new() {
        String s = "";
        this.checkChunk();
        CodeConverterBase converter = this.codeConverters_.inputWcharConverter;
        int len = this.read_ulong();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Reading wstring of length 0x%x", len));
        }
        switch (this.giopVersion_) {
            case GIOP1_1: 
            case GIOP1_0: {
                if (len == 0) {
                    throw new MARSHAL(MinorCodes.describeMarshal(1095974932), 1095974932, CompletionStatus.COMPLETED_NO);
                }
                char[] tmp = new char[len];
                if (this.wCharReaderRequired_) {
                    converter.set_reader_flags(2);
                }
                for (int i = 0; i < len; ++i) {
                    tmp[i] = this.read_wchar(true);
                }
                if (tmp[len - 1] != '\u0000') {
                    throw new MARSHAL(MinorCodes.describeMarshal(1095974934), 1095974934, CompletionStatus.COMPLETED_NO);
                }
                s = new String(tmp, 0, len - 1);
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer(len);
                if (this.wCharReaderRequired_) {
                    converter.set_reader_flags(2);
                    while (len > 0) {
                        if (this.buf_.pos_ + 2 > this.buf_.len_) {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974931), 1095974931, CompletionStatus.COMPLETED_NO);
                        }
                        int checkChar = this.buf_.data_[this.buf_.pos_] << 8 | this.buf_.data_[this.buf_.pos_ + 1] & 0xFF;
                        int wcLen = converter.read_count_wchar((char)checkChar);
                        len -= wcLen;
                        if (this.buf_.pos_ + wcLen > this.buf_.len_) {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974931), 1095974931, CompletionStatus.COMPLETED_NO);
                        }
                        char c = converter.read_wchar(this, wcLen);
                        if (this.wCharConversionRequired_) {
                            c = converter.convert(c);
                        }
                        if (c == '\u0000') {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974933), 1095974933, CompletionStatus.COMPLETED_NO);
                        }
                        stringBuffer.append(c);
                    }
                } else {
                    int wcLen = 2;
                    while (len > 0) {
                        len -= 2;
                        if (this.buf_.pos_ + 2 > this.buf_.len_) {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974931), 1095974931, CompletionStatus.COMPLETED_NO);
                        }
                        char c = this.swap_ ? (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF | this.buf_.data_[this.buf_.pos_++] << 8) : (char)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF);
                        if (this.wCharConversionRequired_) {
                            c = converter.convert(c);
                        }
                        if (c == '\u0000') {
                            throw new MARSHAL(MinorCodes.describeMarshal(1095974933), 1095974933, CompletionStatus.COMPLETED_NO);
                        }
                        stringBuffer.append(c);
                    }
                }
                s = stringBuffer.toString();
                break;
            }
        }
        return s;
    }

    public int available() throws IOException {
        Assert._OB_assert(this.buf_.len_ >= this.buf_.pos_);
        return this.buf_.len_ - this.buf_.pos_;
    }

    public int read() throws IOException {
        this.checkChunk();
        if (this.buf_.pos_ + 1 > this.buf_.len_) {
            return -1;
        }
        return 0xFF & this.buf_.data_[this.buf_.pos_++];
    }

    public ORB orb() {
        if (this.orbInstance_ != null) {
            return this.orbInstance_.getORB();
        }
        return null;
    }

    public boolean read_boolean() {
        this.checkChunk();
        if (this.buf_.pos_ + 1 > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Boolean value is %b from position 0x%x", this.buf_.data_[this.buf_.pos_], this.buf_.pos_));
        }
        return this.buf_.data_[this.buf_.pos_++] != 0;
    }

    public char read_char() {
        this.checkChunk();
        if (this.buf_.pos_ + 1 > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
        }
        if (this.charReaderRequired_ || this.charConversionRequired_) {
            CodeConverterBase converter = this.codeConverters_.inputCharConverter;
            if (this.charReaderRequired_ && this.charConversionRequired_) {
                return converter.convert(converter.read_char(this));
            }
            if (this.charReaderRequired_) {
                return converter.read_char(this);
            }
            return converter.convert((char)(this.buf_.data_[this.buf_.pos_++] & 0xFF));
        }
        return (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF);
    }

    public char read_wchar() {
        return this.read_wchar(false);
    }

    public char read_wchar(boolean partOfString) {
        return this._OB_read_wchar_new(partOfString);
    }

    public byte read_octet() {
        this.checkChunk();
        if (this.buf_.pos_ + 1 > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974917), 1095974917, CompletionStatus.COMPLETED_NO);
        }
        return this.buf_.data_[this.buf_.pos_++];
    }

    public short read_short() {
        this.checkChunk();
        this.buf_.pos_ += this.buf_.pos_ & 1;
        if (this.buf_.pos_ + 2 > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974918), 1095974918, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            return (short)(this.buf_.data_[this.buf_.pos_++] & 0xFF | this.buf_.data_[this.buf_.pos_++] << 8);
        }
        return (short)(this.buf_.data_[this.buf_.pos_++] << 8 | this.buf_.data_[this.buf_.pos_++] & 0xFF);
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        this.checkChunk();
        return this._OB_readLongUnchecked();
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        this.checkChunk();
        int pmod8 = this.buf_.pos_ & 7;
        if (pmod8 != 0) {
            this.buf_.pos_ += 8 - pmod8;
        }
        if (this.buf_.pos_ + 8 > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974922), 1095974922, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            return (long)this.buf_.data_[this.buf_.pos_++] & 0xFFL | (long)this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00L | (long)this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000L | (long)this.buf_.data_[this.buf_.pos_++] << 24 & 0xFF000000L | (long)this.buf_.data_[this.buf_.pos_++] << 32 & 0xFF00000000L | (long)this.buf_.data_[this.buf_.pos_++] << 40 & 0xFF0000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 48 & 0xFF000000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 56;
        }
        return (long)this.buf_.data_[this.buf_.pos_++] << 56 | (long)this.buf_.data_[this.buf_.pos_++] << 48 & 0xFF000000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 40 & 0xFF0000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 32 & 0xFF00000000L | (long)this.buf_.data_[this.buf_.pos_++] << 24 & 0xFF000000L | (long)this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000L | (long)this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00L | (long)this.buf_.data_[this.buf_.pos_++] & 0xFFL;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public String read_string() {
        this.checkChunk();
        int length = this.read_ulong();
        if (length == 0) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974928), 1095974928, CompletionStatus.COMPLETED_NO);
        }
        int newPos = this.buf_.pos_ + length;
        if (newPos < this.buf_.pos_ || newPos > this.buf_.len_) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("String length=0x%x newPos=0x%x buf_.pos=0x%x buf_.len=0x%x", length, newPos, this.buf_.pos_, this.buf_.len_));
            }
            throw new MARSHAL(MinorCodes.describeMarshal(1095974927), 1095974927, CompletionStatus.COMPLETED_NO);
        }
        char[] arr = new char[--length];
        int maxChars = length;
        int numChars = 0;
        if (!this.charReaderRequired_ && !this.charConversionRequired_) {
            for (int i = 0; i < length; ++i) {
                arr[i] = (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF);
                if (arr[i] != '\u0000') continue;
                throw new MARSHAL(MinorCodes.describeMarshal(1095974929), 1095974929, CompletionStatus.COMPLETED_NO);
            }
        } else {
            CodeConverterBase converter = this.codeConverters_.inputCharConverter;
            int bufPos0 = this.buf_.pos_;
            int i = 0;
            while (this.buf_.pos_ - bufPos0 < length) {
                char value = this.charReaderRequired_ ? converter.read_char(this) : (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF);
                if (value == '\u0000') {
                    throw new MARSHAL(MinorCodes.describeMarshal(1095974929), 1095974929, CompletionStatus.COMPLETED_NO);
                }
                arr[i] = this.charConversionRequired_ ? converter.convert(value) : value;
                ++i;
            }
            numChars = i;
        }
        this.buf_.pos_ = newPos;
        if (this.buf_.data_[this.buf_.pos_ - 1] != 0) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974930), 1095974930, CompletionStatus.COMPLETED_NO);
        }
        int numExtraBytes = 0;
        if (numChars != 0 && numChars != maxChars) {
            numExtraBytes = maxChars - numChars;
        }
        if (numExtraBytes > 0) {
            String arrStr = new String(arr);
            return arrStr.substring(0, numChars);
        }
        return new String(arr);
    }

    public String read_wstring() {
        return this._OB_read_wstring_new();
    }

    public void read_boolean_array(boolean[] value, int offset, int length) {
        if (length > 0) {
            this.checkChunk();
            if (this.buf_.pos_ + length < this.buf_.pos_ || this.buf_.pos_ + length > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974937), 1095974937, CompletionStatus.COMPLETED_NO);
            }
            for (int i = offset; i < offset + length; ++i) {
                value[i] = this.buf_.data_[this.buf_.pos_++] != 0;
            }
        }
    }

    public void read_char_array(char[] value, int offset, int length) {
        block7: {
            if (length <= 0) break block7;
            this.checkChunk();
            if (this.buf_.pos_ + length < this.buf_.pos_ || this.buf_.pos_ + length > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974938), 1095974938, CompletionStatus.COMPLETED_NO);
            }
            if (!this.charReaderRequired_ && !this.charConversionRequired_) {
                for (int i = offset; i < offset + length; ++i) {
                    value[i] = (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF);
                }
            } else {
                CodeConverterBase converter = this.codeConverters_.inputCharConverter;
                boolean bothRequired = this.charReaderRequired_ && this.charConversionRequired_;
                for (int i = offset; i < offset + length; ++i) {
                    if (bothRequired) {
                        value[i] = converter.convert(converter.read_char(this));
                        continue;
                    }
                    if (this.charReaderRequired_) {
                        value[i] = converter.read_char(this);
                        continue;
                    }
                    char c = (char)(this.buf_.data_[this.buf_.pos_++] & 0xFF);
                    value[i] = converter.convert(c);
                }
            }
        }
    }

    public void read_wchar_array(char[] value, int offset, int length) {
        if (length > 0) {
            if (this.buf_.pos_ + length < this.buf_.pos_ || this.buf_.pos_ + length > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974938), 1095974938, CompletionStatus.COMPLETED_NO);
            }
            for (int i = offset; i < offset + length; ++i) {
                value[i] = this.read_wchar(false);
            }
        }
    }

    public void read_octet_array(byte[] value, int offset, int length) {
        if (length > 0) {
            this.checkChunk();
            int newPos = this.buf_.pos_ + length;
            if (newPos < this.buf_.pos_ || newPos > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974940), 1095974940, CompletionStatus.COMPLETED_NO);
            }
            System.arraycopy(this.buf_.data_, this.buf_.pos_, value, offset, length);
            this.buf_.pos_ = newPos;
        }
    }

    public void read_short_array(short[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        this.buf_.pos_ += this.buf_.pos_ & 1;
        int newPos = this.buf_.pos_ + length * 2;
        if (newPos < this.buf_.pos_ || newPos > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974941), 1095974941, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (short)((short)this.buf_.data_[this.buf_.pos_++] & 0xFF | (short)this.buf_.data_[this.buf_.pos_++] << 8);
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (short)((short)this.buf_.data_[this.buf_.pos_++] << 8 | (short)this.buf_.data_[this.buf_.pos_++] & 0xFF);
            }
        }
    }

    public void read_ushort_array(short[] value, int offset, int length) {
        this.read_short_array(value, offset, length);
    }

    public void read_long_array(int[] value, int offset, int length) {
        int newPos;
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        int pmod4 = this.buf_.pos_ & 3;
        if (pmod4 != 0) {
            this.buf_.pos_ += 4 - pmod4;
        }
        if ((newPos = this.buf_.pos_ + length * 4) < this.buf_.pos_ || newPos > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974943), 1095974943, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = this.buf_.data_[this.buf_.pos_++] & 0xFF | this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00 | this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000 | this.buf_.data_[this.buf_.pos_++] << 24;
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = this.buf_.data_[this.buf_.pos_++] << 24 | this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000 | this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00 | this.buf_.data_[this.buf_.pos_++] & 0xFF;
            }
        }
    }

    public void read_ulong_array(int[] value, int offset, int length) {
        this.read_long_array(value, offset, length);
    }

    public void read_longlong_array(long[] value, int offset, int length) {
        int newPos;
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        int pmod8 = this.buf_.pos_ & 7;
        if (pmod8 != 0) {
            this.buf_.pos_ += 8 - pmod8;
        }
        if ((newPos = this.buf_.pos_ + length * 8) < this.buf_.pos_ || newPos > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974945), 1095974945, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (long)this.buf_.data_[this.buf_.pos_++] & 0xFFL | (long)this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00L | (long)this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000L | (long)this.buf_.data_[this.buf_.pos_++] << 24 & 0xFF000000L | (long)this.buf_.data_[this.buf_.pos_++] << 32 & 0xFF00000000L | (long)this.buf_.data_[this.buf_.pos_++] << 40 & 0xFF0000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 48 & 0xFF000000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 56;
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value[i] = (long)this.buf_.data_[this.buf_.pos_++] << 56 | (long)this.buf_.data_[this.buf_.pos_++] << 48 & 0xFF000000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 40 & 0xFF0000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 32 & 0xFF00000000L | (long)this.buf_.data_[this.buf_.pos_++] << 24 & 0xFF000000L | (long)this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000L | (long)this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00L | (long)this.buf_.data_[this.buf_.pos_++] & 0xFFL;
            }
        }
    }

    public void read_ulonglong_array(long[] value, int offset, int length) {
        this.read_longlong_array(value, offset, length);
    }

    public void read_float_array(float[] value, int offset, int length) {
        block6: {
            int newPos;
            if (length <= 0) break block6;
            this.checkChunk();
            int pmod4 = this.buf_.pos_ & 3;
            if (pmod4 != 0) {
                this.buf_.pos_ += 4 - pmod4;
            }
            if ((newPos = this.buf_.pos_ + length * 4) < this.buf_.pos_ || newPos > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974947), 1095974947, CompletionStatus.COMPLETED_NO);
            }
            if (this.swap_) {
                for (int i = offset; i < offset + length; ++i) {
                    int v = this.buf_.data_[this.buf_.pos_++] & 0xFF | this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00 | this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000 | this.buf_.data_[this.buf_.pos_++] << 24;
                    value[i] = Float.intBitsToFloat(v);
                }
            } else {
                for (int i = offset; i < offset + length; ++i) {
                    int v = this.buf_.data_[this.buf_.pos_++] << 24 | this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000 | this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00 | this.buf_.data_[this.buf_.pos_++] & 0xFF;
                    value[i] = Float.intBitsToFloat(v);
                }
            }
        }
    }

    public void read_double_array(double[] value, int offset, int length) {
        int newPos;
        if (length <= 0) {
            return;
        }
        this.checkChunk();
        int pmod8 = this.buf_.pos_ & 7;
        if (pmod8 != 0) {
            this.buf_.pos_ += 8 - pmod8;
        }
        if ((newPos = this.buf_.pos_ + length * 8) < this.buf_.pos_ || newPos > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974948), 1095974948, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            for (int i = offset; i < offset + length; ++i) {
                long v = (long)this.buf_.data_[this.buf_.pos_++] & 0xFFL | (long)this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00L | (long)this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000L | (long)this.buf_.data_[this.buf_.pos_++] << 24 & 0xFF000000L | (long)this.buf_.data_[this.buf_.pos_++] << 32 & 0xFF00000000L | (long)this.buf_.data_[this.buf_.pos_++] << 40 & 0xFF0000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 48 & 0xFF000000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 56;
                value[i] = Double.longBitsToDouble(v);
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                long v = (long)this.buf_.data_[this.buf_.pos_++] << 56 | (long)this.buf_.data_[this.buf_.pos_++] << 48 & 0xFF000000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 40 & 0xFF0000000000L | (long)this.buf_.data_[this.buf_.pos_++] << 32 & 0xFF00000000L | (long)this.buf_.data_[this.buf_.pos_++] << 24 & 0xFF000000L | (long)this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000L | (long)this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00L | (long)this.buf_.data_[this.buf_.pos_++] & 0xFFL;
                value[i] = Double.longBitsToDouble(v);
            }
        }
    }

    public Object read_Object() {
        this.checkChunk();
        IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)this);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            return null;
        }
        if (this.orbInstance_ == null) {
            throw new INITIALIZE("InputStream must be created by a full ORB");
        }
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        return objectFactory.createObject(ior);
    }

    public Object read_Object(Class expectedType) {
        Object obj = this.read_Object();
        if (obj == null) {
            return null;
        }
        org.omg.CORBA.portable.ObjectImpl impl = (org.omg.CORBA.portable.ObjectImpl)obj;
        if (org.omg.CORBA.portable.ObjectImpl.class.isAssignableFrom(expectedType)) {
            return this.createStub(expectedType, impl._get_delegate());
        }
        String codebase = ((ObjectImpl)impl)._get_codebase();
        try {
            if (IDLEntity.class.isAssignableFrom(expectedType)) {
                final Class helperClass = Util.loadClass((String)(expectedType.getName() + "Helper"), (String)codebase, (ClassLoader)expectedType.getClassLoader());
                Method helperNarrow = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return helperClass.getMethod("narrow", Object.class);
                    }
                });
                return (Object)helperNarrow.invoke(null, impl);
            }
            return this.createStub(this.getRMIStubClass(codebase, expectedType), impl._get_delegate());
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InvocationTargetException | PrivilegedActionException ex) {
            logger.log(Level.FINE, "Exception creating object stub", ex);
            MARSHAL m = new MARSHAL("Unable to create stub for class " + expectedType.getName(), 1095974958, CompletionStatus.COMPLETED_NO);
            m.initCause((Throwable)ex);
            throw m;
        }
    }

    private Object createStub(Class<?> stubClass, Delegate delegate) {
        Assert._OB_assert(org.omg.CORBA.portable.ObjectImpl.class.isAssignableFrom(stubClass), "stub class " + stubClass.getName() + " must extend ObjectImpl");
        Class<?> clz = stubClass;
        try {
            org.omg.CORBA.portable.ObjectImpl stub = (org.omg.CORBA.portable.ObjectImpl)clz.newInstance();
            stub._set_delegate(delegate);
            return stub;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            logger.log(Level.FINE, "Exception creating object stub", ex);
            MARSHAL m = new MARSHAL("Unable to create stub for class " + clz.getName(), 1095974958, CompletionStatus.COMPLETED_NO);
            m.initCause((Throwable)ex);
            throw m;
        }
    }

    private String getRMIStubClassName(Class<?> c) {
        String cname = c.getName();
        int idx = cname.lastIndexOf(46);
        return cname.substring(0, idx + 1) + "_" + cname.substring(idx + 1) + "_Stub";
    }

    private Class<? extends org.omg.CORBA.portable.ObjectImpl> getRMIStubClass(String codebase, Class<?> type) throws ClassNotFoundException {
        String name = this.getRMIStubClassName(type);
        ClassLoader cl = type.getClassLoader();
        try {
            return Util.loadClass((String)name, (String)codebase, (ClassLoader)cl);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Util.loadClass((String)("org.omg.stub." + name), (String)codebase, (ClassLoader)cl);
            }
            catch (ClassNotFoundException e2) {
                e2.addSuppressed(e1);
                throw e2;
            }
        }
    }

    public org.omg.CORBA.TypeCode read_TypeCode() {
        this.checkChunk();
        Hashtable history = new Hashtable(11);
        return this.readTypeCodeImpl(history, true);
    }

    public org.omg.CORBA.Any read_any() {
        Any any = new Any(this.orbInstance_);
        any.read_value((org.omg.CORBA.portable.InputStream)this, this.read_TypeCode());
        return any;
    }

    public org.omg.CORBA.Context read_Context() {
        int len = this.read_ulong();
        String[] values = new String[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.read_string();
        }
        return new Context(this.orbInstance_.getORB(), "", values);
    }

    public Principal read_Principal() {
        throw new NO_IMPLEMENT();
    }

    public BigDecimal read_fixed() {
        StringBuffer vBuffer = new StringBuffer("0");
        StringBuffer sBuffer = new StringBuffer();
        boolean first = true;
        while (true) {
            int lo;
            byte b;
            int hi;
            if ((hi = (b = this.read_octet()) >>> 4 & 0xF) > 9) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974936), 1095974936, CompletionStatus.COMPLETED_NO);
            }
            if (!first || hi > 0) {
                vBuffer.append((char)(hi + 48));
            }
            if ((lo = b & 0xF) >= 10) {
                if (lo == 12 || lo == 13) {
                    if (lo != 13) break;
                    sBuffer.append("-");
                    break;
                }
                throw new MARSHAL(MinorCodes.describeMarshal(1095974936), 1095974936, CompletionStatus.COMPLETED_NO);
            }
            vBuffer.append((char)(lo + 48));
            first = false;
        }
        sBuffer.append(vBuffer);
        try {
            return new BigDecimal(sBuffer.toString());
        }
        catch (NumberFormatException ex) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974936), 1095974936, CompletionStatus.COMPLETED_NO);
        }
    }

    public Serializable read_value() {
        return this.valueReader().readValue();
    }

    public Serializable read_value(String id) {
        return this.valueReader().readValue(id);
    }

    public Serializable read_value(Class clz) {
        return this.valueReader().readValue(clz);
    }

    public Serializable read_value(BoxedValueHelper helper) {
        return this.valueReader().readValueBox(helper);
    }

    public Serializable read_value(Serializable value) {
        this.valueReader().initializeValue(value);
        return value;
    }

    public java.lang.Object read_abstract_interface() {
        return this.valueReader().readAbstractInterface();
    }

    public java.lang.Object read_abstract_interface(Class clz) {
        return this.valueReader().readAbstractInterface(clz);
    }

    public void read_value(org.omg.CORBA.Any any, org.omg.CORBA.TypeCode tc) {
        this.valueReader().readValueAny(any, tc);
    }

    public InputStream(Buffer buf, int offs, boolean swap, CodeConverters codeConverters, GiopVersion giopVersion) {
        this.buf_ = buf;
        this.buf_.pos(offs);
        this.swap_ = swap;
        this.origPos_ = offs;
        this.origSwap_ = swap;
        this._OB_codeConverters(codeConverters, giopVersion);
    }

    public InputStream(Buffer buf, int offs, boolean swap) {
        this(buf, offs, swap, null, null);
    }

    public InputStream(Buffer buf) {
        this(buf, 0, false, null, null);
    }

    public void _OB_codeConverters(CodeConverters converters, GiopVersion giopVersion) {
        if (giopVersion != null) {
            this.giopVersion_ = giopVersion;
        }
        this.charReaderRequired_ = false;
        this.charConversionRequired_ = false;
        this.wCharReaderRequired_ = false;
        this.wCharConversionRequired_ = false;
        this.codeConverters_ = new CodeConverters(converters);
        if (converters != null) {
            if (this.codeConverters_.inputCharConverter != null) {
                this.charReaderRequired_ = this.codeConverters_.inputCharConverter.readerRequired();
                this.charConversionRequired_ = this.codeConverters_.inputCharConverter.conversionRequired();
            }
            if (this.codeConverters_.inputWcharConverter != null) {
                this.wCharReaderRequired_ = this.codeConverters_.inputWcharConverter.readerRequired();
                this.wCharConversionRequired_ = this.codeConverters_.inputWcharConverter.conversionRequired();
            }
        }
    }

    public CodeConverters _OB_codeConverters() {
        return this.codeConverters_;
    }

    public Buffer _OB_buffer() {
        return this.buf_;
    }

    public int _OB_pos() {
        return this.buf_.pos_;
    }

    public void _OB_pos(int pos) {
        this.buf_.pos_ = pos;
    }

    public boolean _OB_swap() {
        return this.swap_;
    }

    public void _OB_swap(boolean swap) {
        this.swap_ = swap;
    }

    public InputStream _OB_clone() {
        byte[] data = new byte[this.buf_.len_];
        System.arraycopy(this.buf_.data_, 0, data, 0, this.buf_.len_);
        Buffer buf = new Buffer(data, data.length);
        InputStream result = new InputStream(buf, this.origPos_, this.origSwap_, this.codeConverters_, this.giopVersion_);
        result.orbInstance_ = this.orbInstance_;
        return result;
    }

    public void _OB_reset() {
        this.swap_ = this.origSwap_;
        this.buf_.pos_ = this.origPos_;
    }

    public void _OB_skip(int n) {
        int newPos = this.buf_.pos_ + n;
        if (newPos < this.buf_.pos_ || newPos > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        this.buf_.pos_ = newPos;
    }

    public void _OB_skipAlign(int n) {
        if (this.buf_.pos_ % n != 0) {
            int newPos = this.buf_.pos_ + n - this.buf_.pos_ % n;
            if (newPos < this.buf_.pos_ || newPos > this.buf_.len_) {
                throw new MARSHAL(MinorCodes.describeMarshal(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
            }
            this.buf_.pos_ = newPos;
        }
    }

    public void _OB_readEndian() {
        this.swap_ = this.read_boolean();
    }

    public void _OB_ORBInstance(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
        if (this.orbInstance_ != null && this.orbInstance_.useTypeCodeCache()) {
            this.cache_ = TypeCodeCache.instance();
        }
    }

    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance_;
    }

    public int _OB_readLongUnchecked() {
        int pmod4 = this.buf_.pos_ & 3;
        if (pmod4 != 0) {
            this.buf_.pos_ += 4 - pmod4;
        }
        if (this.buf_.pos_ + 4 > this.buf_.len_) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974920), 1095974920, CompletionStatus.COMPLETED_NO);
        }
        if (this.swap_) {
            return this.buf_.data_[this.buf_.pos_++] & 0xFF | this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00 | this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000 | this.buf_.data_[this.buf_.pos_++] << 24;
        }
        return this.buf_.data_[this.buf_.pos_++] << 24 | this.buf_.data_[this.buf_.pos_++] << 16 & 0xFF0000 | this.buf_.data_[this.buf_.pos_++] << 8 & 0xFF00 | this.buf_.data_[this.buf_.pos_++] & 0xFF;
    }

    public void _OB_beginValue() {
        this.valueReader().beginValue();
    }

    public void _OB_endValue() {
        this.valueReader().endValue();
    }

    public void _OB_remarshalValue(org.omg.CORBA.TypeCode tc, OutputStream out) {
        this.valueReader().remarshalValue(tc, out);
    }

    public void __setSendingContextRuntime(CodeBase runtime) {
        this.sendingContextRuntime_ = runtime;
    }

    public CodeBase __getSendingContextRuntime() {
        return this.sendingContextRuntime_;
    }

    public void __setCodeBase(String codebase) {
        this.codebase_ = codebase;
    }

    public String __getCodeBase() {
        return this.codebase_;
    }

    public String dumpData() {
        return this.buf_.dumpData();
    }

    private void checkChunk() {
        if (this.valueReader_ != null) {
            this.valueReader_.checkChunk();
        }
    }

    public void end_value() {
        this.valueReader().endValue();
    }

    public void start_value() {
        this.valueReader().beginValue();
    }
}

