/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ResponseImpl
extends Response {
    private int status;
    private Object entity;
    private Annotation[] entityAnnotations;
    private MultivaluedMap<String, Object> metadata;
    private Message outMessage;
    private boolean entityClosed;
    private boolean entityBufferred;
    private Object lastEntity;
    static final long serialVersionUID = 8464198698070955731L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ResponseImpl(int s) {
        this.status = s;
    }

    ResponseImpl(int s, Object e) {
        this.status = s;
        this.entity = e;
    }

    public void addMetadata(MultivaluedMap<String, Object> meta) {
        this.metadata = meta;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public void setEntity(Object e, Annotation[] anns) {
        this.entity = e;
        this.entityAnnotations = anns;
    }

    public void setEntityAnnotations(Annotation[] anns) {
        this.entityAnnotations = anns;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setOutMessage(Message message) {
        this.outMessage = message;
    }

    public Message getOutMessage() {
        return this.outMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        return new Response.StatusType(){
            static final long serialVersionUID = 6164500041056610896L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)ResponseImpl.this.status);
            }

            public String getReasonPhrase() {
                Response.Status statusEnum = Response.Status.fromStatusCode((int)ResponseImpl.this.status);
                return statusEnum != null ? statusEnum.getReasonPhrase() : "";
            }

            public int getStatusCode() {
                return ResponseImpl.this.status;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
    }

    public Object getActualEntity() {
        this.checkEntityIsClosed();
        return this.lastEntity != null ? this.lastEntity : this.entity;
    }

    public Object getEntity() {
        return InjectionUtils.getEntity(this.getActualEntity());
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasEntity() {
        Object actualEntity = this.getActualEntity();
        if (actualEntity == null) {
            return false;
        }
        if (actualEntity instanceof InputStream) {
            InputStream is = (InputStream)actualEntity;
            try {
                PushbackInputStream pbis;
                if (is.markSupported()) {
                    is.mark(1);
                    int i = is.read();
                    is.reset();
                    return i != -1;
                }
                try {
                    if (is.available() > 0) {
                        return true;
                    }
                }
                catch (IOException i) {
                    FFDCFilter.processException((Throwable)i, (String)"org.apache.cxf.jaxrs.impl.ResponseImpl", (String)"177", (Object)((Object)this), (Object[])new Object[0]);
                }
                int b = is.read();
                if (b == -1) {
                    return false;
                }
                if (is instanceof PushbackInputStream) {
                    pbis = (PushbackInputStream)is;
                } else {
                    pbis = new PushbackInputStream(is, 1);
                    if (this.lastEntity != null) {
                        this.lastEntity = pbis;
                    } else {
                        this.entity = pbis;
                    }
                }
                pbis.unread(b);
                return true;
            }
            catch (IOException b) {
                void ex;
                FFDCFilter.processException((Throwable)b, (String)"org.apache.cxf.jaxrs.impl.ResponseImpl", (String)"197", (Object)((Object)this), (Object[])new Object[0]);
                throw new ProcessingException((Throwable)ex);
            }
        }
        return true;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.getHeaders();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.metadata;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        MetadataMap headers = new MetadataMap(this.metadata.size());
        for (Map.Entry entry : this.metadata.entrySet()) {
            String headerName = (String)entry.getKey();
            headers.put((Object)headerName, this.toListOfStrings(headerName, (List)entry.getValue()));
        }
        return headers;
    }

    public String getHeaderString(String header) {
        List methodValues = (List)this.metadata.get((Object)header);
        return HttpUtils.getHeaderString(this.toListOfStrings(header, methodValues));
    }

    private List<String> toListOfStrings(String headerName, List<Object> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        RuntimeDelegate.HeaderDelegate<Object> hd = HttpUtils.getHeaderDelegate(values.get(0));
        for (Object value : values) {
            String actualValue = hd == null ? value.toString() : hd.toString(value);
            stringValues.add(actualValue);
        }
        return stringValues;
    }

    public Set<String> getAllowedMethods() {
        List methodValues = (List)this.metadata.get((Object)"Allow");
        if (methodValues == null) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (Object o : methodValues) {
            methods.add(o.toString());
        }
        return methods;
    }

    public Map<String, NewCookie> getCookies() {
        List cookieValues = (List)this.metadata.get((Object)"Set-Cookie");
        if (cookieValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object o : cookieValues) {
            NewCookie newCookie = NewCookie.valueOf((String)o.toString());
            cookies.put(newCookie.getName(), newCookie);
        }
        return cookies;
    }

    public Date getDate() {
        return this.doGetDate("Date");
    }

    private Date doGetDate(String dateHeader) {
        Object value = this.metadata.getFirst((Object)dateHeader);
        return value == null || value instanceof Date ? (Date)value : HttpUtils.getHttpDate(value.toString());
    }

    public EntityTag getEntityTag() {
        Object header = this.metadata.getFirst((Object)"ETag");
        return header == null || header instanceof EntityTag ? (EntityTag)header : EntityTag.valueOf((String)header.toString());
    }

    public Locale getLanguage() {
        Object header = this.metadata.getFirst((Object)"Content-Language-Cxf");
        return header == null || header instanceof Locale ? (Locale)header : HttpUtils.getLocale(header.toString());
    }

    public Date getLastModified() {
        return this.doGetDate("Last-Modified");
    }

    public int getLength() {
        Object header = this.metadata.getFirst((Object)"Content-Length");
        return HttpUtils.getContentLength(header == null ? null : header.toString());
    }

    public URI getLocation() {
        Object header = this.metadata.getFirst((Object)"Location");
        return header == null || header instanceof URI ? (URI)header : URI.create(header.toString());
    }

    public MediaType getMediaType() {
        Object header = this.metadata.getFirst((Object)"Content-Type");
        return header == null || header instanceof MediaType ? (MediaType)header : JAXRSUtils.toMediaType(header.toString());
    }

    public boolean hasLink(String relation) {
        List linkValues = (List)this.metadata.get((Object)"Link");
        if (linkValues != null) {
            for (Object o : linkValues) {
                Link link = o instanceof Link ? (Link)o : Link.valueOf((String)o.toString());
                if (!relation.equals(link.getRel())) continue;
                return true;
            }
        }
        return false;
    }

    public Link getLink(String relation) {
        for (Link link : this.getLinks()) {
            String rel = link.getRel();
            if (rel == null || !rel.contains(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        return link == null ? null : Link.fromLink((Link)link);
    }

    public Set<Link> getLinks() {
        List linkValues = (List)this.metadata.get((Object)"Link");
        if (linkValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Link> links = new LinkedHashSet<Link>();
        for (Object o : linkValues) {
            Link link;
            Link link2 = link = o instanceof Link ? (Link)o : Link.valueOf((String)o.toString());
            if (!link.getUri().isAbsolute()) {
                URI requestURI = URI.create((String)this.outMessage.get((Object)"org.apache.cxf.request.uri"));
                link = Link.fromLink((Link)link).baseUri(requestURI).build(new Object[0]);
            }
            links.add(link);
        }
        return links;
    }

    public <T> T readEntity(Class<T> cls) throws ProcessingException, IllegalStateException {
        return this.readEntity(cls, new Annotation[0]);
    }

    public <T> T readEntity(GenericType<T> genType) throws ProcessingException, IllegalStateException {
        return this.readEntity(genType, new Annotation[0]);
    }

    public <T> T readEntity(Class<T> cls, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return this.doReadEntity(cls, cls, anns, true);
    }

    public <T> T readEntity(GenericType<T> genType, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return this.doReadEntity(genType.getRawType(), genType.getType(), anns, true);
    }

    public <T> T doReadEntity(Class<T> cls, Type t, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return this.doReadEntity(cls, t, anns, false);
    }

    @FFDCIgnore(value={NoContentException.class, Exception.class})
    public <T> T doReadEntity(Class<T> cls, Type t, Annotation[] anns, boolean closeAfterRead) throws ProcessingException, IllegalStateException {
        List<ReaderInterceptor> readers;
        boolean shouldClose;
        this.checkEntityIsClosed();
        boolean bl = shouldClose = !this.entityBufferred;
        if (this.lastEntity != null && cls.isAssignableFrom(this.lastEntity.getClass()) && !(this.lastEntity instanceof InputStream)) {
            return cls.cast(this.lastEntity);
        }
        MediaType mediaType = this.getMediaType();
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        boolean entityStreamAvailable = this.entityStreamAvailable();
        InputStream entityStream = null;
        if (!entityStreamAvailable) {
            entityStream = this.convertEntityToStreamIfPossible();
            entityStreamAvailable = entityStream != null;
        } else if (this.entity instanceof InputStream) {
            entityStream = (InputStream)InputStream.class.cast(this.entity);
        }
        List<ReaderInterceptor> list = readers = this.outMessage == null ? null : ProviderFactory.getInstance(this.outMessage).createMessageBodyReaderInterceptor(cls, t, anns, mediaType, this.outMessage, entityStreamAvailable, null);
        if (readers != null) {
            try {
                if (this.entityBufferred) {
                    ((InputStream)InputStream.class.cast(this.entity)).reset();
                }
                Message responseMessage = this.getResponseMessage();
                responseMessage.put((Object)Message.PROTOCOL_HEADERS, this.getHeaders());
                this.lastEntity = JAXRSUtils.readFromMessageBodyReader(readers, cls, t, anns, entityStream, mediaType, responseMessage);
                T tCastLastEntity = this.castLastEntity();
                boolean bl2 = shouldClose = shouldClose && !(tCastLastEntity instanceof Closeable) && !(tCastLastEntity instanceof Source);
                if (closeAfterRead && shouldClose) {
                    this.close();
                }
                return tCastLastEntity;
            }
            catch (NoContentException ex) {
                if (ResponseImpl.isBasicType(cls)) {
                    this.autoClose(cls, true);
                    this.reportMessageHandlerProblem("MSG_READER_PROBLEM", cls, mediaType, ex);
                }
                if (closeAfterRead && shouldClose) {
                    this.close();
                }
                return null;
            }
            catch (Exception ex) {
                this.autoClose(cls, true);
                this.reportMessageHandlerProblem("MSG_READER_PROBLEM", cls, mediaType, ex);
            }
        } else {
            if (this.entity != null && cls.isAssignableFrom(this.entity.getClass())) {
                this.lastEntity = this.entity;
                return this.castLastEntity();
            }
            if (entityStreamAvailable) {
                this.reportMessageHandlerProblem("NO_MSG_READER", cls, mediaType, null);
            }
        }
        throw new IllegalStateException("The entity is not backed by an input stream, entity class is : " + (this.entity != null ? this.entity.getClass().getName() : cls.getName()));
    }

    private <T> T castLastEntity() {
        return (T)this.lastEntity;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream convertEntityToStreamIfPossible() {
        String stringEntity = null;
        if (this.entity instanceof String || this.entity instanceof Number) {
            stringEntity = this.entity.toString();
        }
        if (stringEntity != null) {
            try {
                return new ByteArrayInputStream(stringEntity.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.impl.ResponseImpl", (String)"546", (Object)((Object)this), (Object[])new Object[0]);
                throw new ProcessingException((Throwable)ex);
            }
        }
        return null;
    }

    private boolean entityStreamAvailable() {
        if (this.entity == null) {
            Message inMessage = this.getResponseMessage();
            return inMessage != null && (inMessage.getContent(XMLStreamReader.class) != null || inMessage.getContent(Reader.class) != null);
        }
        return this.entity instanceof InputStream;
    }

    private Message getResponseMessage() {
        Message responseMessage = this.outMessage.getExchange().getInMessage();
        if (responseMessage == null) {
            responseMessage = this.outMessage.getExchange().getInFaultMessage();
        }
        return responseMessage;
    }

    private void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable cause) {
        String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
        throw new ResponseProcessingException((Response)this, errorMessage, cause);
    }

    protected void autoClose(Class<?> cls, boolean exception) {
        if (!this.entityBufferred && !JAXRSUtils.isStreamingOutType(cls) && (exception || MessageUtils.isTrue((Object)this.outMessage.getContextualProperty("response.stream.auto.close")))) {
            this.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean bufferEntity() throws ProcessingException {
        this.checkEntityIsClosed();
        if (!this.entityBufferred && this.entity instanceof InputStream) {
            try {
                InputStream oldEntity = (InputStream)this.entity;
                this.entity = IOUtils.loadIntoBAIS((InputStream)oldEntity);
                oldEntity.close();
                this.entityBufferred = true;
            }
            catch (IOException oldEntity) {
                void ex;
                FFDCFilter.processException((Throwable)oldEntity, (String)"org.apache.cxf.jaxrs.impl.ResponseImpl", (String)"593", (Object)((Object)this), (Object[])new Object[0]);
                throw new ResponseProcessingException((Response)this, (Throwable)ex);
            }
        }
        return this.entityBufferred;
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws ProcessingException {
        if (!this.entityClosed) {
            if (!this.entityBufferred && this.entity instanceof InputStream) {
                try {
                    ((InputStream)this.entity).close();
                }
                catch (IOException iOException) {
                    void ex;
                    FFDCFilter.processException((Throwable)iOException, (String)"org.apache.cxf.jaxrs.impl.ResponseImpl", (String)"606", (Object)((Object)this), (Object[])new Object[0]);
                    throw new ResponseProcessingException((Response)this, (Throwable)ex);
                }
            }
            this.entity = null;
            this.entityClosed = true;
        }
    }

    private void checkEntityIsClosed() {
        if (this.entityClosed) {
            throw new IllegalStateException("Entity is not available");
        }
    }

    private static boolean isBasicType(Class type) {
        if (PrimitiveTypes.forType(type) != null) {
            return true;
        }
        return Number.class.isAssignableFrom(type);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResponseImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class PrimitiveTypes
    extends Enum<PrimitiveTypes> {
        public static final /* enum */ PrimitiveTypes BYTE;
        public static final /* enum */ PrimitiveTypes SHORT;
        public static final /* enum */ PrimitiveTypes INTEGER;
        public static final /* enum */ PrimitiveTypes LONG;
        public static final /* enum */ PrimitiveTypes FLOAT;
        public static final /* enum */ PrimitiveTypes DOUBLE;
        public static final /* enum */ PrimitiveTypes BOOLEAN;
        public static final /* enum */ PrimitiveTypes CHAR;
        private final Class<?> wrapper;
        private final Class<?> primitive;
        private static final /* synthetic */ PrimitiveTypes[] $VALUES;
        static final long serialVersionUID = -8883327056966786570L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static PrimitiveTypes[] values() {
            return (PrimitiveTypes[])$VALUES.clone();
        }

        public static PrimitiveTypes valueOf(String name) {
            return Enum.valueOf(PrimitiveTypes.class, name);
        }

        public static PrimitiveTypes forType(Class<?> type) {
            for (PrimitiveTypes primitive : PrimitiveTypes.values()) {
                if (!primitive.supports(type)) continue;
                return primitive;
            }
            return null;
        }

        private PrimitiveTypes(Class<?> wrapper, Class<?> primitive) {
            this.wrapper = wrapper;
            this.primitive = primitive;
        }

        public boolean supports(Class<?> type) {
            return type == this.wrapper || type == this.primitive;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PrimitiveTypes.class);
            BYTE = new PrimitiveTypes((Class)Byte.class, (Class)Byte.TYPE){
                static final long serialVersionUID = -4027504790959358800L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            SHORT = new PrimitiveTypes((Class)Short.class, (Class)Short.TYPE){
                static final long serialVersionUID = -9140014559337529387L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            };
            INTEGER = new PrimitiveTypes((Class)Integer.class, (Class)Integer.TYPE){
                static final long serialVersionUID = -6591247487404738508L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            };
            LONG = new PrimitiveTypes((Class)Long.class, (Class)Long.TYPE){
                static final long serialVersionUID = 5357207030051322003L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            };
            FLOAT = new PrimitiveTypes((Class)Float.class, (Class)Float.TYPE){
                static final long serialVersionUID = 4898773924257177230L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class);
                }
            };
            DOUBLE = new PrimitiveTypes((Class)Double.class, (Class)Double.TYPE){
                static final long serialVersionUID = -3043982046282061006L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(6.class);
                }
            };
            BOOLEAN = new PrimitiveTypes((Class)Boolean.class, (Class)Boolean.TYPE){
                static final long serialVersionUID = 1100027528681457043L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(7.class);
                }
            };
            CHAR = new PrimitiveTypes((Class)Character.class, (Class)Character.TYPE){
                static final long serialVersionUID = 2416552978814535831L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(8.class);
                }
            };
            $VALUES = new PrimitiveTypes[]{BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BOOLEAN, CHAR};
        }
    }
}

