/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.metadata.JaxRsClientMetaData;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.metadata.JaxRsServerMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxRsMetaDataManager {
    private static final TraceComponent tc = Tr.register(JaxRsMetaDataManager.class);
    public static MetaDataSlot jaxrsApplicationSlot = null;
    public static MetaDataSlot jaxrsModuleSlot = null;
    public static MetaDataSlot jaxrsComponentSlot = null;
    static final long serialVersionUID = -1636171103518072735L;

    public static void setJaxRsModuleMetaData(ModuleMetaData mmd, JaxRsModuleMetaData moduleMetaData) {
        if (mmd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting ModuleMetaData on ModuleMetaData instance: " + mmd), (Object[])new Object[0]);
            }
            mmd.setMetaData(jaxrsModuleSlot, (Object)moduleMetaData);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not set ModuleMetaData because ModuleMetaData is null", (Object[])new Object[0]);
        }
    }

    public static JaxRsModuleMetaData getJaxRsModuleMetaData(ModuleMetaData mmd) {
        if (mmd != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting JaxWs module metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            return (JaxRsModuleMetaData)mmd.getMetaData(jaxrsModuleSlot);
        }
        return null;
    }

    public static JaxRsModuleMetaData getJaxRsModuleMetaData() {
        return JaxRsMetaDataManager.getJaxRsModuleMetaData(JaxRsMetaDataManager.getModuleMetaData());
    }

    public static JaxRsClientMetaData getJaxWsClientMetaData(ModuleMetaData mmd) {
        JaxRsClientMetaData clientMetaData = null;
        if (mmd != null) {
            JaxRsModuleMetaData moduleMetaData;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting client metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            if ((moduleMetaData = (JaxRsModuleMetaData)mmd.getMetaData(jaxrsModuleSlot)) != null) {
                // empty if block
            }
        }
        return clientMetaData;
    }

    public static JaxRsServerMetaData getJaxWsServerMetaData(ModuleMetaData mmd) {
        JaxRsServerMetaData serverMetaData = null;
        if (mmd != null) {
            JaxRsModuleMetaData moduleMetaData;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting client metadata from module metadata instance: " + mmd), (Object[])new Object[0]);
            }
            if ((moduleMetaData = (JaxRsModuleMetaData)mmd.getMetaData(jaxrsModuleSlot)) != null) {
                serverMetaData = moduleMetaData.getServerMetaData();
            }
        }
        return serverMetaData;
    }

    public static JaxRsClientMetaData getJaxWsClientMetaData() {
        ModuleMetaData mmd = JaxRsMetaDataManager.getModuleMetaData();
        return JaxRsMetaDataManager.getJaxWsClientMetaData(mmd);
    }

    public static ModuleMetaData getModuleMetaData() {
        ComponentMetaData cmd = JaxRsMetaDataManager.getComponentMetaData();
        ModuleMetaData mmd = null;
        if (cmd != null) {
            mmd = cmd.getModuleMetaData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ModuleMetaData object is " + (mmd != null ? mmd.toString() : "null!")), (Object[])new Object[0]);
        }
        return mmd;
    }

    public static ComponentMetaData getComponentMetaData() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        return cmd;
    }
}

