/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.weld.BeanDeploymentArchiveImpl;
import com.ibm.ws.cdi.impl.weld.OnDemandArchive;
import com.ibm.ws.cdi.impl.weld.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.impl.weld.WebSphereCDIDeployment;
import com.ibm.ws.cdi.interfaces.ArchiveType;
import com.ibm.ws.cdi.interfaces.CDIArchive;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.cdi.interfaces.ExtensionArchive;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BDAFactory {
    private static ConcurrentHashMap<String, Set<String>> runtimeBDAClasses;
    static final long serialVersionUID = 363837286541555643L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static WebSphereBeanDeploymentArchive createBDA(WebSphereCDIDeployment deployment, String archiveID, CDIArchive archive, CDIRuntime cdiRuntime) throws CDIException {
        return BDAFactory.createBDA(deployment, archiveID, archive, cdiRuntime, null);
    }

    public static WebSphereBeanDeploymentArchive createBDA(WebSphereCDIDeployment deployment, String archiveID, CDIArchive archive, CDIRuntime cdiRuntime, String eEModuleDescriptorId) throws CDIException {
        Set<String> additionalClasses = Collections.emptySet();
        Set<String> additionalAnnotations = Collections.emptySet();
        WebSphereBeanDeploymentArchive bda = BDAFactory.createBDA(deployment, archiveID, archive, cdiRuntime, additionalClasses, additionalAnnotations, false, false, eEModuleDescriptorId);
        return bda;
    }

    public static WebSphereBeanDeploymentArchive createBDA(WebSphereCDIDeployment deployment, ExtensionArchive extensionArchive, CDIRuntime cdiRuntime) throws CDIException {
        Set<String> additionalClasses = extensionArchive.getExtraClasses();
        Set<String> additionalAnnotations = extensionArchive.getExtraBeanDefiningAnnotations();
        boolean extensionCanSeeApplicationBDAs = extensionArchive.applicationBDAsVisible();
        boolean extClassesOnlyBDA = extensionArchive.isExtClassesOnly();
        String archiveID = deployment.getDeploymentID() + "#" + extensionArchive.getName() + ".additionalClasses";
        WebSphereBeanDeploymentArchive bda = BDAFactory.createBDA(deployment, archiveID, extensionArchive, cdiRuntime, additionalClasses, additionalAnnotations, extensionCanSeeApplicationBDAs, extClassesOnlyBDA, null);
        return bda;
    }

    public static WebSphereBeanDeploymentArchive createBDA(WebSphereCDIDeployment deployment, OnDemandArchive onDemandArchive, CDIRuntime cdiRuntime) throws CDIException {
        String archiveID = deployment.getDeploymentID() + "#" + onDemandArchive.getName() + ".additionalClasses";
        return BDAFactory.createBDA(deployment, archiveID, onDemandArchive, cdiRuntime);
    }

    private static WebSphereBeanDeploymentArchive createBDA(WebSphereCDIDeployment deployment, String archiveID, CDIArchive archive, CDIRuntime cdiRuntime, Set<String> additionalClasses, Set<String> additionalBeanDefiningAnnotations, boolean extensionCanSeeApplicationBDAs, boolean extensionClassesOnlyBDA, String eEModuleDescriptorId) throws CDIException {
        Set<String> extensionClassNames = archive.getExtensionClasses();
        HashSet<String> allClassNames = new HashSet<String>();
        if (archive.getType() == ArchiveType.RUNTIME_EXTENSION) {
            if (extensionClassesOnlyBDA) {
                allClassNames.addAll(extensionClassNames);
            } else {
                String key = archive.getName();
                Set<String> clazzes = runtimeBDAClasses.get(key);
                if (clazzes == null) {
                    clazzes = archive.getClassNames();
                    Set<String> result = runtimeBDAClasses.putIfAbsent(key, clazzes);
                    if (result == null) {
                        result = clazzes;
                    }
                    allClassNames.addAll(result);
                } else {
                    allClassNames.addAll(clazzes);
                }
            }
        } else {
            allClassNames.addAll(archive.getClassNames());
        }
        return new BeanDeploymentArchiveImpl(deployment, archiveID, archive, cdiRuntime, allClassNames, additionalClasses, additionalBeanDefiningAnnotations, extensionCanSeeApplicationBDAs, extensionClassNames, eEModuleDescriptorId);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BDAFactory.class);
        runtimeBDAClasses = new ConcurrentHashMap();
    }
}

