/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.managedobject;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.impl.managedobject.CDIManagedObjectState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CDIManagedObject<T>
implements ManagedObject<T> {
    private static final TraceComponent tc = Tr.register(CDIManagedObject.class);
    private T managedObject;
    private WeldCreationalContext<T> creationalContext = null;
    private InjectionTarget<T> injectionTarget = null;
    private boolean lifecycleManaged = false;
    private String beanScope = null;
    private final String identity;
    static final long serialVersionUID = -9126917678523682896L;

    public CDIManagedObject(T managedObject, WeldCreationalContext<T> creationalContext, String beanScope) {
        this.creationalContext = creationalContext;
        this.managedObject = managedObject;
        this.beanScope = beanScope;
        this.identity = Util.identity(this.managedObject);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.identity + " creating --> " + Util.identity(this.creationalContext) + " beanscope: " + beanScope), (Object[])new Object[0]);
        }
    }

    public CDIManagedObject(T managedObject, WeldCreationalContext<T> creationalContext, InjectionTarget<T> injectionTarget, String beanScope) {
        this(managedObject, creationalContext, beanScope);
        this.injectionTarget = injectionTarget;
        this.lifecycleManaged = this.injectionTarget != null;
    }

    public <K> K getContextData(Class<K> klass) {
        if (klass == WeldCreationalContext.class) {
            return klass.cast(this.creationalContext);
        }
        return null;
    }

    public T getObject() {
        return this.managedObject;
    }

    public ManagedObjectContext getContext() {
        return new CDIManagedObjectState(this.creationalContext);
    }

    /*
     * WARNING - void declaration
     */
    public void release() {
        if (null != this.creationalContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.identity + " releasing --> " + Util.identity(this.creationalContext)), (Object[])new Object[0]);
            }
            if (this.injectionTarget != null) {
                block5: {
                    try {
                        this.injectionTarget.preDestroy(this.managedObject);
                    }
                    catch (Throwable throwable) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.cdi.impl.managedobject.CDIManagedObject", (String)"76", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)(this.identity + " preDestroy exception --> " + t), (Object[])new Object[0]);
                    }
                }
                this.injectionTarget.dispose(this.managedObject);
                this.injectionTarget = null;
            }
            this.creationalContext.release();
            this.creationalContext = null;
            this.managedObject = null;
        }
    }

    public boolean isLifecycleManaged() {
        return this.lifecycleManaged;
    }

    public String getBeanScope() {
        return this.beanScope;
    }

    public String toString() {
        String released = this.creationalContext == null ? " (RELEASED)" : "";
        return "CDIManagedObject: " + this.identity + released;
    }
}

