/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.ApplicationSignatureFlexHandler;
import com.ibm.ws.sib.processor.matching.ConsumerFlexHandler;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatchTarget;
import com.ibm.ws.sib.processor.matching.NeighbourFlexHandler;
import com.ibm.ws.sib.processor.matching.SubscriptionFlexHandler;
import com.ibm.ws.sib.processor.matching.TopicAclFlexHandler;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MessageProcessorSearchResults
implements SearchResults {
    private static final TraceComponent tc = SibTr.register(MessageProcessorSearchResults.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected Object[] finalResults;
    protected Object[] cachedResults;
    protected boolean postProcessed = false;
    protected List matchingPSOHs;
    protected boolean generatedMatchingPSOHs = false;
    protected static final Handler[] handlers = new Handler[5];
    private DestinationHandler destinationHandler;

    public MessageProcessorSearchResults(TopicAuthorization authorization) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorSearchResults", (Object)authorization);
        }
        this.finalResults = new Object[5];
        for (int i = 0; i < 5; ++i) {
            if (handlers[i] != null) {
                this.finalResults[i] = handlers[i].initResult();
                handlers[i].setAuthorization(authorization);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"MessageProcessorSearchResults", (Object)("No flex handler for " + MessageProcessorMatchTarget.TARGET_NAMES[i]));
            }
            this.finalResults[i] = null;
        }
        this.cachedResults = null;
        this.destinationHandler = null;
        this.matchingPSOHs = new ArrayList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorSearchResults", (Object)this);
        }
    }

    public void addObjects(List[] objs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addObjects");
        }
        if (objs.length > 5) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addObjects", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null || handlers[i] == null) continue;
            handlers[i].processIntermediateMatches(objs[i], this.finalResults[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addObjects");
        }
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this.finalResults != null) {
            for (int i = 0; i < 5; ++i) {
                if (handlers[i] == null) continue;
                handlers[i].resetResult(this.finalResults[i]);
            }
        } else {
            this.finalResults = new Object[5];
            for (int i = 0; i < 5; ++i) {
                this.finalResults[i] = handlers[i] != null ? handlers[i].initResult() : null;
            }
        }
        this.cachedResults = null;
        this.postProcessed = false;
        this.destinationHandler = null;
        this.matchingPSOHs.clear();
        this.generatedMatchingPSOHs = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public Object provideCacheable(Object rootVal) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"provideCacheable", (Object)rootVal);
        }
        this.postProcess((String)rootVal);
        this.cachedResults = this.finalResults;
        this.finalResults = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"provideCacheable", (Object)this.cachedResults);
        }
        return this.cachedResults;
    }

    public boolean acceptCacheable(Object cached) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"acceptCacheable", (Object)cached);
        }
        boolean result = false;
        if (cached instanceof Object[]) {
            this.cachedResults = (Object[])cached;
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"acceptCacheable", (Object)("result: " + new Boolean(result)));
        }
        return result;
    }

    public Object[] getResults(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getResults", (Object)topic);
        }
        if (this.cachedResults != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getResults", (Object)this.cachedResults);
            }
            return this.cachedResults;
        }
        this.postProcess(topic);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getResults", (Object)("finalResults: " + Arrays.toString(this.finalResults)));
        }
        return this.finalResults;
    }

    public Set getConsumerDispatchers(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatchers", (Object)topic);
        }
        Object[] allResults = this.getResults(topic);
        Set matchingConsumerDispatchers = (Set)allResults[1];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatchers", (Object)matchingConsumerDispatchers);
        }
        return matchingConsumerDispatchers;
    }

    public List getPubSubOutputHandlers(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutputHandlers", (Object)topic);
        }
        if (!this.generatedMatchingPSOHs) {
            Object[] allResults = this.getResults(topic);
            this.generateMatchingPSOHs(allResults);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutputHandlers", (Object)this.matchingPSOHs);
        }
        return this.matchingPSOHs;
    }

    protected void postProcess(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postProcess", (Object)topic);
        }
        if (!this.postProcessed) {
            for (int i = 0; i < this.finalResults.length; ++i) {
                if (handlers[i] == null) continue;
                handlers[i].postProcessMatches(this.destinationHandler, topic, this.finalResults, i);
            }
            this.postProcessed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postProcess");
        }
    }

    protected void postProcess(int matchType, String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postProcess", (Object)new Object[]{new Integer(matchType), topic});
        }
        handlers[matchType].postProcessMatches(this.destinationHandler, topic, this.finalResults, matchType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postProcess");
        }
    }

    protected void generateMatchingPSOHs(Object[] theResults) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateMatchingPSOHs");
        }
        if (!this.generatedMatchingPSOHs) {
            Set wrappedOutputHandlers = (Set)theResults[3];
            Iterator i = wrappedOutputHandlers.iterator();
            while (i.hasNext()) {
                PubSubOutputHandler psoh = (PubSubOutputHandler)((ControllableProxySubscription)i.next()).getOutputHandler();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found pubsuboutputhandler: " + psoh));
                }
                this.matchingPSOHs.add(psoh);
            }
            this.generatedMatchingPSOHs = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateMatchingPSOHs");
        }
    }

    public void setTopicSpace(DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTopicSpace", (Object)dh);
        }
        this.destinationHandler = dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTopicSpace");
        }
    }

    public String toString() {
        StringBuffer buffer;
        block3: {
            block2: {
                buffer = new StringBuffer();
                if (this.finalResults == null) break block2;
                buffer.append("final: ");
                for (int i = 0; i < 5; ++i) {
                    if (handlers[i] == null) continue;
                    buffer.append(handlers[i].toString(this.finalResults, i));
                }
                break block3;
            }
            if (this.cachedResults == null) break block3;
            buffer.append("cached: ");
            for (int i = 0; i < 5; ++i) {
                if (handlers[i] == null) continue;
                buffer.append(handlers[i].toString(this.cachedResults, i));
            }
        }
        return buffer.toString();
    }

    static {
        MessageProcessorSearchResults.handlers[1] = new SubscriptionFlexHandler();
        MessageProcessorSearchResults.handlers[2] = new ConsumerFlexHandler();
        MessageProcessorSearchResults.handlers[3] = new NeighbourFlexHandler();
        MessageProcessorSearchResults.handlers[0] = new TopicAclFlexHandler();
        MessageProcessorSearchResults.handlers[4] = new ApplicationSignatureFlexHandler();
    }

    public static interface Handler {
        public Object initResult();

        public void resetResult(Object var1);

        public void processIntermediateMatches(List var1, Object var2);

        public void postProcessMatches(DestinationHandler var1, String var2, Object[] var3, int var4);

        public void setAuthorization(TopicAuthorization var1);

        public String toString(Object[] var1, int var2);
    }
}

