/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsRecoveryMessagingEngine;
import com.ibm.ws.sib.admin.MQLinkDefinition;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.comms.mq.MQLinkObject;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.WASConfiguration;
import com.ibm.ws.sib.processor.RecoveryProcessor;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageProcessorCorruptException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.store.MessageProcessorStore;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.wsspi.sib.core.DestinationType;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RecoveryProcessorImpl
implements RecoveryProcessor {
    MessageStore msgStore;
    MessageProcessorStore _persistentStore;
    private String busName;
    private String meUUId;
    DestinationManager destinationManager;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public synchronized HashMap<String, ArrayList<DestinationDefinition>> recoverSIBusDestinations() throws Exception {
        ArrayList<DestinationDefinition> destForeign;
        ArrayList<DestinationDefinition> destAlias;
        ArrayList<DestinationDefinition> destTopicSpaces;
        ArrayList<DestinationDefinition> destQueues;
        NonLockingCursor cursor;
        HashMap<String, ArrayList<DestinationDefinition>> destinationsMap = new HashMap<String, ArrayList<DestinationDefinition>>();
        if (this._persistentStore != null) {
            this.destinationManager = (DestinationManager)this._persistentStore.findFirstMatchingItemStream(new ClassEqualsFilter(DestinationManager.class));
            if (null == this.destinationManager) {
                SIMPMessageProcessorCorruptException e = new SIMPMessageProcessorCorruptException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.RecoveryProcessorImpl", "1:2284:1.443"}, null));
                throw e;
            }
            cursor = this.initializeDestinationManagerDestinations(this.destinationManager);
            AbstractItem item = null;
            destQueues = new ArrayList<DestinationDefinition>();
            destTopicSpaces = new ArrayList<DestinationDefinition>();
            destAlias = new ArrayList<DestinationDefinition>();
            destForeign = new ArrayList<DestinationDefinition>();
            while (null != (item = cursor.next())) {
                BaseDestinationHandler dh = (BaseDestinationHandler)item;
                DestinationDefinition def = dh.definition;
                DestinationType type = DestinationType.getDestinationType((int)def.getDestinationType().toInt());
                if (type.toString().equalsIgnoreCase("Queue")) {
                    if (def.getName().endsWith(this.meUUId) && def.getName().startsWith("_P")) continue;
                    destQueues.add(def);
                    continue;
                }
                if (type.toString().equalsIgnoreCase("TopicSpace")) {
                    destTopicSpaces.add(def);
                    continue;
                }
                if (type.toString().equalsIgnoreCase("Alias")) {
                    destAlias.add(def);
                    continue;
                }
                if (!type.toString().equalsIgnoreCase("Foreign")) continue;
                destForeign.add(def);
            }
        } else {
            throw new MessageStoreException("Invalid Message store because MessageProcessorStore instance is null.");
        }
        cursor.finished();
        destinationsMap.put("QUEUE", destQueues);
        destinationsMap.put("TOPICSPACE", destTopicSpaces);
        destinationsMap.put("ALIAS", destAlias);
        destinationsMap.put("FOREIGN", destForeign);
        return destinationsMap;
    }

    public void startMessageDataStore(JsRecoveryMessagingEngine recoveryME, String jndiName, String authDataAlias, String schemaName) throws Exception {
        WASConfiguration configuration = WASConfiguration.getDefaultWasConfiguration();
        configuration.setCleanPersistenceOnStart(false);
        configuration.setCreateTablesAutomatically(false);
        configuration.setPersistentMessageStoreClassname("com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl");
        configuration.setDatasourceJndiName(jndiName);
        configuration.setAuthenticationAlias(authDataAlias);
        configuration.setDatabaseSchemaName(schemaName);
        this.busName = recoveryME.getBusName();
        this.msgStore = MessageStore.createInstance();
        String fullkey = "sib.msgstore.STARTMODE";
        this.msgStore.setCustomProperty(fullkey, "RECOVERY");
        this.msgStore.initialize((Configuration)configuration);
        this.msgStore.initialize(recoveryME, "recovery");
        this.msgStore.start();
        this._persistentStore = (MessageProcessorStore)this.msgStore.findFirstMatching((Filter)new ClassEqualsFilter(MessageProcessorStore.class));
        this.meUUId = this._persistentStore.getMessagingEngineUuid().toString();
    }

    public List<MQLinkDefinition> recoverSIBusMQLinks() throws Exception {
        ArrayList<MQLinkDefinition> mqLinks = new ArrayList<MQLinkDefinition>();
        if (this.msgStore != null) {
            NonLockingCursor cursor = this.initializeDestinationManagerMQLinks(this.destinationManager);
            AbstractItem item = null;
            while (null != (item = cursor.next())) {
                MQLinkHandler mqLink = (MQLinkHandler)item;
                if (mqLink == null) continue;
                MQLinkObject def = mqLink.getMQLinkObject();
                if (def != null) {
                    def.toString();
                }
                DataSlice slice = mqLink.getPersistentData().get(0);
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(slice.getBytes()));
                mqLink.restore(ois, ois.readInt());
            }
            cursor.finished();
        }
        return mqLinks;
    }

    public List<VirtualLinkDefinition> recoverSIBusVirtualLinks() throws Exception {
        NonLockingCursor cursor = this.initializeDestinationManagerSIBLinks(this.destinationManager);
        AbstractItem item = null;
        ArrayList<VirtualLinkDefinition> linkDefs = new ArrayList<VirtualLinkDefinition>();
        while (null != (item = cursor.next())) {
            LinkHandler linkHandler = null;
            linkHandler = (LinkHandler)item;
            if (linkHandler.isToBeIgnored()) continue;
            linkHandler.restore(linkHandler.getPersistentData());
        }
        cursor.finished();
        return linkDefs;
    }

    public void startMessageFileStore(JsRecoveryMessagingEngine recoveryME, String logDirectory, String permLogDirectory, String tempLogDirectory) throws Exception {
        WASConfiguration configuration = WASConfiguration.getDefaultWasConfiguration();
        configuration.setCleanPersistenceOnStart(false);
        configuration.setCreateTablesAutomatically(false);
        configuration.setPersistentMessageStoreClassname("com.ibm.ws.sib.msgstore.persistence.objectManager.PersistentMessageStoreImpl");
        configuration.setObjectManagerLogDirectory(logDirectory);
        configuration.setObjectManagerPermanentStoreDirectory(permLogDirectory);
        configuration.setObjectManagerTemporaryStoreDirectory(tempLogDirectory);
        configuration.setCreateTablesAutomatically(false);
        this.busName = recoveryME.getBusName();
        this.msgStore = MessageStore.createInstance();
        String fullkey = "sib.msgstore.STARTMODE";
        this.msgStore.setCustomProperty(fullkey, "RECOVERY");
        this.msgStore.initialize((Configuration)configuration);
        this.msgStore.initialize(recoveryME, "recovery");
        this.msgStore.start();
        this._persistentStore = (MessageProcessorStore)this.msgStore.findFirstMatching((Filter)new ClassEqualsFilter(MessageProcessorStore.class));
        this.meUUId = this._persistentStore.getMessagingEngineUuid().toString();
    }

    public void stopMessageStore() throws Exception {
        this.msgStore.stop(0);
    }

    public String getMEUUID() throws Exception {
        return this.meUUId;
    }

    private NonLockingCursor initializeDestinationManagerDestinations(DestinationManager destinationManager) throws MessageStoreException {
        return destinationManager.newNonLockingItemStreamCursor(new ClassEqualsFilter(BaseDestinationHandler.class));
    }

    private NonLockingCursor initializeDestinationManagerSIBLinks(DestinationManager destinationManager) throws MessageStoreException {
        return destinationManager.newNonLockingItemStreamCursor(new ClassEqualsFilter(LinkHandler.class));
    }

    private NonLockingCursor initializeDestinationManagerMQLinks(DestinationManager destinationManager) throws MessageStoreException {
        return destinationManager.newNonLockingItemStreamCursor(new ClassEqualsFilter(MQLinkHandler.class));
    }
}

