/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.ConjunctionImpl;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.ExtendedSimpleTestImpl;
import com.ibm.ws.sib.matchspace.selector.impl.ExtensionOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.SimpleTestImpl;
import com.ibm.ws.sib.matchspace.tools.PositionAssigner;
import com.ibm.ws.sib.matchspace.tools.Resolver;
import com.ibm.ws.sib.matchspace.tools.Transformer;
import java.util.ArrayList;
import java.util.List;

public final class TransformerImpl
implements Transformer {
    @Override
    public Selector resolve(Selector tree, Resolver resolver, PositionAssigner positionAssigner) {
        if (tree instanceof Identifier) {
            Identifier id = (Identifier)tree;
            return resolver.resolve(id, positionAssigner);
        }
        if (tree.getNumIds() > 0) {
            Operator oper = (Operator)tree;
            for (int i = 0; i < oper.getOperands().length; ++i) {
                oper.setOperand(i, this.resolve(oper.getOperands()[i], resolver, positionAssigner));
            }
            oper.assignType();
        }
        return tree;
    }

    @Override
    public Selector DNF(Selector tree) {
        tree = TransformerImpl.simplifyTree(tree);
        return TransformerImpl.DNF0(tree);
    }

    private static Selector DNF0(Selector tree) {
        if (!(tree instanceof Operator)) {
            return tree;
        }
        Operator oper = (Operator)tree;
        switch (oper.getOp()) {
            case 46: {
                return TransformerImpl.processAND(oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 47: {
                return TransformerImpl.makeOR(TransformerImpl.DNF0(oper.getOperands()[0]), TransformerImpl.DNF0(oper.getOperands()[1]));
            }
        }
        return tree;
    }

    private static Selector processAND(Selector sel0, Selector sel1) {
        Operator oper;
        sel0 = TransformerImpl.DNF0(sel0);
        sel1 = TransformerImpl.DNF0(sel1);
        if (sel0 instanceof Operator && (oper = (Operator)sel0).getOp() == 47) {
            return TransformerImpl.makeOR(TransformerImpl.processAND(oper.getOperands()[0], sel1), TransformerImpl.processAND(oper.getOperands()[1], sel1));
        }
        return TransformerImpl.processANDRight(sel0, sel1);
    }

    private static Selector processANDRight(Selector sel0, Selector sel1) {
        Operator oper;
        if (sel1 instanceof Operator && (oper = (Operator)sel1).getOp() == 47) {
            return TransformerImpl.makeOR(TransformerImpl.processANDRight(sel0, oper.getOperands()[0]), TransformerImpl.processANDRight(sel0, oper.getOperands()[1]));
        }
        return TransformerImpl.makeAND(sel0, sel1);
    }

    private static Selector makeOR(Selector sel0, Selector sel1) {
        if (sel0.getNumIds() == 0) {
            Boolean staticResult = (Boolean)Matching.getEvaluator().eval(sel0);
            if (staticResult != null && staticResult.booleanValue()) {
                return new LiteralImpl(Boolean.TRUE);
            }
            return TransformerImpl.evalOf(sel1);
        }
        if (sel1.getNumIds() == 0) {
            Boolean staticResult = (Boolean)Matching.getEvaluator().eval(sel1);
            if (staticResult != null && staticResult.booleanValue()) {
                return new LiteralImpl(Boolean.TRUE);
            }
            return TransformerImpl.evalOf(sel0);
        }
        return new OperatorImpl(47, sel0, sel1);
    }

    private static Selector makeAND(Selector sel0, Selector sel1) {
        if (sel0.getNumIds() == 0) {
            Boolean staticResult = (Boolean)Matching.getEvaluator().eval(sel0);
            if (staticResult == null || !staticResult.booleanValue()) {
                return new LiteralImpl(Boolean.FALSE);
            }
            return TransformerImpl.evalOf(sel1);
        }
        if (sel1.getNumIds() == 0) {
            Boolean staticResult = (Boolean)Matching.getEvaluator().eval(sel1);
            if (staticResult == null || !staticResult.booleanValue()) {
                return new LiteralImpl(Boolean.FALSE);
            }
            return TransformerImpl.evalOf(sel0);
        }
        return new OperatorImpl(46, sel0, sel1);
    }

    private static Selector evalOf(Selector arg) {
        if (arg.getNumIds() > 0) {
            return arg;
        }
        return new LiteralImpl(Matching.getEvaluator().eval(arg));
    }

    private static Selector simplifyTree(Selector tree) {
        if (!(tree instanceof Operator) || tree instanceof ExtensionOperatorImpl) {
            return tree;
        }
        Operator oper = (Operator)tree;
        switch (oper.getOp()) {
            case 1: {
                return TransformerImpl.simplifyNOT(oper.getOperands()[0]);
            }
            case 45: {
                return TransformerImpl.simplifyEQ(oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 40: {
                return TransformerImpl.simplifyNE(oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 2: 
            case 3: {
                return new OperatorImpl(oper.getOp(), TransformerImpl.simplifyTree(oper.getOperands()[0]));
            }
            case 4: 
            case 5: {
                LikeOperatorImpl loper = (LikeOperatorImpl)oper;
                return new LikeOperatorImpl(loper.getOp(), TransformerImpl.simplifyTree(loper.getOperands()[0]), loper.getInternalPattern(), loper.getPattern(), loper.isEscaped(), loper.getEscape());
            }
        }
        return new OperatorImpl(oper.getOp(), TransformerImpl.simplifyTree(oper.getOperands()[0]), TransformerImpl.simplifyTree(oper.getOperands()[1]));
    }

    private static Selector simplifyNOT(Selector tree) {
        if (tree instanceof Literal) {
            return new LiteralImpl(EvaluatorImpl.not((Boolean)((Literal)tree).getValue()));
        }
        if (!(tree instanceof Operator)) {
            return new OperatorImpl(1, tree);
        }
        Operator oper = (Operator)tree;
        switch (oper.getOp()) {
            case 1: {
                return TransformerImpl.simplifyTree(oper.getOperands()[0]);
            }
            case 46: {
                return TransformerImpl.makeOR(TransformerImpl.simplifyNOT(oper.getOperands()[0]), TransformerImpl.simplifyNOT(oper.getOperands()[1]));
            }
            case 47: {
                return TransformerImpl.makeAND(TransformerImpl.simplifyNOT(oper.getOperands()[0]), TransformerImpl.simplifyNOT(oper.getOperands()[1]));
            }
            case 45: {
                return TransformerImpl.simplifyNE(oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 40: {
                return TransformerImpl.simplifyEQ(oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 41: {
                return new OperatorImpl(44, oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 42: {
                return new OperatorImpl(43, oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 43: {
                return new OperatorImpl(42, oper.getOperands()[0], oper.getOperands()[1]);
            }
            case 44: {
                return new OperatorImpl(41, oper.getOperands()[0], oper.getOperands()[1]);
            }
        }
        return new OperatorImpl(1, tree);
    }

    private static Selector simplifyEQ(Selector sel0, Selector sel1) {
        if (sel0.getType() != -6) {
            return new OperatorImpl(45, sel0, sel1);
        }
        return TransformerImpl.makeOR(TransformerImpl.makeAND(TransformerImpl.simplifyTree(sel0), TransformerImpl.simplifyTree(sel1)), TransformerImpl.makeAND(TransformerImpl.simplifyNOT(sel0), TransformerImpl.simplifyNOT(sel1)));
    }

    private static Selector simplifyNE(Selector sel0, Selector sel1) {
        if (sel0.getType() == -6) {
            return TransformerImpl.makeOR(TransformerImpl.makeAND(TransformerImpl.simplifyTree(sel0), TransformerImpl.simplifyNOT(sel1)), TransformerImpl.makeAND(TransformerImpl.simplifyNOT(sel0), TransformerImpl.simplifyTree(sel1)));
        }
        if (sel0.getType() == -5 || sel0.getType() == 0) {
            return new OperatorImpl(40, sel0, sel1);
        }
        return TransformerImpl.makeOR(new OperatorImpl(42, sel0, sel1), new OperatorImpl(41, sel0, sel1));
    }

    @Override
    public Conjunction[] organizeTests(Selector tree) {
        ArrayList tests = new ArrayList();
        if (TransformerImpl.organizeTests(tests, tree)) {
            return null;
        }
        return tests.toArray(new ConjunctionImpl[0]);
    }

    private static boolean organizeTests(List tests, Selector tree) {
        ConjunctionImpl conjunction;
        if (tree instanceof Operator) {
            Operator oper = (Operator)tree;
            if (oper.getOp() == 47) {
                return TransformerImpl.organizeTests(tests, oper.getOperands()[0]) || TransformerImpl.organizeTests(tests, oper.getOperands()[1]);
            }
            conjunction = oper.getOp() == 46 ? TransformerImpl.organizeConjunction(oper) : TransformerImpl.simpleConjunct(tree);
        } else {
            conjunction = TransformerImpl.simpleConjunct(tree);
        }
        if (conjunction == null) {
            return false;
        }
        if (conjunction.alwaysTrue) {
            return true;
        }
        if (conjunction.organize()) {
            tests.add(conjunction);
        }
        return false;
    }

    private static ConjunctionImpl simpleConjunct(Selector tree) {
        if (tree.getNumIds() == 0) {
            Boolean theEval = (Boolean)Matching.getEvaluator().eval(tree);
            if (theEval != null && theEval.booleanValue()) {
                return new ConjunctionImpl();
            }
            return null;
        }
        if (Matching.isSimple(tree)) {
            if (tree.isExtended()) {
                return new ConjunctionImpl(new ExtendedSimpleTestImpl(tree));
            }
            return new ConjunctionImpl(new SimpleTestImpl(tree));
        }
        return new ConjunctionImpl(tree);
    }

    private static ConjunctionImpl organizeConjunction(Operator andOper) {
        Operator oper;
        Selector left = andOper.getOperands()[0];
        ConjunctionImpl conjunction = left instanceof Operator ? ((oper = (Operator)left).getOp() == 46 ? TransformerImpl.organizeConjunction(oper) : TransformerImpl.simpleConjunct(left)) : TransformerImpl.simpleConjunct(left);
        if (conjunction == null) {
            return null;
        }
        return TransformerImpl.augmentConjunction(conjunction, andOper.getOperands()[1]) ? conjunction : null;
    }

    private static boolean augmentConjunction(ConjunctionImpl target, Selector toAdd) {
        Operator oper;
        if (toAdd instanceof Operator && (oper = (Operator)toAdd).getOp() == 46) {
            return TransformerImpl.augmentConjunction(target, oper.getOperands()[0]) && TransformerImpl.augmentConjunction(target, oper.getOperands()[1]);
        }
        if (toAdd.getNumIds() == 0) {
            Boolean theEval = (Boolean)Matching.getEvaluator().eval(toAdd);
            if (theEval == null) {
                return false;
            }
            return theEval;
        }
        if (Matching.isSimple(toAdd)) {
            if (toAdd.isExtended()) {
                return target.and(new ExtendedSimpleTestImpl(toAdd));
            }
            return target.and(new SimpleTestImpl(toAdd));
        }
        target.and(toAdd);
        return true;
    }
}

