/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.impl.CachedPersistableImpl;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public final class UpdateTask
extends Task {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(UpdateTask.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Persistable _cachedPersistable = null;
    private Persistable _masterPersistable;

    public UpdateTask(AbstractItemLink link) throws SevereMessageStoreException {
        super(link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)link);
        }
        this._masterPersistable = super.getPersistable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    public final void abort(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abort", (Object)transaction);
        }
        this.getLink().abortUpdate(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abort");
        }
    }

    @Override
    public final void commitExternal(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitExternal", (Object)transaction);
        }
        this.getLink().commitUpdate(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitExternal");
        }
    }

    @Override
    public final void commitInternal(PersistentTransaction transaction) {
    }

    @Override
    public final void copyDataIfVulnerable() throws PersistentDataEncodingException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
        if (this._cachedPersistable == null) {
            this._cachedPersistable = new CachedPersistable(this._masterPersistable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"copyDataIfVulnerable");
        }
    }

    @Override
    public final Persistable getPersistable() {
        if (this._cachedPersistable != null) {
            return this._cachedPersistable;
        }
        return this._masterPersistable;
    }

    @Override
    public final int getPersistableInMemorySizeApproximation(TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)tranState);
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        int size = 500 + this.getPersistable().getInMemoryByteSize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)size);
        }
        return size;
    }

    @Override
    public final Task.Type getTaskType() {
        return Task.Type.UPDATE;
    }

    @Override
    public final void persist(BatchingContext batchingContext, TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, tranState});
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        batchingContext.updateDataAndSize(this.getPersistable());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persist");
        }
    }

    @Override
    public final void postAbort(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postAbort", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventPostRollbackUpdate((Transaction)transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postAbort");
        }
    }

    @Override
    public final void postCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postCommit", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventPostCommitUpdate((Transaction)transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postCommit");
        }
    }

    @Override
    public final void preCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommit", (Object)transaction);
        }
        this.getItem();
        this.getLink().preCommitUpdate(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommit");
        }
    }

    private static final class CachedPersistable
    extends CachedPersistableImpl {
        private List<DataSlice> _cachedMemberData;
        private int _cachedInMemorySize;

        public CachedPersistable(Persistable masterPersistable) throws PersistentDataEncodingException, SevereMessageStoreException {
            super(masterPersistable);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>$CachedPersistable");
            }
            List<DataSlice> memberData = masterPersistable.getData();
            this._cachedMemberData = new ArrayList<DataSlice>(memberData);
            this._cachedInMemorySize = masterPersistable.getInMemoryByteSize();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>$CachedPersistable");
            }
        }

        @Override
        public List<DataSlice> getData() {
            return this._cachedMemberData;
        }

        @Override
        public int getInMemoryByteSize() {
            return this._cachedInMemorySize;
        }
    }
}

