/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.concurrent.atomic.AtomicInteger;

@Trivial
class PollingManager {
    private static final TraceComponent tc = Tr.register(PollingManager.class);
    static final int SERVER_STARTED = 1;
    static final int EXECUTION_ENABLED = 2;
    static final int DS_READY = 4;
    static final int SIGNAL_RECEIVED = 8;
    static final int SIGNAL_REQUIRED = 16;
    private static final int READY_WITHOUT_SIGNAL = 7;
    private static final int READY_WITH_UNNECESSARY_SIGNAL = 15;
    private static final int READY_WITH_SIGNAL = 31;
    private final AtomicInteger bits = new AtomicInteger();

    PollingManager() {
    }

    void add(int event) {
        int b = this.bits.addAndGet(event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("add " + event + ", polling state: " + b), (Object[])new Object[0]);
        }
    }

    boolean addAndCheckIfReady(int event) {
        boolean isReady;
        int b = this.bits.addAndGet(event);
        boolean bl = isReady = b == 7 || b == 15 || b == 31;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("addAndCheckIfReady " + event + ", polling state: " + b + ", " + isReady), (Object[])new Object[0]);
        }
        return isReady;
    }

    void remove(int event) {
        int b = this.bits.addAndGet(-event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("remove " + event + ", polling state: " + b), (Object[])new Object[0]);
        }
    }
}

