/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.concurrent.persistent.mbean.PersistentExecutorMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.concurrent.persistent.internal.Config;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.concurrent.persistent.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.jmx.service.MBeanMessageHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.concurrent.persistent.PartitionRecord;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PersistentExecutorMBeanImpl
extends StandardMBean
implements PersistentExecutorMBean {
    private static final TraceComponent tc = Tr.register(PersistentExecutorMBeanImpl.class);
    private transient PersistentExecutorImpl _pe = null;
    private transient ObjectName obn = null;
    private transient ServiceRegistration<?> reg = null;
    private final AtomicLong exceptionCounter = new AtomicLong();
    static final long serialVersionUID = -4040292718269138988L;

    public PersistentExecutorMBeanImpl(PersistentExecutorImpl pe) throws MalformedObjectNameException {
        super(PersistentExecutorMBean.class, false);
        this._pe = pe;
        Config config = this._pe.configRef.get();
        StringBuilder obnSb = new StringBuilder("WebSphere:feature=persistentExecutor,type=PersistentExecutorMBean");
        if (config.xpathId != null) {
            obnSb.append(",name=");
            obnSb.append(this.toObnString(config.xpathId));
        }
        if (config.jndiName != null) {
            obnSb.append(",jndiName=");
            obnSb.append(this.toObnString(config.jndiName));
        }
        if (config.id != null) {
            obnSb.append(",id=");
            obnSb.append(this.toObnString(config.id));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("ObjectName created with the string: " + obnSb.toString()), (Object[])new Object[0]);
        }
        this.obn = new ObjectName(obnSb.toString());
    }

    public void register(BundleContext bndCtx) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("jmx.objectname", this.obn.toString());
        this.reg = bndCtx.registerService(PersistentExecutorMBean.class.getName(), (Object)this, props);
    }

    public void unregister() {
        this.reg.unregister();
        this.reg = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[][] findPartitionInfo(String hostName, String userDir, String libertyServerName, String executorIdentifier) throws Exception {
        try {
            return this._pe.findPartitionInfo(hostName, userDir, libertyServerName, executorIdentifier);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorMBeanImpl", (String)"100", (Object)this, (Object[])new Object[]{hostName, userDir, libertyServerName, executorIdentifier});
            throw this.buildAndLogException((Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Long[] findTaskIds(long partition, String state, boolean inState, Long minId, Integer maxResults) throws Exception {
        try {
            TaskState ts = TaskState.valueOf(state);
            return this._pe.findTaskIds(partition, ts, inState, minId, maxResults);
        }
        catch (Exception ts) {
            void e;
            FFDCFilter.processException((Throwable)ts, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorMBeanImpl", (String)"116", (Object)this, (Object[])new Object[]{partition, state, inState, minId, maxResults});
            throw this.buildAndLogException((Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int transfer(Long maxTaskId, long oldPartitionId) throws Exception {
        try {
            return this._pe.transfer(maxTaskId, oldPartitionId);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorMBeanImpl", (String)"131", (Object)this, (Object[])new Object[]{maxTaskId, oldPartitionId});
            throw this.buildAndLogException((Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removePartitionInfo(String hostName, String userDir, String libertyServerName, String executorIdentifier) throws Exception {
        try {
            return this._pe.removePartitionInfo(hostName, userDir, libertyServerName, executorIdentifier);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorMBeanImpl", (String)"146", (Object)this, (Object[])new Object[]{hostName, userDir, libertyServerName, executorIdentifier});
            throw this.buildAndLogException((Exception)e);
        }
    }

    @Override
    protected String getClassName(MBeanInfo info) {
        return PersistentExecutorMBean.class.getCanonicalName();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "MBean for a Persistent Executor";
    }

    private String toObnString(String s) {
        return s.replace(':', '.').replace('=', '.').replace(',', '.').replace('\"', '.');
    }

    private Exception buildAndLogException(Exception e) throws Exception {
        PartitionRecord pr = new PartitionRecord(false);
        pr.setExecutor(this._pe.name);
        List<PartitionRecord> records = this._pe.taskStore.find(pr);
        PartitionRecord record = records.get(0);
        String id = "PersistentExecutorMBean-".concat(String.valueOf(this.exceptionCounter.getAndIncrement()));
        String logDir = record.getUserDir().concat("servers/").concat(record.getLibertyServer()).concat("/logs/");
        Exception ex = new Exception(MBeanMessageHelper.getUnableToPerformOperationMessage((String)record.getLibertyServer(), (String)record.getHostName(), (String)logDir.replace('/', File.separatorChar), (String)id));
        Object[] serverStrings = new Object[]{id, Utils.stackTraceToString(e)};
        Tr.error((TraceComponent)tc, (String)"CWWKC1559.mbean.operation.failure", (Object[])serverStrings);
        return ex;
    }
}

