/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.UncheckedException;
import com.ibm.ejs.persistence.EJSPersistenceException;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.cpmi.CPMIException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBMethodMetaData;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.RecursiveInjectionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.NamingException;
import org.omg.CORBA.portable.UnknownException;

public class ExceptionUtil {
    private static TraceComponent tc = Tr.register(ExceptionUtil.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public static final String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        ExceptionUtil.printStackTrace(t, p);
        return s.toString();
    }

    private static final boolean hasBeenLogged(Throwable t) {
        boolean hasBeenLogged = false;
        Throwable lastCause = null;
        for (Throwable cause = t; cause != null && cause != lastCause; cause = cause.getCause()) {
            if (cause instanceof RecursiveInjectionException) {
                if (((RecursiveInjectionException)cause).ivLogged) {
                    hasBeenLogged = true;
                    break;
                }
                ((RecursiveInjectionException)cause).ivLogged = true;
                hasBeenLogged = false;
                break;
            }
            lastCause = cause;
        }
        return hasBeenLogged;
    }

    public static final void logException(TraceComponent compTc, Throwable t, EJBMethodMetaData m, BeanO bean) {
        if (ExceptionUtil.hasBeenLogged(t)) {
            return;
        }
        BeanId beanId = null;
        if (bean != null) {
            beanId = bean.getId();
        }
        if (m == null) {
            if (beanId == null) {
                Tr.error((TraceComponent)compTc, (String)"NON_APPLICATION_EXCEPTION_CNTR0018E", (Object[])new Object[]{t});
            } else {
                Tr.error((TraceComponent)compTc, (String)"NON_APPLICATION_EXCEPTION_ON_BEAN_CNTR0021E", (Object[])new Object[]{t, beanId});
            }
        } else {
            String methodName = m.getMethodName();
            if (beanId == null) {
                Tr.error((TraceComponent)compTc, (String)"NON_APPLICATION_EXCEPTION_METHOD_CNTR0019E", (Object[])new Object[]{t, methodName});
            } else {
                Tr.error((TraceComponent)compTc, (String)"NON_APPLICATION_EXCEPTION_METHOD_ON_BEAN_CNTR0020E", (Object[])new Object[]{t, methodName, beanId});
            }
        }
    }

    public static void logException(Throwable t) {
        ExceptionUtil.logException(tc, t, null, null);
    }

    private static final void printStackTrace(Throwable t, PrintWriter p) {
        t.printStackTrace(p);
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable root;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findRootCause: " + throwable), (Object[])new Object[0]);
        }
        Throwable next = root = throwable;
        while (next != null) {
            root = next;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("finding cause of: " + root.getClass().getName()), (Object[])new Object[0]);
            }
            if (root instanceof RemoteException) {
                next = ((RemoteException)root).detail;
                continue;
            }
            if (root instanceof WsNestedException) {
                next = ((WsNestedException)root).getCause();
                continue;
            }
            if (root instanceof TransactionRolledbackLocalException) {
                next = ((TransactionRolledbackLocalException)root).getCause();
                continue;
            }
            if (root instanceof AccessLocalException) {
                next = ((AccessLocalException)root).getCause();
                continue;
            }
            if (root instanceof NoSuchObjectLocalException) {
                next = ((NoSuchObjectLocalException)root).getCause();
                continue;
            }
            if (root instanceof TransactionRequiredLocalException) {
                next = ((TransactionRequiredLocalException)root).getCause();
                continue;
            }
            if (root instanceof NamingException) {
                next = ((NamingException)root).getRootCause();
                continue;
            }
            if (root instanceof InvocationTargetException) {
                next = ((InvocationTargetException)root).getTargetException();
                continue;
            }
            if (root instanceof UnknownException) {
                next = ((UnknownException)root).originalEx;
                continue;
            }
            if (root instanceof InjectionException) {
                next = root.getCause();
                continue;
            }
            next = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findRootCause returning: " + root));
        }
        return root;
    }

    public static Throwable findCause(Throwable throwable) {
        Throwable cause;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findCause: " + throwable), (Object[])new Object[0]);
        }
        if ((cause = throwable.getCause()) == null && throwable instanceof EJBException) {
            cause = ((EJBException)throwable).getCausedByException();
        }
        if (cause != null) {
            String causeMessage = null;
            while (cause instanceof ContainerException || cause instanceof UncheckedException || cause instanceof EJSPersistenceException || cause instanceof CPIException || cause instanceof CPMIException || cause instanceof CSIException || cause instanceof InjectionException || cause instanceof EJBException && cause instanceof WsNestedException) {
                Throwable nextCause = cause.getCause();
                if (nextCause == null) {
                    StackTraceElement[] stackTrace = cause.getStackTrace();
                    if (causeMessage == null) {
                        causeMessage = cause.getMessage();
                    }
                    cause = new EJBException(causeMessage);
                    cause.setStackTrace(stackTrace);
                    continue;
                }
                if (cause instanceof InjectionException) {
                    causeMessage = cause.getMessage();
                }
                cause = nextCause;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findCause: " + cause));
        }
        return cause;
    }

    public static Exception Exception(Throwable cause) {
        return cause instanceof Exception ? (Exception)cause : new Exception("See nested Throwable", cause);
    }

    public static EJBException EJBException(Throwable cause) {
        return ExceptionUtil.EJBException("See nested exception", cause);
    }

    public static EJBException EJBException(String message, Throwable cause) {
        EJBException ejbex = null;
        if (cause == null) {
            ejbex = new EJBException(message);
        }
        String causeMessage = null;
        while (cause != null && !(cause instanceof RecursiveInjectionException) && (cause instanceof ContainerException || cause instanceof UncheckedException || cause instanceof EJSPersistenceException || cause instanceof CPIException || cause instanceof CPMIException || cause instanceof CSIException || cause instanceof InjectionException || cause instanceof EJBException && cause instanceof WsNestedException)) {
            Throwable nextCause = cause.getCause();
            if (nextCause == null) {
                if (causeMessage == null) {
                    causeMessage = cause.getMessage();
                }
                ejbex = new EJBException(causeMessage);
                ejbex.setStackTrace(cause.getStackTrace());
            } else if (causeMessage == null && cause instanceof InjectionException) {
                causeMessage = cause.getMessage();
            }
            cause = nextCause;
        }
        if (ejbex == null) {
            if (cause instanceof EJBException) {
                ejbex = (EJBException)cause;
                if ((cause = ejbex.getCausedByException()) != null && ejbex.getCause() == null) {
                    ejbex.initCause(cause);
                }
            } else {
                if (causeMessage == null) {
                    causeMessage = message;
                }
                if ((ejbex = new EJBException(causeMessage, ExceptionUtil.Exception(cause))).getCause() == null) {
                    ejbex.initCause(cause);
                }
            }
        }
        return ejbex;
    }

    public static NoSuchEJBException NoSuchEJBException(String message, Throwable cause) {
        NoSuchEJBException nsejb;
        if (cause == null) {
            nsejb = new NoSuchEJBException(message);
        } else {
            if (cause instanceof Exception) {
                nsejb = new NoSuchEJBException(message, (Exception)cause);
            } else {
                Exception wrappedCause = new Exception("See nested Throwable", cause);
                nsejb = new NoSuchEJBException(message, wrappedCause);
                cause = wrappedCause;
            }
            if (nsejb.getCause() == null) {
                nsejb.initCause(cause);
            }
        }
        return nsejb;
    }

    public static RemoteException RemoteException(Throwable cause) {
        return ExceptionUtil.RemoteException("See nested exception", cause);
    }

    public static RemoteException RemoteException(String message, Throwable cause) {
        RemoteException remote = null;
        if (cause == null) {
            remote = new RemoteException(message);
        }
        String causeMessage = null;
        while (cause != null && (cause instanceof ContainerException || cause instanceof UncheckedException || cause instanceof EJSPersistenceException || cause instanceof CPIException || cause instanceof CPMIException || cause instanceof CSIException || cause instanceof InjectionException || cause instanceof EJBException && cause instanceof WsNestedException)) {
            Throwable nextCause = cause.getCause();
            if (nextCause == null) {
                if (causeMessage == null) {
                    causeMessage = cause.getMessage();
                }
                remote = new RemoteException(causeMessage);
                remote.setStackTrace(cause.getStackTrace());
            } else if (causeMessage == null && cause instanceof InjectionException) {
                causeMessage = cause.getMessage();
            }
            cause = nextCause;
        }
        if (remote == null) {
            if (cause instanceof RemoteException) {
                remote = (RemoteException)cause;
            } else {
                if (causeMessage == null) {
                    causeMessage = message;
                }
                remote = new RemoteException(message, cause);
            }
        }
        return remote;
    }

    public static String getBaseMessage(Throwable exception) {
        String message = null;
        if (exception instanceof RemoteException) {
            RemoteException rex = (RemoteException)exception;
            Throwable detail = rex.detail;
            rex.detail = null;
            message = rex.getMessage();
            rex.detail = detail;
            if ("".equals(message) && detail != null) {
                message = ExceptionUtil.getBaseMessage(detail);
            }
        } else if (exception != null && (message = exception.getMessage()) != null) {
            if (message.startsWith("nested exception is:")) {
                message = null;
            } else {
                int nestIndex = message.indexOf("; nested exception is:");
                if (nestIndex > -1) {
                    message = message.substring(0, nestIndex);
                }
            }
        }
        return message;
    }
}

