/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.update.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.launch.service.ForcedServerStop;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RuntimeUpdateManager.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class RuntimeUpdateManagerImpl
implements RuntimeUpdateManager,
SynchronousBundleListener {
    private static final TraceComponent tc = Tr.register(RuntimeUpdateManagerImpl.class);
    private volatile FutureMonitor futureMonitor;
    private final AtomicBoolean normalServerStop = new AtomicBoolean(true);
    private final Set<RuntimeUpdateListener> updateListeners = new HashSet<RuntimeUpdateListener>();
    private final Map<String, RuntimeUpdateNotification> notifications = new HashMap<String, RuntimeUpdateNotification>();
    private BundleContext bundleCtx;
    private final CompletionListener<Boolean> cleanupListener = new CompletionListener<Boolean>(){
        static final long serialVersionUID = -1247721544084393241L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void successfulCompletion(Future<Boolean> future, Boolean result) {
            RuntimeUpdateManagerImpl.this.cleanupNotifications();
        }

        public void failedCompletion(Future<Boolean> future, Throwable t) {
            RuntimeUpdateManagerImpl.this.cleanupNotifications();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private WsLocationAdmin locationService;
    static final long serialVersionUID = 8528977989724669243L;

    @Activate
    protected void activate(BundleContext ctx) {
        this.bundleCtx = ctx;
        this.bundleCtx.addBundleListener((BundleListener)this);
    }

    @Reference(service=FutureMonitor.class)
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=RuntimeUpdateListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRuntimeUpdateListener(RuntimeUpdateListener updateListener) {
        ArrayList<RuntimeUpdateNotification> snapshot;
        Map<String, RuntimeUpdateNotification> map = this.notifications;
        synchronized (map) {
            snapshot = new ArrayList<RuntimeUpdateNotification>(this.notifications.values());
            this.updateListeners.add(updateListener);
        }
        for (RuntimeUpdateNotification existing : snapshot) {
            updateListener.notificationCreated(this, existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetRuntimeUpdateListener(RuntimeUpdateListener updateListener) {
        Map<String, RuntimeUpdateNotification> map = this.notifications;
        synchronized (map) {
            this.updateListeners.remove(updateListener);
        }
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin admin) {
        this.locationService = admin;
    }

    protected void unsetLocationAdmin(WsLocationAdmin admin) {
        this.locationService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupNotifications() {
        Map<String, RuntimeUpdateNotification> map = this.notifications;
        synchronized (map) {
            for (RuntimeUpdateNotification notification : this.notifications.values()) {
                if (notification.isDone()) continue;
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"cleanupNotifications: notifications cleared", (Object[])new Object[0]);
            }
            this.notifications.clear();
        }
    }

    @Override
    public RuntimeUpdateNotification createNotification(String name) {
        return this.createNotification(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeUpdateNotification getNotification(String name) {
        if (FrameworkState.isStopping()) {
            return null;
        }
        Map<String, RuntimeUpdateNotification> map = this.notifications;
        synchronized (map) {
            return this.notifications.get(name);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == 0L && event.getType() == 256) {
            ServiceReference forcedStop = this.bundleCtx.getServiceReference(ForcedServerStop.class);
            if (forcedStop != null) {
                this.normalServerStop.set(false);
            } else {
                try {
                    this.queisceListeners(this.bundleCtx.getServiceReferences(ServerQuiesceListener.class, null));
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.runtime.update.internal.RuntimeUpdateManagerImpl", (String)"292", (Object)this, (Object[])new Object[]{event});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    private void queisceListeners(Collection<ServiceReference<ServerQuiesceListener>> listenerRefs) {
        final HashMap<String, RuntimeUpdateNotification> existingNotifications = new HashMap<String, RuntimeUpdateNotification>();
        Map<String, RuntimeUpdateNotification> map = this.notifications;
        synchronized (map) {
            existingNotifications.putAll(this.notifications);
        }
        if (listenerRefs.isEmpty() && existingNotifications.isEmpty()) {
            return;
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        if (this.isServer()) {
            Tr.audit((TraceComponent)tc, (String)"quiesce.begin", (Object[])new Object[0]);
        } else {
            Tr.audit((TraceComponent)tc, (String)"client.quiesce.begin", (Object[])new Object[0]);
        }
        if (!existingNotifications.isEmpty()) {
            threadPool.execute(new Runnable(){
                static final long serialVersionUID = -6947702020353973848L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    try {
                        for (RuntimeUpdateNotification notification : existingNotifications.values()) {
                            if (notification.ignoreOnQuiesce()) continue;
                            notification.waitForCompletion();
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.update.internal.RuntimeUpdateManagerImpl$2", (String)"337", (Object)this, (Object[])new Object[0]);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        final ConcurrentLinkedQueue listeners = new ConcurrentLinkedQueue();
        for (ServiceReference<ServerQuiesceListener> ref : listenerRefs) {
            final ServerQuiesceListener listener = (ServerQuiesceListener)this.bundleCtx.getService(ref);
            if (listener == null) continue;
            threadPool.execute(new Runnable(){
                static final long serialVersionUID = -3618464269570709744L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    try {
                        listeners.add(Thread.currentThread());
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invoking serverStopping() on listener: " + listener), (Object[])new Object[0]);
                        }
                        listener.serverStopping();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("serverStopping() method completed on listener: " + listener), (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.update.internal.RuntimeUpdateManagerImpl$3", (String)"363", (Object)this, (Object[])new Object[0]);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        threadPool.shutdown();
        boolean finished = false;
        try {
            finished = threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            finished = false;
        }
        if (finished) {
            if (this.isServer()) {
                Tr.info((TraceComponent)tc, (String)"quiesce.end", (Object[])new Object[0]);
            } else {
                Tr.info((TraceComponent)tc, (String)"client.quiesce.end", (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                for (RuntimeUpdateNotification notification : existingNotifications.values()) {
                    if (notification.isDone()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Notification is not done yet: " + notification), (Object[])new Object[0]);
                }
                for (Thread t : listeners) {
                    int liveThreads = 0;
                    if (!t.isAlive()) continue;
                    Tr.debug((TraceComponent)tc, (String)("For thread " + ++liveThreads + " the stack trace is as follows: "), (Object[])new Object[0]);
                    StackTraceElement[] stackTrace = t.getStackTrace();
                    int sizeOfStack = stackTrace.length;
                    for (int i = 0; i < sizeOfStack || i < 5; ++i) {
                        Tr.debug((TraceComponent)tc, (String)("\t \t at " + stackTrace[i].getMethodName() + "(" + stackTrace[i].getFileName() + "" + stackTrace[i].getLineNumber() + ")"), (Object[])new Object[0]);
                    }
                    if (sizeOfStack < 5) continue;
                    Tr.debug((TraceComponent)tc, (String)"...", (Object[])new Object[0]);
                }
            }
            this.normalServerStop.set(false);
            Tr.warning((TraceComponent)tc, (String)"quiece.warning", (Object[])new Object[0]);
        }
    }

    private boolean isServer() {
        return this.locationService.resolveString("${wlp.process.type}").equals("server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeUpdateNotification createNotification(String name, boolean ignoreOnQuiesce) {
        ArrayList<RuntimeUpdateListener> listenerSnapshot;
        if (FrameworkState.isStopping()) {
            return null;
        }
        Future future = this.futureMonitor.createFuture(Boolean.class);
        NotificationImpl notification = new NotificationImpl(name, future, this.futureMonitor, this.normalServerStop, ignoreOnQuiesce);
        Map<String, RuntimeUpdateNotification> map = this.notifications;
        synchronized (map) {
            this.notifications.put(name, notification);
            listenerSnapshot = new ArrayList<RuntimeUpdateListener>(this.updateListeners);
        }
        for (RuntimeUpdateListener updateListener : listenerSnapshot) {
            updateListener.notificationCreated(this, notification);
        }
        notification.onCompletion(this.cleanupListener);
        return notification;
    }

    @Trivial
    private static class NotificationImpl
    implements RuntimeUpdateNotification {
        private final String name;
        private final Future<Boolean> future;
        private final FutureMonitor futureMonitor;
        private final AtomicBoolean waitForPendingNotifications;
        private final boolean ignoreOnQuiesce;

        NotificationImpl(String name, Future<Boolean> future, FutureMonitor futureMonitor, AtomicBoolean waitForPendingNotifications) {
            this.name = name;
            this.future = future;
            this.futureMonitor = futureMonitor;
            this.waitForPendingNotifications = waitForPendingNotifications;
            this.ignoreOnQuiesce = false;
        }

        NotificationImpl(String name, Future<Boolean> future, FutureMonitor futureMonitor, AtomicBoolean waitForPendingNotifications, boolean ignoreQuiesce) {
            this.name = name;
            this.future = future;
            this.futureMonitor = futureMonitor;
            this.waitForPendingNotifications = waitForPendingNotifications;
            this.ignoreOnQuiesce = ignoreQuiesce;
        }

        public String toString() {
            return this.name + "[" + this.future + "]";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Future<Boolean> getFuture() {
            return this.future;
        }

        @Override
        public void setResult(boolean result) {
            this.futureMonitor.setResult(this.future, (Object)result);
        }

        @Override
        public void setResult(Throwable t) {
            this.futureMonitor.setResult(this.future, t);
        }

        @Override
        public void onCompletion(CompletionListener<Boolean> completionListener) {
            this.futureMonitor.onCompletion(this.future, completionListener);
        }

        @Override
        public void waitForCompletion() {
            final CountDownLatch latch = new CountDownLatch(1);
            this.onCompletion(new CompletionListener<Boolean>(){
                static final long serialVersionUID = 5502514482247088259L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    latch.countDown();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    latch.countDown();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            while (this.waitForPendingNotifications.get()) {
                try {
                    if (!latch.await(1L, TimeUnit.SECONDS)) continue;
                    return;
                }
                catch (InterruptedException e) {
                    e.getCause();
                }
            }
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public boolean ignoreOnQuiesce() {
            return this.ignoreOnQuiesce;
        }
    }
}

