/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.execution.impl;

import com.ibm.jbatch.container.StepContextDelegate;
import com.ibm.jbatch.container.context.impl.MetricImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.context.StepContext;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RuntimeStepExecution
implements StepContextDelegate {
    private static final String sourceClass = RuntimeStepExecution.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final boolean cloneContextProperties = Boolean.getBoolean("clone.context.properties");
    private final String stepName;
    private Object transientUserData;
    private Serializable persistentUserDataObject;
    private Exception exception;
    private Properties properties;
    private String batchletProcessRetVal;
    protected StepContextImpl stepCtx;
    private ConcurrentHashMap<String, Metric> metrics;
    private ConcurrentHashMap<String, Metric> committedMetrics;
    private ArrayList<Metric.MetricType> tranCoordinatedMetricTypes;
    private BatchStatus batchStatus;
    private String exitStatus;
    private Date startTime;
    private Date endTime;
    private Date lastUpdatedTime;
    private long internalStepThreadExecutionId;
    private long topLevelStepExecutionId;
    static final long serialVersionUID = 2786056242792573512L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeStepExecution(StepThreadExecutionEntity stepThreadExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "<init>", new Object[]{stepThreadExecution});
        }
        this.transientUserData = null;
        this.persistentUserDataObject = null;
        this.exception = null;
        this.properties = new Properties();
        this.batchletProcessRetVal = null;
        this.stepCtx = null;
        this.metrics = new ConcurrentHashMap();
        this.committedMetrics = new ConcurrentHashMap();
        this.tranCoordinatedMetricTypes = new ArrayList();
        this.stepName = stepThreadExecution.getStepName();
        this.batchStatus = stepThreadExecution.getBatchStatus();
        this.exitStatus = stepThreadExecution.getExitStatus();
        this.stepCtx = new StepContextImpl(this);
        this.startTime = stepThreadExecution.getStartTime();
        this.endTime = stepThreadExecution.getEndTime();
        this.internalStepThreadExecutionId = stepThreadExecution.getStepExecutionId();
        this.topLevelStepExecutionId = stepThreadExecution.getTopLevelStepExecution().getStepExecutionId();
        this.persistentUserDataObject = this.initializePersistentUserDataObject(stepThreadExecution.getPersistentUserDataBytes());
        this.tranCoordinatedMetricTypes.add(Metric.MetricType.COMMIT_COUNT);
        this.tranCoordinatedMetricTypes.add(Metric.MetricType.READ_COUNT);
        this.tranCoordinatedMetricTypes.add(Metric.MetricType.FILTER_COUNT);
        this.tranCoordinatedMetricTypes.add(Metric.MetricType.WRITE_COUNT);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchStatus getBatchStatus() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getBatchStatus", new Object[0]);
        }
        BatchStatus batchStatus = this.batchStatus;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchStatus = batchStatus;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getBatchStatus", batchStatus);
        }
        return batchStatus;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Exception getException() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getException", new Object[0]);
        }
        Exception exception = this.exception;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            exception = exception;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getException", exception);
        }
        return exception;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setException(Exception exception) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setException", new Object[]{exception});
        }
        this.exception = exception;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setException");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getExitStatus() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getExitStatus", new Object[0]);
        }
        String string = this.exitStatus;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getExitStatus", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStepName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getStepName", new Object[0]);
        }
        String string = this.stepName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getStepName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Metric> getMetrics() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getMetrics", new Object[0]);
        }
        ArrayList<Metric> arrayList = new ArrayList<Metric>(this.metrics.values());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getMetrics", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MetricImpl getMetric(Metric.MetricType metricType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getMetric", new Object[]{metricType});
        }
        MetricImpl metricImpl = (MetricImpl)this.metrics.get(metricType.name());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            metricImpl = metricImpl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getMetric", metricImpl);
        }
        return metricImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MetricImpl getCommittedMetric(Metric.MetricType metricType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getCommittedMetric", new Object[]{metricType});
        }
        MetricImpl metricImpl = (MetricImpl)this.committedMetrics.get(metricType.name());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            metricImpl = metricImpl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getCommittedMetric", metricImpl);
        }
        return metricImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addMetric(Metric.MetricType metricType, long value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "addMetric", new Object[]{metricType, value});
        }
        this.metrics.putIfAbsent(metricType.name(), new MetricImpl(metricType, value));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "addMetric");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setCommittedMetrics() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setCommittedMetrics", new Object[0]);
        }
        for (Metric.MetricType metricType : this.tranCoordinatedMetricTypes) {
            this.committedMetrics.put(metricType.name(), new MetricImpl(metricType, this.getMetric(metricType).getValue()));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setCommittedMetrics");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void rollBackMetrics() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "rollBackMetrics", new Object[0]);
        }
        for (Metric.MetricType metricType : this.tranCoordinatedMetricTypes) {
            this.metrics.put(metricType.name(), new MetricImpl(metricType, this.getCommittedMetric(metricType).getValue()));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "rollBackMetrics");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Serializable getPersistentUserDataObject() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getPersistentUserDataObject", new Object[0]);
        }
        Serializable serializable = this.persistentUserDataObject;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            serializable = serializable;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getPersistentUserDataObject", serializable);
        }
        return serializable;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPersistentUserDataObject(Serializable data) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setPersistentUserDataObject", new Object[]{data});
        }
        this.persistentUserDataObject = data;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setPersistentUserDataObject");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Properties getProperties() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getProperties", new Object[0]);
        }
        if (cloneContextProperties) {
            logger.fine("Cloning step context properties");
            Properties properties = (Properties)this.properties.clone();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                properties = properties;
                logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getProperties", properties);
            }
            return properties;
        }
        logger.fine("Returing ref (non-clone) to step context properties");
        Properties properties = this.properties;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            properties = properties;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getProperties", properties);
        }
        return properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Properties getJSLProperties() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getJSLProperties", new Object[0]);
        }
        Properties properties = this.properties;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            properties = properties;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getJSLProperties", properties);
        }
        return properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getTransientUserData() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getTransientUserData", new Object[0]);
        }
        Object object = this.transientUserData;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            object = object;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getTransientUserData", object);
        }
        return object;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExitStatus(String status) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setExitStatus", new Object[]{status});
        }
        this.exitStatus = status;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setExitStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBatchStatus(BatchStatus status) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setBatchStatus", new Object[]{status});
        }
        this.batchStatus = status;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setBatchStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTransientUserData(Object data) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setTransientUserData", new Object[]{data});
        }
        this.transientUserData = data;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setTransientUserData");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" stepId: " + this.stepName);
        buf.append(", stepThreadExecutionId: " + this.getInternalStepThreadExecutionId());
        buf.append(", batchStatus: " + this.batchStatus);
        buf.append(", exitStatus: " + this.exitStatus);
        buf.append(", batchletProcessRetVal: " + this.batchletProcessRetVal);
        buf.append(", transientUserData: " + this.transientUserData);
        buf.append(", persistentUserData: " + this.persistentUserDataObject);
        return buf.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getInternalStepThreadExecutionId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getInternalStepThreadExecutionId", new Object[0]);
        }
        long l = this.internalStepThreadExecutionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getInternalStepThreadExecutionId", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getTopLevelStepExecutionId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getTopLevelStepExecutionId", new Object[0]);
        }
        long l = this.topLevelStepExecutionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getTopLevelStepExecutionId", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Date getStartTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getStartTime", new Object[0]);
        }
        Date date = this.startTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            date = date;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getStartTime", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setStartTime(Date start) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setStartTime", new Object[]{start});
        }
        this.startTime = start;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setStartTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Date getEndTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getEndTime", new Object[0]);
        }
        Date date = this.endTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            date = date;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getEndTime", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEndTime(Date end) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setEndTime", new Object[]{end});
        }
        this.endTime = end;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setEndTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Date getLastUpdatedTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getLastUpdatedTime", new Object[0]);
        }
        Date date = this.lastUpdatedTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            date = date;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getLastUpdatedTime", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setLastUpdatedTime(Date lastUpdatedTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setLastUpdatedTime", new Object[]{lastUpdatedTime});
        }
        this.lastUpdatedTime = lastUpdatedTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setLastUpdatedTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBatchletProcessRetVal() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getBatchletProcessRetVal", new Object[0]);
        }
        String string = this.batchletProcessRetVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getBatchletProcessRetVal", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBatchletProcessRetVal(String batchletProcessRetVal) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setBatchletProcessRetVal", new Object[]{batchletProcessRetVal});
        }
        this.batchletProcessRetVal = batchletProcessRetVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setBatchletProcessRetVal");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepContext getStepContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getStepContext", new Object[0]);
        }
        StepContextImpl stepContextImpl = this.stepCtx;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stepContextImpl = stepContextImpl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "getStepContext", stepContextImpl);
        }
        return stepContextImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setStepContext(StepContextImpl stepCtx) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setStepContext", new Object[]{stepCtx});
        }
        this.stepCtx = stepCtx;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "setStepContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Serializable initializePersistentUserDataObject(byte[] bytesFromDB) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "initializePersistentUserDataObject", new Object[]{bytesFromDB});
        }
        Serializable retVal = null;
        if (bytesFromDB != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytesFromDB);
                ObjectInputStream ois = null;
                try {
                    ois = new TCCLObjectInputStream(bais);
                    retVal = (Serializable)ois.readObject();
                }
                finally {
                    ois.close();
                }
            }
            catch (ClassNotFoundException bais) {
                FFDCFilter.processException((Throwable)bais, (String)"com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", (String)"267", (Object)this, (Object[])new Object[]{bytesFromDB});
                throw new IllegalStateException("Problem while trying to deserialize persistent user data");
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", (String)"269", (Object)this, (Object[])new Object[]{bytesFromDB});
                throw new IllegalStateException("Problem while trying to deserialize persistent user data");
            }
        }
        Serializable serializable = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            serializable = serializable;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeStepExecution", "initializePersistentUserDataObject", serializable);
        }
        return serializable;
    }
}

