/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.classloading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingConfigurationException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.ServiceConfigurationError;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResourceProvider {
    private static final String RESOURCE_LIST_PROPERTY = "resources";
    private Collection<String> resourceNames;
    private ClassLoader bundleLoader;
    private String bundleID;
    static final long serialVersionUID = -4417519677553961161L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    protected void activate(BundleContext bCtx, Map<String, Object> properties) {
        block5: {
            this.bundleID = bCtx.getBundle().getSymbolicName() + "-" + bCtx.getBundle().getVersion();
            this.bundleLoader = ((BundleWiring)bCtx.getBundle().adapt(BundleWiring.class)).getClassLoader();
            try {
                Object prop = properties.get(RESOURCE_LIST_PROPERTY);
                if (prop instanceof String) {
                    String resource = (String)prop;
                    this.resourceNames = Arrays.asList(resource);
                    break block5;
                }
                if (prop instanceof String[]) {
                    String[] resources = (String[])prop;
                    this.resourceNames = Arrays.asList(resources);
                    break block5;
                }
                if (prop == null) {
                    throw new ClassLoadingConfigurationException("Missing property resources");
                }
                throw new ClassLoadingConfigurationException("Unexpected value for property resources=" + prop);
            }
            catch (ClassLoadingConfigurationException prop) {
                void e;
                FFDCFilter.processException((Throwable)prop, (String)"com.ibm.wsspi.classloading.ResourceProvider", (String)"60", (Object)this, (Object[])new Object[]{bCtx, properties});
                throw new ServiceConfigurationError("Incorrectly configured ResourceProvider in bundle " + this.bundleID, (Throwable)e);
            }
        }
    }

    public URL findResource(String resourceName) throws SecurityException {
        return this.bundleLoader.getResource(resourceName);
    }

    public Enumeration<URL> findResources(String resourceName) throws SecurityException, IOException {
        return this.bundleLoader.getResources(resourceName);
    }

    public Collection<String> getResourceNames() {
        return this.resourceNames;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResourceProvider.class);
    }
}

