/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.LibraryAccess;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.library.internal.LibraryPackageExporter;
import com.ibm.ws.library.internal.SharedLibraryImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.equinox.module.ModuleDelegateClassLoaderFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ManagedServiceFactory.class, ModuleDelegateClassLoaderFactory.class, LibraryAccess.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.classloading.sharedlibrary"})
public class SharedLibraryFactory
implements ManagedServiceFactory,
ModuleDelegateClassLoaderFactory,
LibraryAccess {
    public static final String CONT_CACHE = "libcont";
    private static final TraceComponent tc = Tr.register(SharedLibraryFactory.class);
    private final ConcurrentMap<String, SharedLibraryImpl> instances = new ConcurrentHashMap<String, SharedLibraryImpl>();
    private volatile BundleContext ctx;
    private volatile ClassLoadingService classLoadingService;
    private volatile ConfigurationAdmin configAdmin;
    private volatile String resolvedBasePath;
    private final AtomicInteger rankingCounter = new AtomicInteger(0);
    private volatile ArtifactContainerFactory artifactContainerFactory;
    private RegionDigraph digraph;
    private LibraryPackageExporter packageExporter;
    static final long serialVersionUID = 4329172298436585417L;

    @Activate
    protected void activate(BundleContext ctx) {
        this.ctx = ctx;
        this.clearContainerCache();
        File f = this.ctx.getDataFile(CONT_CACHE);
        boolean ok = f.mkdir();
        if (!ok && !FrameworkState.isStopping() && tc.isErrorEnabled()) {
            Tr.error((TraceComponent)tc, (String)"slf.no.cache", (Object[])new Object[0]);
        }
        this.packageExporter = new LibraryPackageExporter(ctx, this.digraph);
    }

    private File clearContainerCache() {
        File f = this.ctx.getDataFile(CONT_CACHE);
        try {
            this.delete(f);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.library.internal.SharedLibraryFactory", (String)"101", (Object)this, (Object[])new Object[0]);
        }
        return f;
    }

    void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
        }
        if (!f.delete() && f.exists() && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"slf.failed.delete", (Object[])new Object[]{f.getAbsolutePath()});
        }
    }

    @Deactivate
    protected void deactivate(BundleContext ctx) {
        for (SharedLibraryImpl instance : this.instances.values()) {
            instance.delete();
        }
        this.instances.clear();
        this.clearContainerCache();
    }

    @Reference
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    @Reference
    protected void setLocationService(WsLocationAdmin locationService) {
        this.resolvedBasePath = locationService.resolveString("${server.config.dir}/");
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
    }

    @Reference
    protected void setClassLoadingService(ClassLoadingService cls) {
        this.classLoadingService = cls;
    }

    protected void unsetClassLoadingService(ClassLoadingService cls) {
        this.classLoadingService = null;
    }

    @Reference
    protected void setArtifactContainerFactory(ArtifactContainerFactory acf) {
        this.artifactContainerFactory = acf;
    }

    protected void unsetArtifactContainerFactory(ArtifactContainerFactory acf) {
        this.artifactContainerFactory = null;
    }

    @Reference
    protected void setDigrah(RegionDigraph digraph) {
        this.digraph = digraph;
    }

    protected void unsetDigraph(RegionDigraph digraph) {
    }

    public void deleted(String pid) {
        SharedLibraryImpl instance = (SharedLibraryImpl)this.instances.remove(pid);
        if (instance != null) {
            instance.delete();
        }
    }

    public String getName() {
        return "SharedLibrary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (FrameworkState.isStopping()) {
            return;
        }
        SharedLibraryImpl existingInstance = (SharedLibraryImpl)this.instances.get(pid);
        int ranking = this.rankingCounter.getAndIncrement();
        properties.put("service.ranking", ranking);
        if (existingInstance == null) {
            SharedLibraryImpl newInstance;
            SharedLibraryImpl sharedLibraryImpl = newInstance = new SharedLibraryImpl(this.ctx, this.classLoadingService, this.configAdmin, this.resolvedBasePath, new ArtifactContainerFactory(){
                static final long serialVersionUID = 7730244564205089330L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public ArtifactContainer getContainer(File workAreaCacheDir, ArtifactContainer parent, ArtifactEntry entry, Object o) {
                    if (SharedLibraryFactory.this.artifactContainerFactory != null) {
                        return SharedLibraryFactory.this.artifactContainerFactory.getContainer(workAreaCacheDir, parent, entry, o);
                    }
                    if (!FrameworkState.isStopping() && tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"slf.no.acf", (Object[])new Object[0]);
                    }
                    return null;
                }

                public ArtifactContainer getContainer(File workAreaCacheDir, Object o) {
                    if (SharedLibraryFactory.this.artifactContainerFactory != null) {
                        return SharedLibraryFactory.this.artifactContainerFactory.getContainer(workAreaCacheDir, o);
                    }
                    if (!FrameworkState.isStopping() && tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"slf.no.acf", (Object[])new Object[0]);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }, this.packageExporter);
            synchronized (sharedLibraryImpl) {
                existingInstance = this.instances.putIfAbsent(pid, newInstance);
                if (existingInstance == null) {
                    newInstance.update(properties);
                    return;
                }
            }
        }
        SharedLibraryImpl sharedLibraryImpl = existingInstance;
        synchronized (sharedLibraryImpl) {
            existingInstance.update(properties);
        }
    }

    public ClassLoader getDelegateClassLoader(Bundle bundle) {
        return this.packageExporter.getDelegateClassLoader(bundle);
    }

    @Override
    public void setPackages(Library library, Collection<String> packageNames, LibraryAccess.PackageVisibility visibility) {
        this.packageExporter.setPackages(library, packageNames, visibility);
    }
}

