/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgMap;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.MFPUnsupportedEncodingRuntimeException;
import com.ibm.ws.sib.mfp.schema.JmsMapBodyAccess;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

final class JsJmsMapMessageImpl
extends JsJmsMessageImpl
implements JsJmsMapMessage {
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static TraceComponent tc;
    private transient JsMsgMap bodyMap;

    JsJmsMapMessageImpl() {
    }

    JsJmsMapMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setFormat("JMS:map");
        this.setBodyType(JmsBodyType.MAP);
        if (flag != 2) {
            this.jmo.getPayloadPart().setPart(1, JmsMapBodyAccess.schema);
            this.getPayload().setChoiceField(2, 0);
        }
        this.bodyMap = null;
    }

    JsJmsMapMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    @Override
    public Object getObject(String name) throws UnsupportedEncodingException {
        return this.getBodyMap().get(name);
    }

    @Override
    public void clearBody() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.getPayload().setChoiceField(2, 0);
        this.bodyMap = new JsMsgMap(null, null);
        this.bodyMap.setChanged();
        this.clearCachedLengths();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    @Override
    int guessPayloadLength() {
        int length = 0;
        try {
            Map<String, Object> payload = this.getBodyMap();
            length = payload.size() * 60;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return length;
    }

    @Override
    int guessFluffedDataSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize");
        }
        int total = 0;
        if (this.bodyMap != null) {
            total += FLUFFED_MAP_OVERHEAD;
            total += this.bodyMap.size() * FLUFFED_MAP_ENTRY_SIZE;
        } else {
            JsMsgPart part = this.getPayloadIfFluffed();
            if (part != null) {
                total += part.estimateFieldValueSize(0) * 2;
            } else {
                int payloadSize = this.jmo.getPayloadPart().getAssembledLengthIfKnown();
                if (payloadSize != -1) {
                    int flatMapSize = payloadSize - 40;
                    int numEnts = flatMapSize / 30;
                    if (numEnts > 0) {
                        total += FLUFFED_MAP_OVERHEAD;
                        total += numEnts * FLUFFED_MAP_ENTRY_SIZE;
                    }
                } else {
                    total += FLUFFED_MAP_OVERHEAD;
                    total += this.getPayload().estimateFieldValueSize(0) * 2;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"guessFluffedDataSize", (Object)total);
        }
        return total;
    }

    JsMsgPart getPayload() {
        return this.getPayload(JmsMapBodyAccess.schema);
    }

    Map<String, Object> getBodyMap() throws UnsupportedEncodingException {
        if (this.bodyMap == null) {
            try {
                List keys = (List)this.getPayload().getField(0);
                List values = (List)this.getPayload().getField(1);
                this.bodyMap = new JsMsgMap(keys, values);
            }
            catch (MFPUnsupportedEncodingRuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsJmsMapMessageImpl.getBodyMap", (String)"152");
                throw (UnsupportedEncodingException)e.getCause();
            }
        }
        return this.bodyMap;
    }

    @Override
    void updateDataFields(int why) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
        super.updateDataFields(why);
        if (this.bodyMap != null && this.bodyMap.isChanged()) {
            this.getPayload().setField(0, this.bodyMap.getKeyList());
            this.getPayload().setField(1, this.bodyMap.getValueList());
            this.bodyMap.setUnChanged();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
    }

    @Override
    public void setBoolean(String name, boolean value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBoolean", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBoolean");
        }
    }

    @Override
    public void setByte(String name, byte value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setByte", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setByte");
        }
    }

    @Override
    public void setShort(String name, short value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setShort", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setShort");
        }
    }

    @Override
    public void setChar(String name, char value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setChar", (Object)Character.valueOf(value));
        }
        this.getBodyMap().put(name, Character.valueOf(value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setChar");
        }
    }

    @Override
    public void setInt(String name, int value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInt", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInt");
        }
    }

    @Override
    public void setLong(String name, long value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLong", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLong");
        }
    }

    @Override
    public void setFloat(String name, float value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFloat", (Object)new Float(value));
        }
        this.getBodyMap().put(name, new Float(value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFloat");
        }
    }

    @Override
    public void setDouble(String name, double value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDouble", (Object)new Double(value));
        }
        this.getBodyMap().put(name, new Double(value));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDouble");
        }
    }

    @Override
    public void setString(String name, String value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setString", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setString");
        }
    }

    @Override
    public void setBytes(String name, byte[] value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBytes", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBytes");
        }
    }

    @Override
    public void setObject(String name, Object value) throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setObject", (Object)value);
        }
        this.getBodyMap().put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setObject");
        }
    }

    @Override
    public Enumeration<String> getMapNames() throws UnsupportedEncodingException {
        return Collections.enumeration(this.getBodyMap().keySet());
    }

    @Override
    public boolean itemExists(String name) throws UnsupportedEncodingException {
        return this.getBodyMap().containsKey(name);
    }

    @Override
    public byte[] getUserFriendlyBytes() throws UnsupportedEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUserFriendlyBytes");
        }
        byte[] result = null;
        Enumeration<String> names = this.getMapNames();
        if (names.hasMoreElements()) {
            StringBuilder buff = new StringBuilder();
            String lineSeparator = System.getProperty("line.separator");
            String name = names.nextElement();
            buff.append(name);
            buff.append("=");
            Object value = this.getObject(name);
            if (value != null) {
                if (!(value instanceof byte[])) {
                    buff.append(value.toString());
                } else {
                    buff.append(new String((byte[])value));
                }
            }
            while (names.hasMoreElements()) {
                buff.append(lineSeparator);
                name = names.nextElement();
                buff.append(name);
                buff.append("=");
                value = this.getObject(name);
                if (value == null) continue;
                if (!(value instanceof byte[])) {
                    buff.append(value.toString());
                    continue;
                }
                buff.append(new String((byte[])value));
            }
            result = buff.toString().getBytes();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUserFriendlyBytes", result);
        }
        return result;
    }

    @Override
    final byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    static {
        tc = SibTr.register(JsJmsMapMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        flattenedClassName = JsJmsMapMessageImpl.flattenClassName(JsJmsMapMessageImpl.class.getName());
    }
}

