/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.util.Util;
import javax.security.auth.Subject;
import org.omg.CSI.IdentityToken;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSITTDistinguishedName
extends TSSSASIdentityToken {
    public static final String OID = "";
    private final String realmName;
    private final String domainName;
    private transient Authenticator authenticator;
    static final long serialVersionUID = 8981990794395797407L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSITTDistinguishedName(String realmName, String domainName) {
        this.realmName = realmName;
        this.domainName = domainName;
        this.authenticator = null;
    }

    public TSSITTDistinguishedName(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.realmName = null;
        this.domainName = null;
    }

    @Override
    public short getType() {
        return 8;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    @FFDCIgnore(value={AuthenticationException.class})
    public Subject check(IdentityToken identityToken, Codec codec) throws SASException {
        Subject identityAssertionSubject = null;
        try {
            String dn = this.getDistinguishedName(identityToken, codec);
            identityAssertionSubject = this.authenticator.authenticate(dn);
        }
        catch (AuthenticationException e) {
            throw new SASInvalidEvidenceException(e.getMessage(), 1229079296);
        }
        return identityAssertionSubject;
    }

    private String getDistinguishedName(IdentityToken identityToken, Codec codec) throws SASException {
        byte[] encodedDN = identityToken.dn();
        return Util.decodeDN(codec, encodedDN);
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSITTDistinguishedName: [\n");
        buf.append(moreSpaces).append("domain: ").append(this.domainName).append("\n");
        buf.append(moreSpaces).append("realm: ").append(this.realmName).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSITTDistinguishedName.class);
    }
}

