/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1InputStream;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class X509NameEntryConverter {
    static final long serialVersionUID = -596323813419024445L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected DERObject convertHexEncoded(String str, int off) throws IOException {
        str = str.toLowerCase();
        byte[] data = new byte[str.length() / 2];
        for (int index = 0; index != data.length; ++index) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
                continue;
            }
            int n = index;
            data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(data));
        return aIn.readObject();
    }

    protected boolean canBePrintable(String str) {
        block3: for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (str.charAt(i) > '\u007f') {
                return false;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') continue;
            switch (ch) {
                case ' ': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '=': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean canBeUTF8(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(X509NameEntryConverter.class);
    }
}

