/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.bundle.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.bundle.internal.BundleArchive;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BundleEntry
implements ArtifactEntry {
    protected final URL bundleUrl;
    protected final BundleArchive rootContainer;
    protected ArtifactContainer enclosingContainer;
    protected ArtifactEntry entryInEnclosingContainer;
    static final long serialVersionUID = -2535969338616132463L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected BundleEntry(URL bundleUrl, BundleArchive rootContainer) {
        this.bundleUrl = bundleUrl;
        this.rootContainer = rootContainer;
    }

    public ArtifactContainer convertToContainer() {
        return this.convertToContainer(false);
    }

    public ArtifactContainer convertToContainer(boolean local) {
        if (!local) {
            File newCacheDir = null;
            String relativeLocation = this.getEnclosingContainer().getPath();
            newCacheDir = relativeLocation.equals("/") ? this.rootContainer.getCacheDir() : new File(this.rootContainer.getCacheDir(), relativeLocation.substring(1));
            return this.rootContainer.getContainerFactory().getContainer(newCacheDir, this.getEnclosingContainer(), (ArtifactEntry)this, (Object)this.bundleUrl);
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.bundleUrl.openStream();
    }

    public long getLastModified() {
        try {
            return this.bundleUrl.openConnection().getLastModified();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.bundle.internal.BundleEntry", (String)"88", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public URL getResource() {
        return this.bundleUrl;
    }

    public long getSize() {
        try {
            return this.bundleUrl.openConnection().getContentLength();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.bundle.internal.BundleEntry", (String)"105", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public ArtifactContainer getEnclosingContainer() {
        if (this.enclosingContainer == null) {
            String parentPath = PathUtils.getParent((String)this.getPath());
            this.enclosingContainer = "/".equals(parentPath) ? this.rootContainer : this.rootContainer.getEntry(parentPath).convertToContainer();
        }
        return this.enclosingContainer;
    }

    public String getPath() {
        return this.bundleUrl.getPath();
    }

    public String getPhysicalPath() {
        return null;
    }

    public ArtifactContainer getRoot() {
        return this.rootContainer;
    }

    public String getName() {
        return PathUtils.getName((String)this.getPath());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BundleEntry.class);
    }
}

