/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JAXBAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBAttachmentUnmarshaller.class);
    private Collection<Attachment> attachments;
    static final long serialVersionUID = 8082795032380840945L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBAttachmentUnmarshaller(Collection<Attachment> attachments) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "<init>", new Object[]{attachments});
        }
        this.attachments = attachments;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataHandler getAttachmentAsDataHandler(String contentId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "getAttachmentAsDataHandler", new Object[]{contentId});
        }
        DataHandler dataHandler = new DataHandler(AttachmentUtil.getAttachmentDataSource((String)contentId, this.attachments));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataHandler = dataHandler;
            LOG.exiting("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "getAttachmentAsDataHandler", dataHandler);
        }
        return dataHandler;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public byte[] getAttachmentAsByteArray(String contentId) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "getAttachmentAsByteArray", new Object[]{contentId});
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream is = AttachmentUtil.getAttachmentDataSource((String)contentId, this.attachments).getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            is.close();
            bos.close();
        }
        catch (IOException is) {
            void e;
            FFDCFilter.processException((Throwable)is, (String)"org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", (String)"61", (Object)((Object)this), (Object[])new Object[]{contentId});
            throw new Fault(new Message("ATTACHMENT_READ_ERROR", LOG, new Object[0]), (Throwable)e);
        }
        byte[] byArray = bos.toByteArray();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            byArray = byArray;
            LOG.exiting("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "getAttachmentAsByteArray", byArray);
        }
        return byArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isXOPPackage() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "isXOPPackage", new Object[0]);
        }
        boolean bl = this.attachments != null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.attachment.JAXBAttachmentUnmarshaller", "isXOPPackage", bl);
        }
        return bl;
    }
}

