/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.specification.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Aggregate;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.specification.ClassSource_Specification_Direct_WAR;
import com.ibm.ws.anno.classsource.specification.internal.ClassSourceImpl_Specification_Direct;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_Specification_Direct_WAR
extends ClassSourceImpl_Specification_Direct
implements ClassSource_Specification_Direct_WAR {
    protected String warClassesPath;
    protected String warLibraryPath;
    protected boolean useWARLibraryJarPaths;
    protected List<String> warLibraryJarPaths;
    protected Set<String> warIncludedJarPaths;
    static final long serialVersionUID = -5120393326244279526L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_Specification_Direct_WAR(ClassSourceImpl_Factory factory) {
        super(factory);
    }

    @Override
    public String getWARClassesPath() {
        return this.warClassesPath;
    }

    @Override
    public void setWARClassesPath(String warClassesPath) {
        this.warClassesPath = warClassesPath;
    }

    @Override
    public String getWARLibraryPath() {
        return this.warLibraryPath;
    }

    @Override
    public void setWARLibraryPath(String warLibraryPath) {
        this.warLibraryPath = warLibraryPath;
    }

    @Override
    public boolean getUseWARLibraryJarPaths() {
        return this.useWARLibraryJarPaths;
    }

    @Override
    public void setUseWARLibraryJarPaths(boolean useWARLibraryJarPaths) {
        this.useWARLibraryJarPaths = useWARLibraryJarPaths;
    }

    @Override
    public List<String> getWARLibraryJarPaths() {
        return this.warLibraryJarPaths;
    }

    @Override
    public void addWARLibraryJarPath(String warLibraryJarPath) {
        if (this.warLibraryJarPaths == null) {
            this.warLibraryJarPaths = new ArrayList<String>();
        }
        this.warLibraryJarPaths.add(warLibraryJarPath);
    }

    @Override
    public void addWARLibraryJarPaths(List<String> warLibraryJarPaths) {
        if (this.warLibraryJarPaths == null) {
            this.warLibraryJarPaths = new ArrayList<String>();
        }
        this.warLibraryJarPaths.addAll(warLibraryJarPaths);
    }

    @Override
    public Set<String> getWARIncludedJarPaths() {
        return this.warIncludedJarPaths;
    }

    @Override
    public void addWARIncludedJarPath(String warIncludedJarPath) {
        if (this.warIncludedJarPaths == null) {
            this.warIncludedJarPaths = new HashSet<String>();
        }
        this.warIncludedJarPaths.add(warIncludedJarPath);
    }

    @Override
    public void addWARIncludedJarPaths(Set<String> warIncludedJarPaths) {
        if (this.warIncludedJarPaths == null) {
            this.warIncludedJarPaths = new HashSet<String>();
        }
        this.warIncludedJarPaths.addAll(warIncludedJarPaths);
    }

    @Override
    public ClassSource_Aggregate createClassSource(String targetName, ClassLoader rootClassLoader) throws ClassSource_Exception {
        List<String> warLibJarPaths;
        ClassSourceImpl_Aggregate classSource = this.createAggregateClassSource(targetName);
        String useWARClassesPath = this.getWARClassesPath();
        if (useWARClassesPath == null) {
            useWARClassesPath = this.getImmediatePath() + "/WEB-INF/classes";
        }
        this.getFactory().addDirectoryClassSource(classSource, targetName, useWARClassesPath, ClassSource_Aggregate.ScanPolicy.SEED);
        if (this.getUseWARLibraryJarPaths()) {
            warLibJarPaths = this.getWARLibraryJarPaths();
        } else {
            String useWARLibPath = this.getWARLibraryPath();
            if (useWARLibPath == null) {
                useWARLibPath = this.getImmediatePath() + "/WEB-INF/lib";
            }
            warLibJarPaths = this.selectJars(useWARLibPath);
        }
        Set<String> useWARIncludedJarPaths = this.getWARIncludedJarPaths();
        if (warLibJarPaths != null) {
            for (String nextJarPath : warLibJarPaths) {
                boolean isSeed = useWARIncludedJarPaths == null || useWARIncludedJarPaths.contains(nextJarPath);
                ClassSource_Aggregate.ScanPolicy scanPolicy = isSeed ? ClassSource_Aggregate.ScanPolicy.SEED : ClassSource_Aggregate.ScanPolicy.EXTERNAL;
                this.getFactory().addJarClassSource(classSource, nextJarPath, nextJarPath, scanPolicy);
            }
        }
        this.addStandardClassSources(targetName, rootClassLoader, classSource);
        return classSource;
    }

    @Override
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class source specification [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.logLocations(logger);
        this.logCommon(logger);
    }

    protected void logLocations(TraceComponent logger) {
        String useWARClassesPath = this.getWARClassesPath();
        if (useWARClassesPath == null) {
            useWARClassesPath = this.getImmediatePath() + "/WEB-INF/classes";
        }
        Tr.debug((TraceComponent)logger, (String)("Classes path [ " + useWARClassesPath + " ]"), (Object[])new Object[0]);
        if (this.getUseWARLibraryJarPaths()) {
            List<String> warLibJarPaths = this.getWARLibraryJarPaths();
            if (warLibJarPaths != null) {
                for (String nextJarPath : warLibJarPaths) {
                    Tr.debug((TraceComponent)logger, (String)("WAR library jar [ " + nextJarPath + " ]"), (Object[])new Object[0]);
                }
            }
        } else {
            String useWARLibPath = this.getWARLibraryPath();
            if (useWARLibPath == null) {
                useWARLibPath = this.getImmediatePath() + "/WEB-INF/lib";
            }
            Tr.debug((TraceComponent)logger, (String)("WAR library path [ " + useWARLibPath + " ]"), (Object[])new Object[0]);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClassSourceImpl_Specification_Direct_WAR.class);
    }
}

