/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.extender.Elector;
import com.ibm.wsspi.collective.singleton.extender.SingletonServiceExtender;
import com.ibm.wsspi.collective.singleton.extender.exceptions.ElectorException;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractElector
implements Elector {
    private SingletonServiceExtender service;
    private ServiceEndpointIdentity leader;
    private ServiceEndpointIdentity localCandidate;
    private ServiceEndpointIdentity localParticipant;
    private final Set<ServiceEndpointIdentity> candidateIdentities = new HashSet<ServiceEndpointIdentity>();
    private final Set<ServiceEndpointIdentity> participantIdentities = new HashSet<ServiceEndpointIdentity>();
    static final long serialVersionUID = 6797432171621486697L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setSingletonService(SingletonServiceExtender service) {
        this.service = service;
    }

    public abstract void start() throws ElectorException;

    public abstract void stop() throws ElectorException;

    public ServiceEndpointIdentity getLeader() {
        return this.leader;
    }

    public Set<ServiceEndpointIdentity> getParticipants() {
        return this.participantIdentities;
    }

    public Set<ServiceEndpointIdentity> getCandidates() {
        return this.candidateIdentities;
    }

    public void participantRegistered(ServiceEndpointIdentity participant) throws ElectorException {
        this.localParticipant = participant;
        this.participantIdentities.add(participant);
    }

    public void participantUnregistered(ServiceEndpointIdentity participant) throws ElectorException {
        this.participantIdentities.remove(participant);
        this.localParticipant = null;
    }

    public void candidateRegistered(ServiceEndpointIdentity candidate) throws ElectorException {
        this.localCandidate = candidate;
        this.candidateIdentities.add(candidate);
    }

    public void candidateUnregistered(ServiceEndpointIdentity candidate) throws ElectorException {
        this.candidateIdentities.remove(candidate);
        this.localCandidate = null;
    }

    public String getIdentity() {
        return "unnamed";
    }

    protected void addParticipant(ServiceEndpointIdentity participant) {
        this.participantIdentities.add(participant);
        this.service.participantRegistered(participant);
    }

    protected void removeParticipant(ServiceEndpointIdentity participant) {
        this.participantIdentities.remove(participant);
        this.service.participantUnregistered(participant);
    }

    protected void addCandidate(ServiceEndpointIdentity candidate) {
        this.candidateIdentities.add(candidate);
        this.service.candidateRegistered(candidate);
    }

    protected void removeCandidate(ServiceEndpointIdentity candidate) {
        this.candidateIdentities.remove(candidate);
        this.service.candidateUnregistered(candidate);
    }

    protected ServiceEndpointIdentity getLocalParticipant() {
        return this.localParticipant;
    }

    protected ServiceEndpointIdentity getLocalCandidate() {
        return this.localCandidate;
    }

    protected void setLeader(ServiceEndpointIdentity id) {
        if (id != null) {
            this.service.leaderElected(id);
        } else {
            this.service.leaderUnelected(this.leader);
        }
        this.leader = id;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AbstractElector.class);
    }
}

